/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemHandlerItemStackIterator;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.commoncapabilities.api.ingredient.storage.IngredientComponentStorageEmpty;
import org.cyclops.commoncapabilities.capability.itemhandler.SlotlessItemHandlerConfig;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;

public class IngredientComponentStorageWrapperHandlerItemStack
implements IIngredientComponentStorageWrapperHandler<ItemStack, Integer, IItemHandler> {
    private final IngredientComponent<ItemStack, Integer> ingredientComponent;

    public IngredientComponentStorageWrapperHandlerItemStack(IngredientComponent<ItemStack, Integer> ingredientComponent) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
    }

    @Override
    public IIngredientComponentStorage<ItemStack, Integer> wrapComponentStorage(IItemHandler storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    public IIngredientComponentStorage<ItemStack, Integer> wrapComponentStorage(IItemHandler storage, ISlotlessItemHandler slotlessStorage) {
        return new ComponentStorageWrapperCombined(this.getComponent(), storage, slotlessStorage);
    }

    @Override
    public IItemHandler wrapStorage(IIngredientComponentStorage<ItemStack, Integer> componentStorage) {
        if (componentStorage instanceof IIngredientComponentStorageSlotted) {
            return new ItemStorageWrapperSlotted(this.getComponent(), (IIngredientComponentStorageSlotted)componentStorage);
        }
        return new ItemStorageWrapper(this.getComponent(), componentStorage);
    }

    @Override
    public LazyOptional<IItemHandler> getStorage(ICapabilityProvider capabilityProvider, @Nullable Direction facing) {
        return capabilityProvider.getCapability(ForgeCapabilities.ITEM_HANDLER, facing);
    }

    @Override
    public IIngredientComponentStorage<ItemStack, Integer> getComponentStorage(ICapabilityProvider capabilityProvider, @Nullable Direction facing) {
        LazyOptional<IItemHandler> storageSlotted = this.getStorage(capabilityProvider, facing);
        LazyOptional storageSlotless = capabilityProvider.getCapability(SlotlessItemHandlerConfig.CAPABILITY, facing);
        if (storageSlotted.isPresent()) {
            if (storageSlotless.isPresent()) {
                return this.wrapComponentStorage((IItemHandler)storageSlotted.orElse(null), (ISlotlessItemHandler)storageSlotless.orElse(null));
            }
            return this.wrapComponentStorage((IItemHandler)storageSlotted.orElse(null));
        }
        return new IngredientComponentStorageEmpty<ItemStack, Integer>(this.getComponent());
    }

    @Override
    public IngredientComponent<ItemStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorageSlotted<ItemStack, Integer> {
        private final IngredientComponent<ItemStack, Integer> ingredientComponent;
        private final IItemHandler storage;

        public ComponentStorageWrapper(IngredientComponent<ItemStack, Integer> ingredientComponent, IItemHandler storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<ItemStack, Integer> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return new ItemHandlerItemStackIterator(this.storage);
        }

        @Override
        public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchFlags) {
            if (this.getComponent().getMatcher().getAnyMatchCondition().equals(matchFlags)) {
                return this.iterator();
            }
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            long sum = 0L;
            int slots = this.storage.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                sum = Math.addExact(sum, (long)this.storage.getSlotLimit(slot));
            }
            return sum;
        }

        @Override
        public ItemStack insert(@Nonnull ItemStack ingredient, boolean simulate) {
            return ItemHandlerHelper.insertItem((IItemHandler)this.storage, (ItemStack)ingredient, (boolean)simulate);
        }

        @Override
        public ItemStack extract(@Nonnull ItemStack prototype, Integer matchFlags, boolean simulate) {
            int slots = this.storage.getSlots();
            boolean checkStackSize = (matchFlags & 8) > 0;
            int requiredStackSize = prototype.m_41613_();
            IngredientHashMap validInstancesCollapsed = new IngredientHashMap(this.getComponent());
            int subMatchFlags = matchFlags & 0xFFFFFFF7;
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack extractedSimulated = this.storageExtractItem(slot, requiredStackSize, true);
                if (extractedSimulated.m_41619_() || !this.getComponent().getMatcher().matches(prototype, extractedSimulated, subMatchFlags)) continue;
                ItemStack storagePrototype = this.getComponent().getMatcher().withQuantity(extractedSimulated, 1L);
                Pair existingValue = (Pair)validInstancesCollapsed.get((Object)storagePrototype);
                if (existingValue == null) {
                    existingValue = Pair.of((Object)new Wrapper((Object)0), (Object)Lists.newLinkedList());
                    validInstancesCollapsed.put((Object)storagePrototype, (Object)existingValue);
                }
                int newCount = (Integer)((Wrapper)existingValue.getLeft()).get() + extractedSimulated.m_41613_();
                ((Wrapper)existingValue.getLeft()).set((Object)newCount);
                ((List)existingValue.getRight()).add(slot);
                if (newCount < requiredStackSize) continue;
                ((Wrapper)existingValue.getLeft()).set((Object)requiredStackSize);
                return this.finalizeExtraction(storagePrototype, (Pair<Wrapper<Integer>, List<Integer>>)existingValue, requiredStackSize, simulate);
            }
            if (checkStackSize) {
                return ItemStack.f_41583_;
            }
            Pair maxValue = Pair.of((Object)new Wrapper((Object)0), (Object)Lists.newArrayList());
            ItemStack maxInstance = ItemStack.f_41583_;
            for (Map.Entry entry : validInstancesCollapsed) {
                if ((Integer)((Wrapper)((Pair)entry.getValue()).getLeft()).get() <= (Integer)((Wrapper)maxValue.getLeft()).get()) continue;
                maxInstance = (ItemStack)entry.getKey();
                maxValue = (Pair)entry.getValue();
            }
            return this.finalizeExtraction(maxInstance, (Pair<Wrapper<Integer>, List<Integer>>)maxValue, requiredStackSize, simulate);
        }

        protected ItemStack finalizeExtraction(ItemStack instancePrototype, Pair<Wrapper<Integer>, List<Integer>> value, int requiredQuantity, boolean simulate) {
            long extractedCount = ((Integer)((Wrapper)value.getLeft()).get()).intValue();
            if (!simulate && extractedCount > 0L) {
                int toExtract = requiredQuantity;
                for (Integer finalSlot : (List)value.getRight()) {
                    ItemStack extractedActual = this.storageExtractItem(finalSlot, toExtract, false);
                    toExtract -= extractedActual.m_41613_();
                }
                if ((long)toExtract != (long)requiredQuantity - extractedCount) {
                    throw new IllegalStateException("An item storage resulted in inconsistent simulated and non-simulated output.");
                }
            }
            return this.getComponent().getMatcher().withQuantity(instancePrototype, extractedCount);
        }

        @Override
        public ItemStack extract(long maxQuantity, boolean simulate) {
            int slots = this.storage.getSlots();
            int amount = Helpers.castSafe((long)maxQuantity);
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack extractedSimulated = this.storageExtractItem(slot, amount, true);
                if (extractedSimulated.m_41619_()) continue;
                return simulate ? extractedSimulated : this.storageExtractItem(slot, amount, false);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlots() {
            return this.storage.getSlots();
        }

        @Override
        public ItemStack getSlotContents(int slot) {
            return this.storage.getStackInSlot(slot);
        }

        @Override
        public long getMaxQuantity(int slot) {
            return this.storage.getSlotLimit(slot);
        }

        @Override
        public ItemStack insert(int slot, @Nonnull ItemStack ingredient, boolean simulate) {
            return this.storage.insertItem(slot, ingredient, simulate);
        }

        @Override
        public ItemStack extract(int slot, long maxQuantity, boolean simulate) {
            return this.storageExtractItem(slot, Helpers.castSafe((long)maxQuantity), simulate);
        }

        protected ItemStack storageExtractItem(int slot, int amount, boolean simulate) {
            int maxStackSize = ItemStack.f_41583_.m_41741_();
            if (amount > maxStackSize && this.storage.getSlotLimit(slot) > maxStackSize) {
                ItemStack extractedPartial;
                if (simulate) {
                    ItemStack extractedUntilMaxStackSize = this.storage.extractItem(slot, maxStackSize, true);
                    if (extractedUntilMaxStackSize.m_41613_() < maxStackSize) {
                        return extractedUntilMaxStackSize;
                    }
                    ItemStack stackInSlot = this.storage.getStackInSlot(slot).m_41777_();
                    if (stackInSlot.m_41613_() > amount) {
                        stackInSlot.m_41764_(amount);
                    }
                    return stackInSlot;
                }
                ItemStack bufferExtracted = ItemStack.f_41583_;
                while (bufferExtracted.m_41613_() < amount && !(extractedPartial = this.storage.extractItem(slot, Math.min(amount - bufferExtracted.m_41613_(), maxStackSize), false)).m_41619_()) {
                    if (bufferExtracted.m_41619_()) {
                        bufferExtracted = extractedPartial;
                        continue;
                    }
                    bufferExtracted.m_41764_(bufferExtracted.m_41613_() + extractedPartial.m_41613_());
                }
                return bufferExtracted;
            }
            return this.storage.extractItem(slot, amount, simulate);
        }
    }

    public static class ComponentStorageWrapperCombined
    extends ComponentStorageWrapper {
        private final ISlotlessItemHandler storageSlotless;

        public ComponentStorageWrapperCombined(IngredientComponent<ItemStack, Integer> ingredientComponent, IItemHandler storage, ISlotlessItemHandler storageSlotless) {
            super(ingredientComponent, storage);
            this.storageSlotless = storageSlotless;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return this.storageSlotless.getItems();
        }

        @Override
        public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchFlags) {
            return this.storageSlotless.findItems(prototype, matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            return this.storageSlotless.getLimit();
        }

        @Override
        public ItemStack insert(@Nonnull ItemStack ingredient, boolean simulate) {
            return this.storageSlotless.insertItem(ingredient, simulate);
        }

        @Override
        public ItemStack extract(long maxQuantity, boolean simulate) {
            return this.storageSlotless.extractItem(Helpers.castSafe((long)maxQuantity), simulate);
        }

        @Override
        public ItemStack extract(@Nonnull ItemStack prototype, Integer matchFlags, boolean simulate) {
            return this.storageSlotless.extractItem(prototype, matchFlags, simulate);
        }
    }

    public static class ItemStorageWrapperSlotted
    implements IItemHandler {
        private final IngredientComponent<ItemStack, Integer> ingredientComponent;
        private final IIngredientComponentStorageSlotted<ItemStack, Integer> storage;

        public ItemStorageWrapperSlotted(IngredientComponent<ItemStack, Integer> ingredientComponent, IIngredientComponentStorageSlotted<ItemStack, Integer> storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        public int getSlots() {
            return this.storage.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.storage.getSlotContents(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.storage.insert(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.storage.extract(slot, (long)amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return Helpers.castSafe((long)this.storage.getMaxQuantity(slot));
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }

    public static class ItemStorageWrapper
    implements IItemHandler {
        private final IngredientComponent<ItemStack, Integer> ingredientComponent;
        private final IIngredientComponentStorage<ItemStack, Integer> storage;

        public ItemStorageWrapper(IngredientComponent<ItemStack, Integer> ingredientComponent, IIngredientComponentStorage<ItemStack, Integer> storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        public int getSlots() {
            return Iterators.size(this.storage.iterator()) + 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            try {
                return (ItemStack)Iterators.get(this.storage.iterator(), (int)slot);
            }
            catch (IndexOutOfBoundsException e) {
                return ItemStack.f_41583_;
            }
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.storage.insert(stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack slotItem = (ItemStack)Iterators.get(this.storage.iterator(), (int)slot, (Object)ItemStack.f_41583_);
            if (slotItem.m_41619_()) {
                return slotItem;
            }
            return this.storage.extract(this.ingredientComponent.getMatcher().withQuantity(slotItem, amount), this.ingredientComponent.getMatcher().getExactMatchNoQuantityCondition(), simulate);
        }

        public int getSlotLimit(int slot) {
            return Helpers.castSafe((long)this.ingredientComponent.getMatcher().getMaximumQuantity());
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

