/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class PrototypedIngredientAlternativesList<T, M>
implements IPrototypedIngredientAlternatives<T, M> {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<IPrototypedIngredient<T, M>> alternatives;

    public PrototypedIngredientAlternativesList(List<IPrototypedIngredient<T, M>> alternatives) {
        this.alternatives = alternatives;
    }

    @Override
    public Collection<IPrototypedIngredient<T, M>> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public IPrototypedIngredientAlternatives.ISerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean equals(Object obj) {
        return obj instanceof IPrototypedIngredientAlternatives && this.getAlternatives().equals(((IPrototypedIngredientAlternatives)obj).getAlternatives());
    }

    public int hashCode() {
        int inputsHash = 333;
        for (IPrototypedIngredient<T, M> value : this.getAlternatives()) {
            inputsHash |= value.hashCode();
        }
        return 0x4D3 | inputsHash << 2;
    }

    public String toString() {
        return "[PrototypedIngredientAlternativesList: " + this.alternatives.toString() + "]";
    }

    public static class Serializer
    implements IPrototypedIngredientAlternatives.ISerializer<PrototypedIngredientAlternativesList<?, ?>> {
        @Override
        public byte getId() {
            return 0;
        }

        @Override
        public <T, M> Tag serialize(IngredientComponent<T, M> ingredientComponent, PrototypedIngredientAlternativesList<?, ?> alternatives) {
            ListTag prototypes = new ListTag();
            IIngredientSerializer serializer = ingredientComponent.getSerializer();
            for (IPrototypedIngredient prototypedIngredient : alternatives.alternatives) {
                CompoundTag prototypeTag = new CompoundTag();
                prototypeTag.m_128365_("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
                prototypeTag.m_128365_("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
                prototypes.add((Object)prototypeTag);
            }
            return prototypes;
        }

        @Override
        public <T, M> PrototypedIngredientAlternativesList<?, ?> deserialize(IngredientComponent<T, M> ingredientComponent, Tag tag) {
            String componentName = ingredientComponent.getName().toString();
            ListTag instancesTag = (ListTag)tag;
            ArrayList instances = Lists.newArrayList();
            IIngredientSerializer<T, M> serializer = ingredientComponent.getSerializer();
            for (Tag prototypeTag : instancesTag) {
                if (!(prototypeTag instanceof CompoundTag)) {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid sublist with NBTTagCompunds");
                }
                CompoundTag safePrototypeTag = (CompoundTag)prototypeTag;
                if (!safePrototypeTag.m_128441_("prototype")) {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid sublist with a prototype entry");
                }
                if (!safePrototypeTag.m_128441_("condition")) {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid sublist with a condition entry");
                }
                instances.add(new PrototypedIngredient<T, M>(ingredientComponent, serializer.deserializeInstance(safePrototypeTag.m_128423_("prototype")), serializer.deserializeCondition(safePrototypeTag.m_128423_("condition"))));
            }
            return new PrototypedIngredientAlternativesList(instances);
        }
    }
}

