/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.addons.jei.CropDisplayCategory;
import net.darkhax.botanypots.addons.jei.ui.BasicCropDisplayInfo;
import net.darkhax.botanypots.addons.jei.ui.CropDisplayInfo;
import net.darkhax.botanypots.data.recipes.crop.BasicCrop;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("botanypots", "jei_support");
    public static final RecipeType<CropDisplayInfo> SOIL = RecipeType.create((String)"botanypots", (String)"soil", CropDisplayInfo.class);
    public static final RecipeType<CropDisplayInfo> CROP = RecipeType.create((String)"botanypots", (String)"crop", CropDisplayInfo.class);
    public static final RecipeType<PotInteraction> POT_INTERACTION = RecipeType.create((String)"botanypots", (String)"pot_interaction", PotInteraction.class);
    public static final RecipeType<Fertilizer> FERTILIZER = RecipeType.create((String)"botanypots", (String)"fertilizer", Fertilizer.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper gui = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CropDisplayCategory(gui, SOIL)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CropDisplayCategory(gui, CROP)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("botanypots", "terracotta_botany_pot"))).m_7968_(), new RecipeType[]{CROP});
        registration.addRecipeCatalyst(((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("botanypots", "terracotta_hopper_botany_pot"))).m_7968_(), new RecipeType[]{CROP});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List soils = BotanyPotHelper.getAllRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)BotanyPotHelper.SOIL_TYPE.get());
        List<Crop> crops = BotanyPotHelper.getAllRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)BotanyPotHelper.CROP_TYPE.get());
        crops.forEach(crop -> {
            if (crop instanceof BasicCrop) {
                BasicCrop basic = (BasicCrop)((Object)crop);
                registration.addRecipes(CROP, BasicCropDisplayInfo.getCropRecipes(basic, soils));
            }
        });
    }
}

