/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;

public abstract class AbstractModonomiconLanguageProvider
implements ModonomiconLanguageProvider,
DataProvider {
    private final Map<String, String> data = new TreeMap<String, String>();
    private final PackOutput output;
    private final String modid;
    private final String locale;
    private final ModonomiconLanguageProvider cachedProvider;

    public AbstractModonomiconLanguageProvider(PackOutput output, String modid, String locale, ModonomiconLanguageProvider cachedProvider) {
        this.output = output;
        this.modid = modid;
        this.locale = locale;
        this.cachedProvider = cachedProvider;
    }

    public AbstractModonomiconLanguageProvider(PackOutput output, String modid, String locale) {
        this(output, modid, locale, null);
    }

    @Override
    public String locale() {
        return this.locale;
    }

    protected abstract void addTranslations();

    @Override
    public Map<String, String> data() {
        return this.data;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addTranslations();
        if (this.cachedProvider != null && !this.cachedProvider.data().isEmpty()) {
            this.data.putAll(this.cachedProvider.data());
        }
        if (!this.data.isEmpty()) {
            return this.save(cache, this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("lang").resolve(this.locale + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String m_6055_() {
        return "Languages: " + this.locale;
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        this.data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    @Override
    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    @Override
    public void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    @Override
    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    @Override
    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    @Override
    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    @Override
    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    @Override
    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    @Override
    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    @Override
    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    @Override
    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    @Override
    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    @Override
    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    @Override
    public void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

