/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.spells.lightning_lance.LightningLanceRenderer;
import io.redspace.ironsspellbooks.entity.spells.magic_arrow.MagicArrowRenderer;
import io.redspace.ironsspellbooks.entity.spells.poison_arrow.PoisonArrowRenderer;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class ChargeSpellLayer {
    public static HumanoidArm getArmFromUseHand(LivingEntity livingEntity) {
        return livingEntity.m_7655_() == InteractionHand.MAIN_HAND ? livingEntity.m_5737_() : livingEntity.m_5737_().m_20828_();
    }

    public static class Geo
    extends GeoRenderLayer<AbstractSpellCastingMob> {
        public Geo(GeoEntityRenderer<AbstractSpellCastingMob> entityRenderer) {
            super(entityRenderer);
        }

        public void render(PoseStack poseStack, AbstractSpellCastingMob entity, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            boolean flag;
            SyncedSpellData syncedSpellData = ClientMagicData.getSyncedSpellData((LivingEntity)entity);
            String spellId = syncedSpellData.getCastingSpellId();
            GeoBone bone = (GeoBone)bakedModel.getBone("bipedHandRight").get();
            poseStack.m_85836_();
            RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)((CoreGeoBone)bakedModel.getBone("right_arm").get()));
            RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
            HumanoidArm arm = ChargeSpellLayer.getArmFromUseHand((LivingEntity)entity);
            boolean bl = flag = arm == HumanoidArm.LEFT;
            if (spellId.equals(((AbstractSpell)SpellRegistry.LIGHTNING_LANCE_SPELL.get()).getSpellId())) {
                poseStack.m_85837_(-((double)((float)(flag ? -1 : 1) / 32.0f) - 0.125), 0.5, 0.0);
                poseStack.m_252880_(0.0f, -bone.getPivotY() / 16.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                LightningLanceRenderer.renderModel(poseStack, bufferSource, entity.f_19797_);
            } else if (spellId.equals(((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get()).getSpellId())) {
                poseStack.m_252880_(0.0f, -bone.getPivotY() / 16.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_85837_((double)(-((float)(flag ? -1 : 1) / 32.0f)), 0.5, -0.55);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                MagicArrowRenderer.renderModel(poseStack, bufferSource);
            } else if (spellId.equals(((AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get()).getSpellId())) {
                poseStack.m_252880_(0.0f, -bone.getPivotY() / 16.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_85837_((double)(-((float)(flag ? -1 : 1) / 32.0f)), 0.5, -0.55);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                PoisonArrowRenderer.renderModel(poseStack, bufferSource, packedLight);
            }
            poseStack.m_85849_();
        }
    }

    public static class Vanilla<T extends LivingEntity, M extends HumanoidModel<T>>
    extends RenderLayer<T, M> {
        public Vanilla(RenderLayerParent<T, M> pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            boolean flag;
            SyncedSpellData syncedSpellData = ClientMagicData.getSyncedSpellData(entity);
            if (!syncedSpellData.isCasting()) {
                return;
            }
            String spellId = syncedSpellData.getCastingSpellId();
            poseStack.m_85836_();
            HumanoidArm arm = ChargeSpellLayer.getArmFromUseHand(entity);
            ((HumanoidModel)this.m_117386_()).m_6002_(arm, poseStack);
            boolean bl = flag = arm == HumanoidArm.LEFT;
            if (spellId.equals(((AbstractSpell)SpellRegistry.LIGHTNING_LANCE_SPELL.get()).getSpellId())) {
                poseStack.m_85837_((double)((float)(flag ? -1 : 1) / 32.0f) - 0.125, 0.5, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                float castCompletion = Utils.smoothstep(0.35f, 1.0f, ClientMagicData.getCastCompletionPercent());
                poseStack.m_85841_(castCompletion, castCompletion, castCompletion);
                LightningLanceRenderer.renderModel(poseStack, bufferSource, ((LivingEntity)entity).f_19797_);
            } else if (spellId.equals(((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get()).getSpellId())) {
                poseStack.m_85837_((double)((float)(flag ? -1 : 1) / 32.0f), 0.5, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                float castCompletion = Utils.smoothstep(0.65f, 1.0f, ClientMagicData.getCastCompletionPercent());
                poseStack.m_85841_(castCompletion, castCompletion, castCompletion);
                MagicArrowRenderer.renderModel(poseStack, bufferSource);
            } else if (spellId.equals(((AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get()).getSpellId())) {
                poseStack.m_252880_((float)(flag ? -1 : 1) / 32.0f, 1.0f, 0.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                float castCompletion = Utils.smoothstep(0.65f, 1.0f, ClientMagicData.getCastCompletionPercent());
                poseStack.m_85841_(castCompletion, castCompletion, castCompletion);
                PoisonArrowRenderer.renderModel(poseStack, bufferSource, pPackedLight);
            }
            poseStack.m_85849_();
        }
    }
}

