/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.loot.SpellFilter;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CreateSpellBookCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.irons_spellbooks.create_spell_book.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"createSpellBook").requires(p_138819_ -> p_138819_.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"slots", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(commandContext -> CreateSpellBookCommand.crateSpellBook((CommandSourceStack)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"slots")))).then(Commands.m_82127_((String)"randomize").executes(commandContext -> CreateSpellBookCommand.crateRandomSpellBook((CommandSourceStack)commandContext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"slots"))))));
    }

    private static int crateSpellBook(CommandSourceStack source, int slots) throws CommandSyntaxException {
        ServerPlayer serverPlayer = source.m_230896_();
        if (serverPlayer != null) {
            ItemStack itemstack = new ItemStack((ItemLike)ItemRegistry.WIMPY_SPELL_BOOK.get());
            ISpellContainer spellContainer = ISpellContainer.create(slots, true, true);
            spellContainer.save(itemstack);
            if (serverPlayer.m_150109_().m_36054_(itemstack)) {
                return 1;
            }
        }
        throw ERROR_FAILED.create();
    }

    private static int crateRandomSpellBook(CommandSourceStack source, int slots) throws CommandSyntaxException {
        ServerPlayer serverPlayer = source.m_230896_();
        if (serverPlayer != null) {
            ItemStack itemstack = new ItemStack((ItemLike)ItemRegistry.WIMPY_SPELL_BOOK.get());
            ISpellContainer spellContainer = ISpellContainer.create(slots, true, true);
            for (int i = 0; i < slots; ++i) {
                AbstractSpell spell;
                while (!spellContainer.addSpell(spell = new SpellFilter().getRandomSpell(source.m_81372_().f_46441_), source.m_81372_().f_46441_.m_216332_(1, spell.getMaxLevel()), false, null)) {
                }
            }
            spellContainer.save(itemstack);
            if (serverPlayer.m_150109_().m_36054_(itemstack)) {
                return 1;
            }
        }
        throw ERROR_FAILED.create();
    }
}

