/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.registry;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.damage.ISSDamageTypes;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ModTags;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class SchoolRegistry {
    public static final ResourceKey<Registry<SchoolType>> SCHOOL_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("irons_spellbooks", "schools"));
    private static final DeferredRegister<SchoolType> SCHOOLS = DeferredRegister.create(SCHOOL_REGISTRY_KEY, (String)"irons_spellbooks");
    public static final Supplier<IForgeRegistry<SchoolType>> REGISTRY = SCHOOLS.makeRegistry(() -> new RegistryBuilder().disableSaving().disableOverrides());
    public static final ResourceLocation FIRE_RESOURCE = IronsSpellbooks.id("fire");
    public static final ResourceLocation ICE_RESOURCE = IronsSpellbooks.id("ice");
    public static final ResourceLocation LIGHTNING_RESOURCE = IronsSpellbooks.id("lightning");
    public static final ResourceLocation HOLY_RESOURCE = IronsSpellbooks.id("holy");
    public static final ResourceLocation ENDER_RESOURCE = IronsSpellbooks.id("ender");
    public static final ResourceLocation BLOOD_RESOURCE = IronsSpellbooks.id("blood");
    public static final ResourceLocation EVOCATION_RESOURCE = IronsSpellbooks.id("evocation");
    public static final ResourceLocation NATURE_RESOURCE = IronsSpellbooks.id("nature");
    public static final ResourceLocation ELDRITCH_RESOURCE = IronsSpellbooks.id("eldritch");
    public static final RegistryObject<SchoolType> FIRE = SchoolRegistry.registerSchool(new SchoolType(FIRE_RESOURCE, ModTags.FIRE_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.fire").m_130940_(ChatFormatting.GOLD), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.FIRE_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.FIRE_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.FIRE_CAST.get()), ISSDamageTypes.FIRE_MAGIC));
    public static final RegistryObject<SchoolType> ICE = SchoolRegistry.registerSchool(new SchoolType(ICE_RESOURCE, ModTags.ICE_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.ice").m_130948_(Style.f_131099_.m_178520_(13695487)), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.ICE_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.ICE_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.ICE_CAST.get()), ISSDamageTypes.ICE_MAGIC));
    public static final RegistryObject<SchoolType> LIGHTNING = SchoolRegistry.registerSchool(new SchoolType(LIGHTNING_RESOURCE, ModTags.LIGHTNING_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.lightning").m_130940_(ChatFormatting.AQUA), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.LIGHTNING_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.LIGHTNING_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.LIGHTNING_CAST.get()), ISSDamageTypes.LIGHTNING_MAGIC));
    public static final RegistryObject<SchoolType> HOLY = SchoolRegistry.registerSchool(new SchoolType(HOLY_RESOURCE, ModTags.HOLY_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.holy").m_130948_(Style.f_131099_.m_178520_(16775380)), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.HOLY_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.HOLY_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.HOLY_CAST.get()), ISSDamageTypes.HOLY_MAGIC));
    public static final RegistryObject<SchoolType> ENDER = SchoolRegistry.registerSchool(new SchoolType(ENDER_RESOURCE, ModTags.ENDER_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.ender").m_130940_(ChatFormatting.LIGHT_PURPLE), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.ENDER_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.ENDER_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.ENDER_CAST.get()), ISSDamageTypes.ENDER_MAGIC));
    public static final RegistryObject<SchoolType> BLOOD = SchoolRegistry.registerSchool(new SchoolType(BLOOD_RESOURCE, ModTags.BLOOD_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.blood").m_130940_(ChatFormatting.DARK_RED), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.BLOOD_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.BLOOD_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.BLOOD_CAST.get()), ISSDamageTypes.BLOOD_MAGIC));
    public static final RegistryObject<SchoolType> EVOCATION = SchoolRegistry.registerSchool(new SchoolType(EVOCATION_RESOURCE, ModTags.EVOCATION_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.evocation").m_130940_(ChatFormatting.WHITE), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.EVOCATION_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.EVOCATION_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.EVOCATION_CAST.get()), ISSDamageTypes.EVOCATION_MAGIC));
    public static final RegistryObject<SchoolType> NATURE = SchoolRegistry.registerSchool(new SchoolType(NATURE_RESOURCE, ModTags.NATURE_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.nature").m_130940_(ChatFormatting.GREEN), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.NATURE_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.NATURE_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.NATURE_CAST.get()), ISSDamageTypes.NATURE_MAGIC));
    public static final RegistryObject<SchoolType> ELDRITCH = SchoolRegistry.registerSchool(new SchoolType(ELDRITCH_RESOURCE, ModTags.ELDRITCH_FOCUS, (Component)Component.m_237115_((String)"school.irons_spellbooks.eldritch").m_130948_(Style.f_131099_.m_178520_(1016732)), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.ELDRITCH_SPELL_POWER.get()), (LazyOptional<Attribute>)LazyOptional.of(() -> AttributeRegistry.ELDRITCH_MAGIC_RESIST.get()), (LazyOptional<SoundEvent>)LazyOptional.of(() -> SoundRegistry.EVOCATION_CAST.get()), ISSDamageTypes.ELDRITCH_MAGIC));

    public static void register(IEventBus eventBus) {
        SCHOOLS.register(eventBus);
        eventBus.addListener(SchoolRegistry::clientSetup);
    }

    private static RegistryObject<SchoolType> registerSchool(SchoolType schoolType) {
        return SCHOOLS.register(schoolType.getId().m_135815_(), () -> schoolType);
    }

    public static SchoolType getSchool(ResourceLocation resourceLocation) {
        return (SchoolType)REGISTRY.get().getValue(resourceLocation);
    }

    @Nullable
    public static SchoolType getSchoolFromFocus(ItemStack focusStack) {
        for (SchoolType school : REGISTRY.get().getValues()) {
            if (!school.isFocus(focusStack)) continue;
            return school;
        }
        return null;
    }

    public static void clientSetup(ModelEvent.RegisterAdditional event) {
    }
}

