/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.util;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SightUtil {
    public static List<Entity> getInSightEntities(Level world, Entity entity, Vec3 viewPos, Vec3 lookFor, float distance, float yawFov, float pitchFov, float targetExpand, Predicate<Entity> predicate) {
        Vec3 lookTo = lookFor.m_82541_().m_82490_((double)distance);
        AABB bb = new AABB(viewPos.m_7096_(), viewPos.m_7098_(), viewPos.m_7094_(), viewPos.m_7096_() + lookTo.m_7096_(), viewPos.m_7098_() + lookTo.m_7098_(), viewPos.m_7094_() + lookTo.m_7094_()).m_82400_(1.0);
        SightChecker sightChecker = SightUtil.getSightChecker(viewPos, lookFor, SightUtil.getYawPitch(lookFor)[0], yawFov, pitchFov);
        return world.m_6249_(entity, bb, inBB -> {
            if (sightChecker.check(inBB.m_20191_().m_82400_((double)targetExpand)) == SightState.HIDE) {
                return false;
            }
            return predicate.test((Entity)inBB);
        });
    }

    public static SightChecker getSightChecker(final Vec3 viewPos, Vec3 lookFor, float yaw, float yawFov, float pitchFov) {
        lookFor = lookFor.m_82541_();
        Vec3 lookForPitchAxis = SightUtil.rotate(new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), -yaw);
        Vec3 lookForYawAxis = lookFor.m_82537_(lookForPitchAxis);
        final Vec3 upNorm = SightUtil.rotate(lookFor, lookForPitchAxis, pitchFov - 90.0f);
        final Vec3 downNorm = SightUtil.rotate(lookFor, lookForPitchAxis, -pitchFov + 90.0f);
        final Vec3 rightNorm = SightUtil.rotate(lookFor, lookForYawAxis, yawFov - 90.0f);
        final Vec3 leftNorm = SightUtil.rotate(lookFor, lookForYawAxis, -yawFov + 90.0f);
        return new SightChecker(){

            @Override
            public boolean check(Vec3 targetPos) {
                Vec3 targetFor = targetPos.m_82546_(viewPos).m_82541_();
                return 0.0 < upNorm.m_82526_(targetFor) && 0.0 < downNorm.m_82526_(targetFor) && 0.0 < rightNorm.m_82526_(targetFor) && 0.0 < leftNorm.m_82526_(targetFor);
            }

            @Override
            public SightState check(AABB box) {
                boolean leftN;
                boolean upP = 0.0 < upNorm.m_82526_(this.positive(box, upNorm));
                boolean upN = 0.0 < upNorm.m_82526_(this.negative(box, upNorm));
                boolean downP = 0.0 < downNorm.m_82526_(this.positive(box, downNorm));
                boolean downN = 0.0 < downNorm.m_82526_(this.negative(box, downNorm));
                boolean rightP = 0.0 < rightNorm.m_82526_(this.positive(box, rightNorm));
                boolean rightN = 0.0 < rightNorm.m_82526_(this.negative(box, rightNorm));
                boolean leftP = 0.0 < leftNorm.m_82526_(this.positive(box, leftNorm));
                boolean bl = leftN = 0.0 < leftNorm.m_82526_(this.negative(box, leftNorm));
                if (upP && upN && downP && downN && rightP && rightN && leftP && leftN) {
                    return SightState.ALL;
                }
                if ((upP || upN) && (downP || downN) && (rightP || rightN) && (leftP || leftN)) {
                    return SightState.PARTIAL;
                }
                return SightState.HIDE;
            }

            private Vec3 positive(AABB box, Vec3 norm) {
                double x = box.f_82288_;
                double y = box.f_82289_;
                double z = box.f_82290_;
                if (0.0 < norm.m_7096_()) {
                    x = box.f_82291_;
                }
                if (0.0 < norm.m_7098_()) {
                    y = box.f_82292_;
                }
                if (0.0 < norm.m_7094_()) {
                    z = box.f_82293_;
                }
                return new Vec3(x, y, z);
            }

            private Vec3 negative(AABB box, Vec3 norm) {
                double x = box.f_82288_;
                double y = box.f_82289_;
                double z = box.f_82290_;
                if (norm.m_7096_() < 0.0) {
                    x = box.f_82291_;
                }
                if (norm.m_7098_() < 0.0) {
                    y = box.f_82292_;
                }
                if (norm.m_7094_() < 0.0) {
                    z = box.f_82293_;
                }
                return new Vec3(x, y, z);
            }
        };
    }

    public static SightState check(Entity viewer, Entity target, float yawFov, float pitchFov) {
        Vec3 view = viewer.m_20299_(1.0f);
        Vec3 lookFor = viewer.m_20154_();
        return SightUtil.getSightChecker(view, lookFor, SightUtil.getYawPitch(lookFor)[0], yawFov, pitchFov).check(target.m_20191_());
    }

    public static boolean isInFrustum(Entity viewer, Entity target, float yawFov, float pitchFov) {
        Vec3 view = viewer.m_20299_(1.0f);
        Vec3 lookFor = viewer.m_20154_();
        return SightUtil.isInFrustum(view, target.m_20299_(1.0f), lookFor, yawFov, pitchFov);
    }

    public static boolean isInFrustum(Vec3 viewPos, Vec3 targetPos, Vec3 lookFor, float yawFov, float pitchFov) {
        return SightUtil.getSightChecker(viewPos, lookFor, SightUtil.getYawPitch(lookFor)[0], yawFov, pitchFov).check(targetPos);
    }

    public static Vec3 rotate(Vec3 vec, Vec3 axis, float angle) {
        throw new AssertionError();
    }

    public static Vec3 getVec(float yaw, float pitch) {
        float pitchRad = pitch * ((float)Math.PI / 180);
        float yawRad = -yaw * ((float)Math.PI / 180);
        float yawCos = Mth.m_14089_((float)yawRad);
        float yawSin = Mth.m_14031_((float)yawRad);
        float pitchCos = Mth.m_14089_((float)pitchRad);
        float pitchSin = Mth.m_14031_((float)pitchRad);
        return new Vec3((double)(yawSin * pitchCos), (double)(-pitchSin), (double)(yawCos * pitchCos));
    }

    public static float[] getYawPitch(Vec3 vec) {
        double lookAtHorizontal = Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_);
        float lookAtYaw = (float)(-Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.29577791868205);
        float lookAtPitch = (float)(-Mth.m_14136_((double)vec.f_82480_, (double)lookAtHorizontal) * 57.29577791868205);
        return new float[]{lookAtYaw, lookAtPitch};
    }

    public static boolean canSee(Level world, @Nullable Entity entity, Vec3 view, Vec3 point) {
        Vec3 toEnd = point.m_82546_(view).m_82541_();
        for (int i = 0; i < 8; ++i) {
            BlockHitResult result = world.m_45547_(new ClipContext(view, point, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
            if (result.m_6662_() == HitResult.Type.MISS) {
                return true;
            }
            BlockState blockState = world.m_8055_(result.m_82425_());
            if (!blockState.m_60734_().m_7420_(blockState, (BlockGetter)world, result.m_82425_())) {
                return false;
            }
            view = result.m_82450_().m_82549_(toEnd);
        }
        return false;
    }

    public static void faceTo(Entity owner, Vec3 to, float maxYawIncrease, float maxPitchIncrease) {
        double x = to.m_7096_() - owner.m_20185_();
        double z = to.m_7094_() - owner.m_20189_();
        double y = to.m_7098_() - owner.m_20188_();
        double horizon = Math.sqrt(x * x + z * z);
        float pitch = (float)(-(Mth.m_14136_((double)y, (double)horizon) * 57.29577951308232));
        float yaw = (float)(Mth.m_14136_((double)z, (double)x) * 57.29577951308232) - 90.0f;
        owner.m_146926_(SightUtil.updateRotation(owner.m_146909_(), pitch, maxPitchIncrease));
        owner.m_146922_(SightUtil.updateRotation(owner.m_146908_(), yaw, maxYawIncrease));
    }

    private static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public static Vec3[] getEight(AABB box) {
        return new Vec3[]{new Vec3(box.f_82288_, box.f_82289_, box.f_82290_), new Vec3(box.f_82288_, box.f_82289_, box.f_82293_), new Vec3(box.f_82288_, box.f_82292_, box.f_82290_), new Vec3(box.f_82288_, box.f_82292_, box.f_82293_), new Vec3(box.f_82291_, box.f_82289_, box.f_82290_), new Vec3(box.f_82291_, box.f_82289_, box.f_82293_), new Vec3(box.f_82291_, box.f_82292_, box.f_82290_), new Vec3(box.f_82291_, box.f_82292_, box.f_82293_)};
    }

    public static interface SightChecker {
        public boolean check(Vec3 var1);

        default public SightState check(AABB box) {
            Vec3[] eight = SightUtil.getEight(box);
            boolean bbb = this.check(eight[0]);
            boolean bbt = this.check(eight[1]);
            boolean btb = this.check(eight[2]);
            boolean btt = this.check(eight[3]);
            boolean tbb = this.check(eight[4]);
            boolean tbt = this.check(eight[5]);
            boolean ttb = this.check(eight[6]);
            boolean ttt = this.check(eight[7]);
            if (bbb && bbt && btb && btt && tbb && tbt && ttb && ttt) {
                return SightState.ALL;
            }
            if (bbb || bbt || btb || btt || tbb || tbt || ttb || ttt) {
                return SightState.PARTIAL;
            }
            return SightState.HIDE;
        }
    }

    public static enum SightState {
        ALL(true),
        PARTIAL(true),
        HIDE(false);

        private final boolean canSee;

        private SightState(boolean canSee) {
            this.canSee = canSee;
        }

        public boolean isCanSee() {
            return this.canSee;
        }
    }
}

