/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.sistr.littlemaidrebirth.util.ProcessDivider;
import org.jetbrains.annotations.Nullable;

public class BlockFinderPD
implements ProcessDivider<BlockPos> {
    private static final Iterable<Direction> DIRECTIONS = ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.EAST, (Object)Direction.UP, (Object)Direction.DOWN);
    private final Queue<BlockPos> seeds;
    private final Predicate<BlockPos> target;
    private final Predicate<BlockPos> linkable;
    private final Iterable<Direction> directions;
    private final Set<BlockPos> searched;
    @Nullable
    private BlockPos result;

    public BlockFinderPD(Iterable<BlockPos> seeds, Predicate<BlockPos> target, Predicate<BlockPos> linkable, Iterable<Direction> directions, int expected) {
        this.seeds = Queues.newArrayDeque(seeds);
        this.target = target;
        this.linkable = linkable;
        this.directions = ImmutableList.copyOf(directions);
        this.searched = new ObjectOpenHashSet(expected);
        for (BlockPos seed : seeds) {
            if (!this.target.test(seed)) continue;
            this.result = seed;
            this.seeds.clear();
            return;
        }
    }

    public BlockFinderPD(Iterable<BlockPos> seeds, Predicate<BlockPos> target, Predicate<BlockPos> linkable, int expected) {
        this(seeds, target, linkable, DIRECTIONS, expected);
    }

    @Override
    public boolean tick() {
        if (this.isEnd()) {
            return false;
        }
        BlockPos seed = this.seeds.poll();
        if (this.searched.contains(seed)) {
            return this.tick();
        }
        this.searched.add(seed);
        for (Direction direction : this.directions) {
            BlockPos linkPos = seed.m_121945_(direction);
            if (this.searched.contains(linkPos)) continue;
            if (this.target.test(linkPos)) {
                this.result = linkPos;
                this.seeds.clear();
                this.searched.clear();
                return true;
            }
            if (!this.linkable.test(linkPos)) continue;
            this.seeds.add(linkPos);
        }
        if (this.isEnd()) {
            this.searched.clear();
        }
        return false;
    }

    @Override
    public Optional<BlockPos> getResult() {
        return Optional.ofNullable(this.result);
    }

    @Override
    public boolean isEnd() {
        return this.seeds.isEmpty();
    }
}

