/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.setup;

import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.api.mode.Modes;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.iff.IFFType;
import net.sistr.littlemaidrebirth.entity.iff.IFFTypeManager;
import net.sistr.littlemaidrebirth.network.Networking;
import net.sistr.littlemaidrebirth.setup.Registration;

public class ModSetup {
    public static void init() {
        Networking.INSTANCE.init();
        if (LMRBMod.getConfig().spawn.canNaturalSpawn) {
            ModSetup.registerSpawnSettingLM();
        }
        IFFTypeManager iffTypeManager = IFFTypeManager.getINSTANCE();
        BuiltInRegistries.f_256780_.m_123024_().filter(EntityType::m_20654_).forEach(entityType -> iffTypeManager.register(EntityType.m_20613_((EntityType)entityType), new IFFType(IFFTag.UNKNOWN, (EntityType<?>)entityType)));
        iffTypeManager.register(EntityType.m_20613_((EntityType)EntityType.f_20532_), new IFFType(IFFTag.UNKNOWN, EntityType.f_20532_));
        Modes.init();
    }

    private static void registerSpawnSettingLM() {
        List<TagKey> spawnBiomeTags = LMRBMod.getConfig().spawn.maidSpawnBiomeTags.stream().filter(ResourceLocation::m_135830_).map(ResourceLocation::new).map(id -> TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)id)).toList();
        List<TagKey> spawnExcludeBiomeTags = LMRBMod.getConfig().spawn.maidSpawnExcludeBiomeTags.stream().filter(ResourceLocation::m_135830_).map(ResourceLocation::new).map(id -> TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)id)).toList();
        BiomeModifications.addProperties(context -> ModSetup.canSpawnBiome(context, spawnBiomeTags, spawnExcludeBiomeTags), (context, mutable) -> mutable.getSpawnProperties().addSpawn(((EntityType)Registration.LITTLE_MAID_MOB.get()).m_20674_(), new MobSpawnSettings.SpawnerData((EntityType)Registration.LITTLE_MAID_MOB.get(), LMRBMod.getConfig().spawn.spawnWeight, LMRBMod.getConfig().spawn.minSpawnGroupSize, LMRBMod.getConfig().spawn.maxSpawnGroupSize)));
    }

    private static boolean canSpawnBiome(BiomeModifications.BiomeContext context, List<TagKey<Biome>> spawnBiomeTags, List<TagKey<Biome>> spawnExcludeBiomeTags) {
        for (TagKey<Biome> biomeTag : spawnBiomeTags) {
            if (!context.hasTag(biomeTag)) continue;
            for (TagKey<Biome> excludeBiomeTag : spawnExcludeBiomeTags) {
                if (!context.hasTag(excludeBiomeTag)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

