/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

public class C2SSetBloodSuckPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidrebirth", "set_blood_suck");

    @OnlyIn(value=Dist.CLIENT)
    public static void sendC2SPacket(Entity entity, boolean isBloodSuck) {
        FriendlyByteBuf buf = C2SSetBloodSuckPacket.createC2SPacket(entity, isBloodSuck);
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)buf);
    }

    public static FriendlyByteBuf createC2SPacket(Entity entity, boolean isBloodSuck) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_19879_());
        buf.writeBoolean(isBloodSuck);
        return buf;
    }

    public static void receiveC2SPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int id = buf.m_130242_();
        boolean isBloodSuck = buf.readBoolean();
        context.queue(() -> C2SSetBloodSuckPacket.applyBloodSuckServer(context.getPlayer(), id, isBloodSuck));
    }

    private static void applyBloodSuckServer(Player player, int id, boolean isBloodSuck) {
        Entity entity = player.m_9236_().m_6815_(id);
        if (!(entity instanceof LittleMaidEntity)) {
            return;
        }
        LittleMaidEntity maid = (LittleMaidEntity)entity;
        if (TameableUtil.getTameOwnerUuid((OwnableEntity)maid).filter(uuid -> player.m_20148_().equals(uuid)).isPresent()) {
            maid.setBloodSuck(isBloodSuck);
        }
    }
}

