/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.mixin;

import com.mojang.datafixers.util.Either;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;
import net.sistr.littlemaidrebirth.mixin.MixinPlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayerEntity
extends MixinPlayerEntity {
    protected MixinServerPlayerEntity(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"copyFrom"}, at={@At(value="RETURN")})
    public void onCopy(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        this.setIFFs(((HasIFF)oldPlayer).getIFFs());
    }

    @Inject(method={"trySleep"}, at={@At(value="RETURN")})
    public void onTrySleep(BlockPos pos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> cir) {
        if (this.m_5803_()) {
            this.getAroundTamedSoundPlayable().forEach(e -> e.play("se_goodnight"));
        }
    }

    @Inject(method={"wakeUp"}, at={@At(value="RETURN")})
    public void onWakeUp(boolean bl, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (!bl && !updateSleepingPlayers) {
            this.getAroundTamedSoundPlayable().forEach(s -> s.play("se_goodmorning"));
        }
    }

    private Stream<SoundPlayable> getAroundTamedSoundPlayable() {
        return this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(8.0), e -> {
            OwnableEntity tameable;
            return e instanceof OwnableEntity && TameableUtil.getTameOwnerUuid(tameable = (OwnableEntity)e).filter(id -> id.equals(this.m_20148_())).isPresent() && e instanceof SoundPlayable;
        }).stream().map(e -> (SoundPlayable)e).filter(s -> !(s instanceof LivingEntity) || ((LivingEntity)s).m_21205_().m_41720_() == Items.f_42524_ || ((LivingEntity)s).m_21206_().m_41720_() == Items.f_42524_);
    }
}

