/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.util.AbstractFurnaceAccessor;
import net.sistr.littlemaidrebirth.util.BlockFinder;

public class CookingMode
extends Mode {
    private static final Object2ObjectOpenHashMap<BlockPos, LittleMaidEntity> USED_FURNACE_MAP = new Object2ObjectOpenHashMap();
    private final LittleMaidEntity mob;
    private BlockPos furnacePos;
    private int timeToRecalcPath;
    private int findCool;
    private int playSoundCool;
    private AbstractFurnaceBlockEntity furnace;

    public CookingMode(ModeType<? extends CookingMode> modeType, String name, LittleMaidEntity mob) {
        super(modeType, name);
        this.mob = mob;
    }

    @Override
    public boolean shouldExecute() {
        AbstractFurnaceBlockEntity prev;
        if (0 < --this.findCool) {
            return false;
        }
        this.findCool = 20;
        if (this.furnacePos != null && this.furnacePos.m_203195_((Position)this.mob.m_20182_(), 6.0) && (prev = (AbstractFurnaceBlockEntity)this.getFurnaceBlockEntity(this.furnacePos).orElse(null)) != null && !this.isUsingFurnaceByOtherMaid(this.furnacePos)) {
            if (!prev.m_7983_()) {
                this.furnace = prev;
                return true;
            }
        } else {
            this.furnacePos = null;
        }
        if (this.getFuel().isEmpty()) {
            return false;
        }
        if (this.furnacePos == null || !this.canCookingFurnace(this.furnace = this.getFurnaceBlockEntity(this.furnacePos).orElseThrow())) {
            this.furnacePos = this.findFurnacePos().orElse(null);
            if (this.furnacePos == null) {
                return false;
            }
            this.furnace = this.getFurnaceBlockEntity(this.furnacePos).orElseThrow();
            return true;
        }
        return true;
    }

    public OptionalInt getFuel() {
        Container inventory = this.mob.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            if (!this.isFuel(itemstack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public boolean isFuel(ItemStack stack) {
        return AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    public Optional<BlockPos> findFurnacePos() {
        return BlockFinder.searchTargetBlock(this.mob.m_20183_(), this::isTargetFurnace, this::isSearchable, Arrays.asList(Direction.values()), 128);
    }

    public boolean isTargetFurnace(BlockPos pos) {
        if (this.isUsingFurnaceByOtherMaid(pos)) {
            return false;
        }
        return this.getFurnaceBlockEntity(pos).filter(AbstractFurnaceBlockEntity::m_7983_).filter(this::canCookingFurnace).isPresent();
    }

    public Optional<AbstractFurnaceBlockEntity> getFurnaceBlockEntity(BlockPos pos) {
        if (pos == null) {
            return Optional.empty();
        }
        BlockEntity tile = this.mob.m_9236_().m_7702_(pos);
        if (tile instanceof AbstractFurnaceBlockEntity) {
            return Optional.of((AbstractFurnaceBlockEntity)tile);
        }
        return Optional.empty();
    }

    public boolean canCookingFurnace(AbstractFurnaceBlockEntity tile) {
        RecipeType<? extends AbstractCookingRecipe> recipeType = ((AbstractFurnaceAccessor)tile).getRecipeType_LM();
        for (int slot : tile.m_7071_(Direction.UP)) {
            ItemStack stack = tile.m_8020_(slot);
            if (!stack.m_41619_() || !this.getAnyCookableItem(recipeType, cookable -> tile.m_7155_(slot, cookable, Direction.UP)).isPresent()) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingFurnaceByOtherMaid(BlockPos furnacePos) {
        LittleMaidEntity user = (LittleMaidEntity)USED_FURNACE_MAP.get((Object)furnacePos);
        if (user != null && user != this.mob) {
            if (!user.m_6084_() || user != user.m_9236_().m_6815_(user.m_19879_())) {
                USED_FURNACE_MAP.remove((Object)furnacePos);
                return false;
            }
            return true;
        }
        return false;
    }

    public Optional<ItemStack> getAnyCookableItem(RecipeType<? extends AbstractCookingRecipe> recipeType, Predicate<ItemStack> predicate) {
        Container inventory = this.mob.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (slotStack.m_41619_() || !this.getRecipe(slotStack, recipeType).isPresent() || !predicate.test(slotStack)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public Optional<? extends AbstractCookingRecipe> getRecipe(ItemStack stack, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        return this.mob.m_9236_().m_7465_().m_44015_(recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), this.mob.m_9236_());
    }

    public boolean isSearchable(BlockPos pos) {
        BlockState state;
        return Math.abs((double)pos.m_123342_() - this.mob.m_20186_()) < 2.0 && pos.m_203195_((Position)this.mob.m_20182_(), 6.0) && ((state = this.mob.m_9236_().m_8055_(pos)).m_60647_((BlockGetter)this.mob.m_9236_(), pos, PathComputationType.LAND) || state.m_60734_() instanceof DoorBlock && ((DoorBlock)state.m_60734_()).m_278711_().f_278463_());
    }

    @Override
    public void startExecuting() {
        this.findCool = 0;
        USED_FURNACE_MAP.put((Object)this.furnacePos, (Object)this.mob);
        this.mob.play("se_cookingStart");
        this.playSoundCool = 20;
    }

    @Override
    public boolean shouldContinueExecuting() {
        if (this.furnacePos == null) {
            return false;
        }
        AbstractFurnaceBlockEntity tmp = this.getFurnaceBlockEntity(this.furnacePos).orElse(null);
        if (tmp != this.furnace) {
            this.furnacePos = null;
            this.furnace = null;
            return false;
        }
        ItemStack result = this.furnace.m_8020_(2);
        if (!result.m_41619_()) {
            return true;
        }
        boolean burning = ((AbstractFurnaceAccessor)this.furnace).isBurningFire_LM();
        if (burning) {
            for (int availableSlot : this.furnace.m_7071_(Direction.UP)) {
                if (this.furnace.m_8020_(availableSlot).m_41619_()) continue;
                return true;
            }
        }
        RecipeType<? extends AbstractCookingRecipe> recipeType = ((AbstractFurnaceAccessor)this.furnace).getRecipeType_LM();
        return (burning || this.getFuel().isPresent()) && this.getAnyCookableItem(recipeType, i -> true).isPresent();
    }

    @Override
    public void tick() {
        this.mob.m_21563_().m_24946_((double)this.furnacePos.m_123341_() + 0.5, (double)this.furnacePos.m_123342_() + 0.5, (double)this.furnacePos.m_123343_() + 0.5);
        if (!this.mob.m_20183_().m_123314_((Vec3i)this.furnacePos, 1.75)) {
            if (this.mob.m_6144_()) {
                this.mob.m_20260_(false);
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                double x = (double)this.furnacePos.m_123341_() + 0.5;
                double y = (double)this.furnacePos.m_123342_() + 0.5;
                double z = (double)this.furnacePos.m_123343_() + 0.5;
                Path path = this.mob.m_21573_().m_26524_(x, y, z, 2);
                this.mob.m_21573_().m_26536_(path, 1.0);
            }
            return;
        }
        this.mob.m_21573_().m_26573_();
        if (!this.mob.m_6144_()) {
            this.mob.m_20260_(true);
        }
        Container inventory = this.mob.getInventory();
        RecipeType<? extends AbstractCookingRecipe> recipeType = ((AbstractFurnaceAccessor)this.furnace).getRecipeType_LM();
        --this.playSoundCool;
        this.getCookable(recipeType).ifPresent(cookableIndex -> this.tryInsertCookable(this.furnace, inventory, cookableIndex));
        this.getFuel().ifPresent(fuelIndex -> this.tryInsertFuel(this.furnace, inventory, fuelIndex));
        this.tryExtractItem(this.furnace, inventory);
    }

    public OptionalInt getCookable(RecipeType<? extends AbstractCookingRecipe> recipeType) {
        Container inventory = this.mob.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack slotStack = inventory.m_8020_(i);
            if (!this.getRecipe(slotStack, recipeType).isPresent()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void tryInsertCookable(AbstractFurnaceBlockEntity furnace, Container inventory, int cookableIndex) {
        int[] materialSlots;
        for (int materialSlot : materialSlots = furnace.m_7071_(Direction.UP)) {
            ItemStack material;
            ItemStack materialSlotStack = furnace.m_8020_(materialSlot);
            if (!materialSlotStack.m_41619_() || !furnace.m_7155_(materialSlot, material = inventory.m_8020_(cookableIndex), Direction.UP)) continue;
            furnace.m_6836_(materialSlot, material);
            inventory.m_8016_(cookableIndex);
            furnace.m_6596_();
            this.pickupAction();
            break;
        }
    }

    private void tryInsertFuel(AbstractFurnaceBlockEntity furnace, Container inventory, int fuelIndex) {
        int[] fuelSlots;
        for (int fuelSlot : fuelSlots = furnace.m_7071_(Direction.NORTH)) {
            ItemStack fuel;
            ItemStack fuelSlotStack = furnace.m_8020_(fuelSlot);
            if (!fuelSlotStack.m_41619_() || !furnace.m_7155_(fuelSlot, fuel = inventory.m_8020_(fuelIndex), Direction.NORTH)) continue;
            furnace.m_6836_(fuelSlot, fuel);
            inventory.m_8016_(fuelIndex);
            furnace.m_6596_();
            this.pickupAction();
            if (this.playSoundCool >= 0) break;
            this.playSoundCool = 20;
            this.mob.play("se_addFuel");
            break;
        }
    }

    private void tryExtractItem(AbstractFurnaceBlockEntity furnace, Container inventory) {
        int[] resultSlots;
        for (int resultSlot : resultSlots = furnace.m_7071_(Direction.DOWN)) {
            ItemStack resultStack = furnace.m_8020_(resultSlot);
            if (resultStack.m_41619_() || !furnace.m_7157_(resultSlot, resultStack, Direction.DOWN)) continue;
            this.pickupAction();
            if (this.playSoundCool < 0) {
                this.playSoundCool = 20;
                this.mob.play("se_cookingOver");
            }
            ItemStack copy = resultStack.m_41777_();
            ItemStack leftover = HopperBlockEntity.m_59326_((Container)furnace, (Container)inventory, (ItemStack)furnace.m_7407_(resultSlot, 1), null);
            if (leftover.m_41619_()) {
                furnace.m_6596_();
                continue;
            }
            furnace.m_6836_(resultSlot, copy);
        }
    }

    public void pickupAction() {
        this.mob.m_6674_(InteractionHand.MAIN_HAND);
        this.mob.m_5496_(SoundEvents.f_12019_, 1.0f, this.mob.m_217043_().m_188501_() * 0.1f + 1.0f);
    }

    @Override
    public void resetTask() {
        this.playSoundCool = 0;
        this.mob.m_20260_(false);
        if (this.furnacePos != null) {
            USED_FURNACE_MAP.remove((Object)this.furnacePos, (Object)this.mob);
            AbstractFurnaceBlockEntity furnace = this.getFurnaceBlockEntity(this.furnacePos).orElse(null);
            if (furnace == null) {
                this.furnacePos = null;
                return;
            }
            for (int i = 0; i < furnace.m_6643_(); ++i) {
                ItemStack stack = furnace.m_8020_(i);
                if (stack.m_41619_()) continue;
                stack = HopperBlockEntity.m_59326_(null, (Container)this.mob.getInventory(), (ItemStack)stack, null);
                if (stack.m_41619_()) {
                    furnace.m_8016_(i);
                    continue;
                }
                furnace.m_6836_(i, stack);
            }
        }
    }

    @Override
    public void writeModeData(CompoundTag nbt) {
        if (this.furnacePos != null) {
            nbt.m_128365_("FurnacePos", (Tag)NbtUtils.m_129224_((BlockPos)this.furnacePos));
        }
    }

    @Override
    public void readModeData(CompoundTag nbt) {
        if (nbt.m_128441_("FurnacePos")) {
            this.furnacePos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("FurnacePos"));
        }
    }
}

