/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.mode;

import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeType;

public abstract class AbstractBattleMode<T>
extends Mode {
    protected final Mob mob;
    protected LivingEntity target;
    protected ItemStack weaponStack;
    protected T weapon;

    protected AbstractBattleMode(Mob mob, ModeType<? extends Mode> modeType, String name) {
        super(modeType, name);
        this.mob = mob;
    }

    @Override
    public boolean shouldExecute() {
        if (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) {
            return false;
        }
        this.target = this.mob.m_5448_();
        ItemStack main = this.mob.m_21205_();
        if (this.isWeapon(main)) {
            this.weaponStack = main;
            this.weapon = this.getWeaponInstance(main).orElseThrow();
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldContinueExecuting() {
        return this.shouldExecute();
    }

    @Override
    public boolean isBattleMode() {
        return true;
    }

    protected boolean isWeapon(ItemStack stack) {
        return this.getWeaponInstance(stack).isPresent();
    }

    protected abstract Optional<T> getWeaponInstance(ItemStack var1);
}

