/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.iff;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.iff.IFFTypeManager;

public class IFFImpl
implements HasIFF {
    private final List<IFF> iffs = Lists.newArrayList();

    public IFFImpl(List<IFF> iffs) {
        this();
        this.iffs.addAll(iffs);
    }

    public IFFImpl() {
    }

    @Override
    public Optional<IFFTag> identify(LivingEntity target) {
        return this.iffs.stream().filter(iff -> iff.identify(target)).map(IFF::getIFFTag).findFirst();
    }

    @Override
    public void setIFFs(List<IFF> iffs) {
        this.iffs.clear();
        this.iffs.addAll(iffs);
    }

    @Override
    public List<IFF> getIFFs() {
        return Lists.newArrayList(this.iffs);
    }

    @Override
    public void writeIFF(CompoundTag nbt) {
        ListTag list = new ListTag();
        nbt.m_128365_("HasIFFTags", (Tag)list);
        this.iffs.stream().map(IFF::writeTag).forEach(arg_0 -> list.add(arg_0));
    }

    @Override
    public void readIFF(CompoundTag nbt) {
        if (!nbt.m_128441_("HasIFFTags")) {
            return;
        }
        ListTag list = nbt.m_128437_("HasIFFTags", 10);
        list.stream().map(t -> (CompoundTag)t).map(t -> IFFTypeManager.getINSTANCE().loadIFF((CompoundTag)t)).filter(Optional::isPresent).map(Optional::get).forEach(this::addOrReplace);
    }

    public void addOrReplace(IFF iff) {
        this.iffs.removeIf(i -> i.getIFFType() == iff.getIFFType());
        this.iffs.add(iff);
    }
}

