/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.MovingMode;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;

public class RedstoneTraceGoal
extends Goal {
    protected final LittleMaidEntity mob;
    protected final Supplier<Float> speed;
    protected final List<BlockPos> aroundSignalPos = Lists.newArrayList();
    protected int recalcTimer;

    public RedstoneTraceGoal(LittleMaidEntity mob, Supplier<Float> speed) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!TameableUtil.hasTameOwner((OwnableEntity)this.mob)) {
            return false;
        }
        if (0 < this.recalcTimer) {
            --this.recalcTimer;
            return false;
        }
        if (TameableUtil.isWait(this.mob) || this.mob.getMovingMode() != MovingMode.TRACER || !this.mob.m_21573_().m_26571_()) {
            return false;
        }
        this.aroundSignalPos.clear();
        this.getAroundSignalPoses().filter(pos -> Mth.m_14107_((double)this.mob.m_20185_()) != pos.m_123341_() || Mth.m_14107_((double)this.mob.m_20189_()) != pos.m_123343_()).forEach(this.aroundSignalPos::add);
        this.recalcTimer = this.m_183277_(20);
        return !this.aroundSignalPos.isEmpty();
    }

    public boolean m_8045_() {
        return !TameableUtil.isWait(this.mob) && this.mob.getMovingMode() == MovingMode.TRACER && !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.aroundSignalPos.stream().min(Comparator.comparingDouble(pos -> -Mth.m_14118_((float)this.getRelYaw((BlockPos)pos), (float)55.0f) + 180.0f - (float)pos.m_123342_())).ifPresent(pos -> {
            PathNavigation navigation = this.mob.m_21573_();
            if (!navigation.m_26536_(navigation.m_7864_(pos, 0), (double)this.speed.get().floatValue())) {
                navigation.m_26573_();
            }
        });
    }

    public void m_8041_() {
        this.recalcTimer = 0;
    }

    protected Stream<BlockPos> getAroundSignalPoses() {
        int horizon = LMRBMod.getConfig().movement.tracerHorizonRange;
        int vertical = LMRBMod.getConfig().movement.tracerVerticalRange;
        return BlockPos.m_121990_((BlockPos)this.mob.m_20183_().m_7918_(horizon, vertical, horizon), (BlockPos)this.mob.m_20183_().m_7918_(-horizon, -vertical, -horizon)).map(BlockPos::m_7949_).filter(this::isEmitSignal);
    }

    protected boolean isEmitSignal(BlockPos pos) {
        BlockState state = this.mob.m_9236_().m_8055_(pos);
        return Arrays.stream(Direction.values()).anyMatch(direction -> 0 < state.m_60775_((BlockGetter)this.mob.m_9236_(), pos, direction));
    }

    protected float getRelYaw(BlockPos pos) {
        float x = (float)((double)((float)pos.m_123341_() + 0.5f) - this.mob.m_20185_());
        float z = (float)((double)((float)pos.m_123343_() + 0.5f) - this.mob.m_20189_());
        float yaw = (float)(-Mth.m_14136_((double)x, (double)z) * 57.29577951308232);
        float mobYaw = this.mob.m_146908_();
        return Mth.m_14118_((float)mobYaw, (float)yaw);
    }
}

