/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import org.jetbrains.annotations.Nullable;

public class PlaySnowGoal
extends Goal {
    private final LittleMaidEntity mob;
    private final int maxCraftSnowballTime = 60;
    private final int maxLookTargetTime = 30;
    private final int maxWaitNextTime = 30;
    private int state;
    private int timer;
    @Nullable
    private LivingEntity target;

    public PlaySnowGoal(LittleMaidEntity mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long time = this.mob.m_9236_().m_46468_();
        if ((time %= 24000L) < 0L || 12500L < time) {
            return false;
        }
        BlockState block = this.mob.m_146900_();
        return block.m_204336_(BlockTags.f_144279_);
    }

    public boolean m_8045_() {
        return super.m_8045_();
    }

    public void m_8056_() {
        this.state = 0;
        this.timer = 0;
        this.target = null;
        this.mob.setPlayingSnow(true);
    }

    public void m_8037_() {
        if (this.state == 0) {
            if (this.timer == 0) {
                this.mob.play("se_collect_snow");
            }
            if (this.timer % 15 == 0 && this.timer % 30 != 0) {
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_12481_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.mob.m_20260_(true);
            Vec3 lookAt = this.mob.m_20182_().m_82549_(this.mob.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.mob.m_20236_(this.mob.m_20089_())));
            this.mob.m_21563_().m_24964_(lookAt);
            ++this.timer;
            if (this.timer >= 60) {
                this.state = 1;
                this.timer = 0;
            }
        } else if (this.state == 1) {
            this.mob.m_20260_(false);
            Level world = this.mob.m_9236_();
            if (this.target == null) {
                this.timer = 0;
                this.target = world.m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_(10.0), entity -> this.mob != entity).stream().sorted(Comparator.comparingDouble(arg_0 -> ((LittleMaidEntity)this.mob).m_20280_(arg_0))).filter(entity -> this.mob.m_21574_().m_148306_((Entity)entity)).findAny().orElse(null);
            } else if (this.mob.m_21574_().m_148306_((Entity)this.target)) {
                ++this.timer;
                this.mob.m_21563_().m_148051_((Entity)this.target);
            } else {
                this.timer = 0;
                this.target = null;
            }
            if (this.timer >= 30) {
                this.state = 2;
                this.timer = 0;
            }
        } else {
            this.mob.m_20260_(false);
            if (this.target == null) {
                this.state = 1;
                this.timer = 0;
            } else {
                if (this.timer == 0) {
                    this.shootSnowBall(this.mob.m_9236_(), (LivingEntity)this.mob);
                    this.mob.m_6674_(InteractionHand.MAIN_HAND);
                    this.mob.play("se_shoot");
                    this.mob.m_146922_(this.mob.m_6080_());
                }
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            ++this.timer;
            if (this.timer >= 30) {
                this.state = 0;
                this.timer = 0;
                this.target = null;
            }
        }
    }

    private void shootSnowBall(Level world, LivingEntity user) {
        world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!world.f_46443_) {
            Snowball snowballEntity = new Snowball(world, user);
            snowballEntity.m_37446_(Items.f_42452_.m_7968_());
            snowballEntity.m_37251_((Entity)user, user.m_146909_(), user.m_6080_(), 0.0f, 1.5f, 1.0f);
            world.m_7967_((Entity)snowballEntity);
        }
    }

    public void m_8041_() {
        this.mob.m_20260_(false);
        this.mob.setPlayingSnow(false);
    }

    public boolean m_183429_() {
        return true;
    }
}

