/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;

public abstract class MoveToDropItemGoal
extends Goal {
    private final PathfinderMob mob;
    private final Supplier<Float> range;
    private final Supplier<Integer> frequency;
    private final Supplier<Float> speed;

    public MoveToDropItemGoal(PathfinderMob mob, Supplier<Float> range, Supplier<Integer> frequency, Supplier<Float> speed) {
        this.mob = mob;
        this.range = range;
        this.frequency = frequency;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188501_() > 1.0f / (float)this.m_183277_(this.frequency.get()) || this.isInventoryFull()) {
            return false;
        }
        Stream<BlockPos> positions = this.findAroundDropItem().stream().map(Entity::m_20183_);
        Path path = positions.map(pos -> this.mob.m_21573_().m_7864_(pos, 0)).filter(Objects::nonNull).filter(Path::m_77403_).findAny().orElse(null);
        if (path == null) {
            return false;
        }
        this.mob.m_21573_().m_26536_(path, (double)this.speed.get().floatValue());
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.mob instanceof SoundPlayable) {
            ((SoundPlayable)this.mob).play("se_findTarget_I");
        }
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_();
    }

    public abstract boolean isInventoryFull();

    public List<ItemEntity> findAroundDropItem() {
        float range = this.range.get().floatValue();
        return this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_((double)range, (double)(range / 4.0f), (double)range), item -> !item.m_32063_() && item.m_20280_((Entity)this.mob) < (double)(range * range));
    }
}

