/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity.goal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.pathfinder.Path;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.goal.CollectItemFromContainerGoal;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;
import org.jetbrains.annotations.Nullable;

public class LMCollectSalaryFromContainerGoal<T extends LittleMaidEntity>
extends CollectItemFromContainerGoal<T> {
    @Nullable
    protected BlockPos prevWaitPos;
    protected int moveToPrevWaitPosTime;

    public LMCollectSalaryFromContainerGoal(T mob) {
        super(mob);
    }

    @Override
    public boolean m_8036_() {
        return ((LittleMaidEntity)this.mob).itemContractable.hasSalaryBoxPositions() && TameableUtil.hasTameOwner((OwnableEntity)this.mob) && super.m_8036_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        if (TameableUtil.isWait((TamableAnimal)this.mob)) {
            this.prevWaitPos = ((LittleMaidEntity)this.mob).m_20183_();
            this.moveToPrevWaitPosTime = 0;
        }
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() || this.prevWaitPos != null;
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.targetContainerPos == null && this.prevWaitPos != null) {
            if (this.prevWaitPos.equals((Object)((LittleMaidEntity)this.mob).m_20183_()) || this.moveToPrevWaitPosTime++ > this.getConfigMaxMoveTimePrevPos()) {
                this.prevWaitPos = null;
                return;
            }
            PathNavigation nav = ((LittleMaidEntity)this.mob).m_21573_();
            Path path = nav.m_7864_(this.prevWaitPos, 0);
            if (path != null) {
                nav.m_26536_(path, 1.0);
            }
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.prevWaitPos = null;
        this.moveToPrevWaitPosTime = 0;
    }

    @Override
    protected ItemStack transfer(ItemStack stack) {
        return HopperBlockEntity.m_59326_(null, (Container)((LittleMaidEntity)this.mob).getInventory(), (ItemStack)stack, null);
    }

    @Override
    protected boolean isTargetItem(ItemStack stack) {
        return ((LittleMaidEntity)this.mob).itemContractable.isSalary(stack);
    }

    @Override
    protected void postCollect() {
        ((LittleMaidEntity)this.mob).m_6674_(InteractionHand.MAIN_HAND);
        ((LittleMaidEntity)this.mob).m_5496_(SoundEvents.f_12019_, 1.0f, ((LittleMaidEntity)this.mob).m_217043_().m_188501_() * 0.1f + 1.0f);
    }

    @Override
    protected boolean shouldCollect() {
        int salarySlots = ((LittleMaidEntity)this.mob).itemContractable.checkSalarySlots();
        return salarySlots <= this.getConfigMinSalarySlots();
    }

    @Override
    protected boolean canCollectState() {
        boolean hasEmptySlot = false;
        int salarySlots = ((LittleMaidEntity)this.mob).itemContractable.checkSalarySlots();
        Container inv = ((LittleMaidEntity)this.mob).getInventory();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!stack.m_41619_()) continue;
            hasEmptySlot = true;
            break;
        }
        return hasEmptySlot && salarySlots < this.getConfigMaxSalarySlots();
    }

    @Override
    protected Optional<BlockPos> searchContainerPos() {
        List<BlockPos> salaryBoxList = ((LittleMaidEntity)this.mob).itemContractable.getSalaryBoxPositions();
        if (salaryBoxList.isEmpty()) {
            return Optional.empty();
        }
        ArrayList newSalaryBoxList = Lists.newArrayList();
        BlockPos result = null;
        Path resultPath = null;
        int minDistance = Integer.MAX_VALUE;
        for (BlockPos pos : salaryBoxList) {
            PathNavigation nav;
            Path path;
            float sq;
            int distance;
            if (this.getAvailableContainer(pos).isEmpty() || (float)(distance = (int)pos.m_203193_((Position)((LittleMaidEntity)this.mob).m_20182_())) > (sq = this.getConfigSalaryBoxRange() * this.getConfigSalaryBoxRange()) || (path = (nav = ((LittleMaidEntity)this.mob).m_21573_()).m_7864_(pos, 1)) == null || path.m_77395_() == null || !this.isInCollectRange(pos, BlockPos.m_274446_((Position)path.m_77395_().m_164701_()))) continue;
            newSalaryBoxList.add(pos);
            if (distance >= minDistance) continue;
            minDistance = distance;
            result = pos;
            resultPath = path;
        }
        ((LittleMaidEntity)this.mob).itemContractable.setSalaryBoxPositions(newSalaryBoxList);
        if (resultPath != null) {
            this.toContainerPath = resultPath;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    protected int getConfigMaxSalarySlots() {
        return LMRBMod.getConfig().contract.maxAutoSalaryReceiptSlotSize;
    }

    protected int getConfigMinSalarySlots() {
        return LMRBMod.getConfig().contract.startAutoSalaryReceiptSlotThreshold;
    }

    protected float getConfigSalaryBoxRange() {
        return LMRBMod.getConfig().contract.searchSalaryBoxDistance;
    }

    protected int getConfigMaxMoveTimePrevPos() {
        return LMRBMod.getConfig().contract.maxMoveTimeAfterAutoSalaryReceipt;
    }
}

