/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import com.mojang.datafixers.util.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.GuiEntitySupplier;
import net.sistr.littlemaidrebirth.setup.Registration;

public class LittleMaidScreenHandler
extends AbstractContainerMenu
implements GuiEntitySupplier<LittleMaidEntity> {
    private final Inventory playerInventory;
    private final Container maidInventory;
    private final Container handInventory;
    private final Container armorInventory;
    private final LittleMaidEntity maid;
    private final int unpaidDays;
    private final int workItemSlotSize;

    public LittleMaidScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf packet) {
        this(syncId, playerInventory, packet.m_130242_(), packet.readByte(), packet.readByte());
    }

    public LittleMaidScreenHandler(int syncId, Inventory playerInventory, int entityId, int unpaidDays, int workItemSlotSize) {
        super((MenuType)Registration.LITTLE_MAID_SCREEN_HANDLER.get(), syncId);
        LittleMaidEntity maid;
        this.playerInventory = playerInventory;
        this.unpaidDays = unpaidDays;
        this.workItemSlotSize = workItemSlotSize;
        this.maid = maid = (LittleMaidEntity)playerInventory.f_35978_.m_9236_().m_6815_(entityId);
        if (maid == null) {
            throw new RuntimeException("\u30e1\u30a4\u30c9\u3055\u3093\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        this.maidInventory = maid.getInventory();
        this.handInventory = new Container(){

            private EquipmentSlot index(int slot) {
                return slot == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }

            public ItemStack m_8020_(int slot) {
                EquipmentSlot equipmentSlot = this.index(slot);
                return maid.m_6844_(equipmentSlot);
            }

            public ItemStack m_7407_(int slot, int amount) {
                EquipmentSlot equipmentSlot = this.index(slot);
                return maid.m_6844_(equipmentSlot).m_41620_(amount);
            }

            public ItemStack m_8016_(int slot) {
                EquipmentSlot equipmentSlot = this.index(slot);
                ItemStack result = maid.m_6844_(equipmentSlot);
                maid.m_8061_(equipmentSlot, ItemStack.f_41583_);
                return result;
            }

            public void m_6836_(int slot, ItemStack stack) {
                EquipmentSlot equipmentSlot = this.index(slot);
                maid.m_8061_(equipmentSlot, stack);
            }

            public boolean m_7983_() {
                return maid.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && maid.m_6844_(EquipmentSlot.OFFHAND).m_41619_();
            }

            public int m_6643_() {
                return 2;
            }

            public boolean m_6542_(Player player) {
                return true;
            }

            public void m_6596_() {
            }

            public void m_6211_() {
            }
        };
        this.armorInventory = new Container(){

            private EquipmentSlot index(int slot) {
                return switch (slot) {
                    case 0 -> EquipmentSlot.FEET;
                    case 1 -> EquipmentSlot.LEGS;
                    case 2 -> EquipmentSlot.CHEST;
                    default -> EquipmentSlot.HEAD;
                };
            }

            public ItemStack m_8020_(int slot) {
                EquipmentSlot equipmentSlot = this.index(slot);
                return maid.m_6844_(equipmentSlot);
            }

            public ItemStack m_7407_(int slot, int amount) {
                EquipmentSlot equipmentSlot = this.index(slot);
                return maid.m_6844_(equipmentSlot).m_41620_(amount);
            }

            public ItemStack m_8016_(int slot) {
                EquipmentSlot equipmentSlot = this.index(slot);
                ItemStack result = maid.m_6844_(equipmentSlot);
                maid.m_8061_(equipmentSlot, ItemStack.f_41583_);
                return result;
            }

            public void m_6836_(int slot, ItemStack stack) {
                EquipmentSlot equipmentSlot = this.index(slot);
                maid.m_8061_(equipmentSlot, stack);
            }

            public boolean m_7983_() {
                return maid.m_6844_(EquipmentSlot.HEAD).m_41619_() && maid.m_6844_(EquipmentSlot.CHEST).m_41619_() && maid.m_6844_(EquipmentSlot.LEGS).m_41619_() && maid.m_6844_(EquipmentSlot.FEET).m_41619_();
            }

            public int m_6643_() {
                return 4;
            }

            public boolean m_6542_(Player player) {
                return true;
            }

            public void m_6596_() {
            }

            public void m_6211_() {
            }
        };
        this.maidInventory.m_5856_(playerInventory.f_35978_);
        this.layoutMaidInventorySlots();
        this.layoutPlayerInventorySlots(8, 126);
    }

    @Override
    public LittleMaidEntity getGuiEntity() {
        return this.maid;
    }

    public int getUnpaidDays() {
        return this.unpaidDays;
    }

    public int getWorkItemSlotSize() {
        return this.workItemSlotSize;
    }

    public boolean m_6875_(Player player) {
        return this.maid != null && this.maid.m_6084_() && this.maid.m_20280_((Entity)player) < 64.0;
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot == null || !slot.m_6657_()) {
            return newStack;
        }
        ItemStack originalStack = slot.m_7993_();
        newStack = originalStack.m_41777_();
        if (invSlot < 18 ? !this.m_38903_(originalStack, 24, 60, false) : (invSlot < 24 ? !this.m_38903_(originalStack, 0, 18, true) : !this.m_38903_(originalStack, 0, 18, false))) {
            return ItemStack.f_41583_;
        }
        if (originalStack.m_41619_()) {
            slot.m_269060_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return newStack;
    }

    private int addSlotRange(Container inventory, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_(new Slot(inventory, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(Container inventory, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(inventory, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox((Container)this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange((Container)this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private void layoutMaidInventorySlots() {
        final ResourceLocation atlas = new ResourceLocation("textures/atlas/blocks.png");
        this.addSlotBox(this.maidInventory, 0, 8, 76, 9, 18, 2, 18);
        this.m_38897_(new Slot(this.handInventory, 0, 116, 44));
        this.m_38897_(new Slot(this.handInventory, 1, 152, 44){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)atlas, (Object)new ResourceLocation("item/empty_armor_slot_shield"));
            }
        });
        this.m_38897_(new Slot(this.armorInventory, EquipmentSlot.HEAD.m_20749_(), 8, 8){

            public int m_6641_() {
                return 1;
            }

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.HEAD;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)atlas, (Object)new ResourceLocation("item/empty_armor_slot_helmet"));
            }
        });
        this.m_38897_(new Slot(this.armorInventory, EquipmentSlot.CHEST.m_20749_(), 8, 44){

            public int m_6641_() {
                return 1;
            }

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.CHEST;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)atlas, (Object)new ResourceLocation("item/empty_armor_slot_chestplate"));
            }
        });
        this.m_38897_(new Slot(this.armorInventory, EquipmentSlot.LEGS.m_20749_(), 80, 8){

            public int m_6641_() {
                return 1;
            }

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.LEGS;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)atlas, (Object)new ResourceLocation("item/empty_armor_slot_leggings"));
            }
        });
        this.m_38897_(new Slot(this.armorInventory, EquipmentSlot.FEET.m_20749_(), 80, 44){

            public int m_6641_() {
                return 1;
            }

            public boolean m_5857_(ItemStack stack) {
                return Mob.m_147233_((ItemStack)stack) == EquipmentSlot.FEET;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)atlas, (Object)new ResourceLocation("item/empty_armor_slot_boots"));
            }
        });
    }
}

