/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import com.google.common.collect.Lists;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.entity.compound.MultiModelCompound;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayableCompound;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMPose;
import net.sistr.littlemaidmodelloader.network.SyncMultiModelPacket;
import net.sistr.littlemaidmodelloader.resource.holder.ConfigHolder;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.advancement.criterion.LMRBCriteria;
import net.sistr.littlemaidrebirth.api.mode.Mode;
import net.sistr.littlemaidrebirth.api.mode.ModeManager;
import net.sistr.littlemaidrebirth.config.LMRBConfig;
import net.sistr.littlemaidrebirth.entity.FixedMoveControl;
import net.sistr.littlemaidrebirth.entity.LMHasInventory;
import net.sistr.littlemaidrebirth.entity.LMItemContractable;
import net.sistr.littlemaidrebirth.entity.LMScreenHandlerFactory;
import net.sistr.littlemaidrebirth.entity.LittleMaidModelCaps;
import net.sistr.littlemaidrebirth.entity.MaidSoulEntity;
import net.sistr.littlemaidrebirth.entity.goal.FollowAtHeldItemGoal;
import net.sistr.littlemaidrebirth.entity.goal.FreedomGoal;
import net.sistr.littlemaidrebirth.entity.goal.HasMMFollowTameOwnerGoal;
import net.sistr.littlemaidrebirth.entity.goal.LMCollectSalaryFromContainerGoal;
import net.sistr.littlemaidrebirth.entity.goal.LMHealMyselfGoal;
import net.sistr.littlemaidrebirth.entity.goal.LMMoveToDropItemGoal;
import net.sistr.littlemaidrebirth.entity.goal.LMStoreItemToContainerGoal;
import net.sistr.littlemaidrebirth.entity.goal.LMTargetGoal;
import net.sistr.littlemaidrebirth.entity.goal.LMTeleportTameOwnerGoal;
import net.sistr.littlemaidrebirth.entity.goal.PlaySnowGoal;
import net.sistr.littlemaidrebirth.entity.goal.RedstoneTraceGoal;
import net.sistr.littlemaidrebirth.entity.goal.TameableStareAtHeldItemGoal;
import net.sistr.littlemaidrebirth.entity.goal.WaitGoal;
import net.sistr.littlemaidrebirth.entity.iff.HasIFF;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.entity.mode.HasMode;
import net.sistr.littlemaidrebirth.entity.mode.HasModeImpl;
import net.sistr.littlemaidrebirth.entity.mode.ModeWrapperGoal;
import net.sistr.littlemaidrebirth.entity.util.AimingPoseable;
import net.sistr.littlemaidrebirth.entity.util.Contractable;
import net.sistr.littlemaidrebirth.entity.util.EPEntityUtil;
import net.sistr.littlemaidrebirth.entity.util.HasInventory;
import net.sistr.littlemaidrebirth.entity.util.HasMovingMode;
import net.sistr.littlemaidrebirth.entity.util.MovingMode;
import net.sistr.littlemaidrebirth.entity.util.SalaryBoxPosListener;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;
import net.sistr.littlemaidrebirth.entity.util.TargetingSystem;
import net.sistr.littlemaidrebirth.mixin.CrossbowItemInvoker;
import net.sistr.littlemaidrebirth.network.SpawnLittleMaidPacket;
import net.sistr.littlemaidrebirth.setup.Registration;
import net.sistr.littlemaidrebirth.tags.LMTags;
import net.sistr.littlemaidrebirth.util.LMCollidable;
import net.sistr.littlemaidrebirth.util.ReachAttributeUtil;
import net.sistr.littlemaidrebirth.world.WorldMaidSoulState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LittleMaidEntity
extends TamableAnimal
implements EntitySpawnExtension,
HasInventory,
Contractable,
HasMode,
HasIFF,
AimingPoseable,
IHasMultiModel,
SoundPlayable,
HasMovingMode,
CrossbowAttackMob,
SalaryBoxPosListener {
    private static final int WAIT_INDEX = 0;
    private static final int AIMING_INDEX = 1;
    private static final int BEGGING_INDEX = 2;
    private static final int BLOOD_SUCK_INDEX = 3;
    private static final int STRIKE_INDEX = 4;
    private static final int PLAYING_SNOW_INDEX = 5;
    private static final EntityDataAccessor<Byte> LMM_FLAGS = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> MOVING_MODE = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> MODE_NAME = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ACCELERATE = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> MASTER_STANCE = SynchedEntityData.m_135353_(LittleMaidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int EXPERIENCE_BOTTLE_COST = 7;
    public final LMHasInventory littleMaidInventory = new LMHasInventory();
    public final LMItemContractable<LittleMaidEntity> itemContractable = new LMItemContractable<LittleMaidEntity>(this, () -> LittleMaidEntity.getConfig().contract.consumeSalaryInterval, () -> LittleMaidEntity.getConfig().contract.unpaidDaysLimit, stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY));
    public final HasModeImpl hasModeImpl = new HasModeImpl((LivingEntity)this, this, new HashSet<Mode>());
    public final MultiModelCompound multiModel;
    public final SoundPlayableCompound soundPlayer;
    private final LMScreenHandlerFactory screenFactory = new LMScreenHandlerFactory(this);
    private final IModelCaps caps = new LittleMaidModelCaps(this);
    private final Map<Mob, Predicate<Mob>> fleeEntities = new HashMap<Mob, Predicate<Mob>>();
    @Nullable
    private BlockPos freedomPos;
    @OnlyIn(value=Dist.CLIENT)
    private float interestedAngle;
    @OnlyIn(value=Dist.CLIENT)
    private float prevInterestedAngle;
    private int playSoundCool;
    private int idFactor;
    public int experiencePickUpDelay;
    private int accelerationTicks;
    private TargetingSystem.MasterStance masterStance = TargetingSystem.MasterStance.GUARD;

    public LittleMaidEntity(EntityType<LittleMaidEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FixedMoveControl((Mob)this);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.multiModel = new MultiModelCompound((LivingEntity)this, (TextureHolder)LMTextureManager.INSTANCE.getTexture("Default").orElseThrow(() -> new IllegalStateException("\u30c7\u30d5\u30a9\u30eb\u30c8\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002")), (TextureHolder)LMTextureManager.INSTANCE.getTexture("Default").orElseThrow(() -> new IllegalStateException("\u30c7\u30d5\u30a9\u30eb\u30c8\u30c6\u30af\u30b9\u30c1\u30e3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002")));
        this.soundPlayer = new SoundPlayableCompound((Entity)this, () -> this.multiModel.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        this.addDefaultModes(this);
        this.initIdFactor();
        this.setRandomTexture();
        this.setRandomVoice();
    }

    public LittleMaidEntity(Level world) {
        this((EntityType<LittleMaidEntity>)((EntityType)Registration.LITTLE_MAID_MOB.get()), world);
    }

    public static AttributeSupplier.Builder createLittleMaidAttributes() {
        AttributeSupplier.Builder builder = LittleMaidEntity.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22266_(Attributes.f_22281_).m_22266_(Attributes.f_22283_).m_22266_(Attributes.f_22286_).m_22268_(Attributes.f_22277_, 48.0);
        ReachAttributeUtil.addAttribute(builder);
        return builder;
    }

    public static boolean isValidNaturalSpawn(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)world, pos) && world.m_45524_(pos, 0) > 8;
    }

    public static void resurrectionMaid(ServerLevel world, BlockPos pos, Player player) {
        WorldMaidSoulState worldMaidSoulState = WorldMaidSoulState.getWorldMaidSoulState(world);
        List<MaidSoul> maidSouls = worldMaidSoulState.get(player.m_20148_());
        if (maidSouls.isEmpty()) {
            return;
        }
        for (MaidSoul maidSoul : maidSouls) {
            LittleMaidEntity maid = (LittleMaidEntity)((EntityType)Registration.LITTLE_MAID_MOB.get()).m_20615_((Level)world);
            if (maid == null) continue;
            maid.installMaidSoul(maidSoul);
            maid.m_6027_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            maid.setMovingMode(MovingMode.ESCORT);
            TameableUtil.setWait(maid, true);
            maid.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_146892_());
            maid.m_21563_().m_148051_((Entity)player);
            maid.m_20095_();
            maid.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 10));
            world.m_7967_((Entity)maid);
        }
        worldMaidSoulState.remove(player.m_20148_());
        worldMaidSoulState.m_77762_();
        world.m_7471_(pos, false);
        world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_11934_, SoundSource.PLAYERS, 1.0f, 2.0f);
        world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_11928_, SoundSource.PLAYERS, 1.0f, 2.0f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        float size = 0.5f;
        int count = 10;
        double delta = 1.5;
        world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), size), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
        world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.65f, 0.0f), size), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
        world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), size), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
        world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), size), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
        world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f), size), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
        world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 1.0f), size), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
        world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 1.0f), size), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, count, delta, delta, delta, 0.0);
    }

    protected void m_8099_() {
        int priority = -1;
        final LMRBConfig config = LittleMaidEntity.getConfig();
        this.f_21345_.m_25352_(priority, (Goal)new LMTeleportTameOwnerGoal(this, () -> Float.valueOf(config.movement.emergencyTeleportStartDistance)){

            @Override
            public boolean m_8036_() {
                return LittleMaidEntity.this.isEmergency() && LittleMaidEntity.this.f_20916_ > 0 && !TameableUtil.isWait(LittleMaidEntity.this) && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(++priority, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(++priority, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(++priority, (Goal)new LMHealMyselfGoal(this, () -> config.health.healInterval, () -> config.health.healAmount, stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY)));
        this.f_21345_.m_25352_(++priority, new LMCollectSalaryFromContainerGoal<LittleMaidEntity>(this));
        this.f_21345_.m_25352_(++priority, new WaitGoal<LittleMaidEntity>(this));
        this.f_21345_.m_25352_(++priority, (Goal)new LMTeleportTameOwnerGoal(this, () -> Float.valueOf(config.movement.teleportStartDistance)));
        this.f_21345_.m_25352_(++priority, (Goal)new AvoidEntityGoal<Mob>((PathfinderMob)this, Mob.class, config.target.dangerCloseRangeThreshold, (double)config.movement.followSpeed, (double)config.movement.sprintSpeed, entity -> this.fleeEntities.containsKey(entity)){

            public void m_8037_() {
                LittleMaidEntity.this.fleeEntities.entrySet().removeIf(entry -> ((Predicate)entry.getValue()).test((Mob)entry.getKey()));
                super.m_8037_();
            }

            public void m_8041_() {
                super.m_8041_();
                this.f_25015_.m_21573_().m_26573_();
            }
        });
        this.f_21345_.m_25352_(++priority, (Goal)new ModeWrapperGoal<LittleMaidEntity>(this){

            @Override
            public boolean m_8036_() {
                return !((LittleMaidEntity)this.owner).isStrike() && (config.health.enableWorkInEmergency || !LittleMaidEntity.this.isEmergency()) && super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                return !((LittleMaidEntity)this.owner).isStrike() && (config.health.enableWorkInEmergency || !LittleMaidEntity.this.isEmergency()) && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(++priority, (Goal)new HasMMFollowTameOwnerGoal<LittleMaidEntity>(this, () -> Float.valueOf(config.movement.sprintSpeed), () -> Float.valueOf(config.movement.sprintStartDistance), () -> Float.valueOf(config.movement.sprintEndDistance)){

            @Override
            public void m_8056_() {
                super.m_8056_();
                ((LittleMaidEntity)this.tameable).m_6858_(true);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                ((LittleMaidEntity)this.tameable).m_6858_(false);
            }
        });
        this.f_21345_.m_25352_(++priority, new FollowAtHeldItemGoal<LittleMaidEntity>(this, () -> Float.valueOf(config.misc.stareAtSalaryRange), stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY), () -> Float.valueOf(config.misc.followAtHeldSalaryRange), true));
        this.f_21345_.m_25352_(++priority, new LMStareAtHeldItemGoal<LittleMaidEntity>(this, () -> Float.valueOf(config.misc.stareAtSalaryRange), stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY), true));
        this.f_21345_.m_25352_(++priority, new LMStoreItemToContainerGoal<LittleMaidEntity>(this, stack -> stack.m_204117_(LMTags.Items.MAIDS_SALARY) || this.hasModeImpl.getMode().filter(mode -> mode.getModeType().isModeItem((ItemStack)stack)).isPresent(), () -> Float.valueOf(config.work.searchContainerRange)));
        this.f_21345_.m_25352_(++priority, (Goal)new LMMoveToDropItemGoal(this, () -> Float.valueOf(config.movement.pickupItemRange), () -> config.movement.pickupItemFrequency, () -> Float.valueOf(config.movement.pickupItemSpeed)){

            @Override
            public boolean m_8036_() {
                return TameableUtil.hasTameOwner((OwnableEntity)LittleMaidEntity.this) && (config.health.enableWorkInEmergency || !LittleMaidEntity.this.isEmergency()) && super.m_8036_();
            }

            @Override
            public List<ItemEntity> findAroundDropItem() {
                return TameableUtil.getTameOwner((OwnableEntity)this.maid).map(owner -> super.findAroundDropItem().stream().filter(item -> !this.isOwnerRange((Entity)item, (Entity)owner)).collect(Collectors.toList())).orElse(super.findAroundDropItem());
            }
        });
        this.f_21345_.m_25352_(++priority, new HasMMFollowTameOwnerGoal<LittleMaidEntity>(this, () -> Float.valueOf(config.movement.followSpeed), () -> Float.valueOf(config.movement.followStartDistance), () -> Float.valueOf(config.movement.followEndDistance)));
        this.f_21345_.m_25352_(++priority, (Goal)new PlaySnowGoal(this));
        this.f_21345_.m_25352_(++priority, (Goal)new RedstoneTraceGoal(this, () -> Float.valueOf(config.movement.tracerSpeed)));
        this.f_21345_.m_25352_(++priority, new FreedomGoal<LittleMaidEntity>(this, config.movement.freedomSpeed, () -> Float.valueOf(config.movement.freedomRange)));
        this.f_21345_.m_25352_(++priority, (Goal)new LMMoveToDropItemGoal(this, () -> Float.valueOf(config.movement.pickupItemRange), () -> config.movement.pickupItemFrequency, () -> Float.valueOf(config.movement.pickupItemSpeed)){

            @Override
            public boolean m_8036_() {
                return !TameableUtil.hasTameOwner((OwnableEntity)LittleMaidEntity.this) && config.misc.canPickupItemByNoOwner && (config.health.enableWorkInEmergency || !LittleMaidEntity.this.isEmergency()) && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(++priority, (Goal)new PanicGoal((PathfinderMob)this, config.movement.escapeSpeed){

            public boolean m_8036_() {
                return !TameableUtil.hasTameOwner((OwnableEntity)LittleMaidEntity.this) && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(++priority, new FollowAtHeldItemGoal<LittleMaidEntity>(this, () -> Float.valueOf(config.misc.stareAtEmployItemRange), stack -> stack.m_204117_(LMTags.Items.MAIDS_EMPLOYABLE), () -> Float.valueOf(config.misc.followAtHeldEmployItemRange), false));
        this.f_21345_.m_25352_(++priority, new LMStareAtHeldItemGoal<LittleMaidEntity>(this, () -> Float.valueOf(config.misc.stareAtEmployItemRange), stack -> stack.m_204117_(LMTags.Items.MAIDS_EMPLOYABLE), false));
        this.f_21345_.m_25352_(++priority, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, config.movement.freedomSpeed){

            public boolean m_8036_() {
                return !TameableUtil.hasTameOwner((OwnableEntity)LittleMaidEntity.this) && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(++priority, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(priority, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new LMTargetGoal(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LMM_FLAGS, (Object)0);
        this.f_19804_.m_135372_(MOVING_MODE, (Object)0);
        this.f_19804_.m_135372_(MODE_NAME, (Object)"");
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(ACCELERATE, (Object)false);
        this.f_19804_.m_135372_(MASTER_STANCE, (Object)0);
    }

    public void addDefaultModes(LittleMaidEntity maid) {
        this.hasModeImpl.addAllMode(ModeManager.INSTANCE.createModes(maid));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("maidVersion", (byte)2);
        this.writeInventory(nbt);
        nbt.m_128405_("XpTotal", this.f_21364_);
        if (TameableUtil.getTameOwnerUuid((OwnableEntity)this).isPresent()) {
            nbt.m_128379_("Wait", TameableUtil.isWait(this));
            nbt.m_128344_("MovingMode", (byte)this.getMovingMode().getId());
            nbt.m_128344_("MasterStance", (byte)(this.getMasterStance() != TargetingSystem.MasterStance.GUARD ? 1 : 0));
            this.writeContractable(nbt);
            this.writeIFF(nbt);
            this.writeModeData(nbt);
            nbt.m_128379_("isBloodSuck", this.isBloodSuck());
            if (this.getMovingMode() == MovingMode.FREEDOM && this.freedomPos != null) {
                nbt.m_128365_("FreedomPos", (Tag)NbtUtils.m_129224_((BlockPos)this.freedomPos));
            }
        }
        this.multiModel.writeToNbt(nbt);
        nbt.m_128359_("SoundConfigName", this.getConfigHolder().getName());
        nbt.m_128405_("accelerationTicks", this.accelerationTicks);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        int maidVersion = nbt.m_128445_("maidVersion") & 0xFF;
        if (maidVersion <= 1) {
            Attribute[] entityAttributes;
            AttributeSupplier defaultAttributes = LittleMaidEntity.createLittleMaidAttributes().m_22265_();
            for (Attribute attribute : entityAttributes = new Attribute[]{Attributes.f_22279_, Attributes.f_22277_}) {
                AttributeInstance customInstance = this.m_21204_().m_22146_(attribute);
                if (customInstance == null) continue;
                customInstance.m_22100_(defaultAttributes.m_22253_(attribute));
            }
        }
        this.readInventory(nbt);
        this.f_21364_ = nbt.m_128451_("XpTotal");
        if (maidVersion == 0) {
            ListTag list = nbt.m_128437_("Inventory", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbtCompound = list.m_128728_(i);
                int j = nbtCompound.m_128445_("Slot") & 0xFF;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)nbtCompound);
                if (stack.m_41619_()) continue;
                if (j == 0) {
                    this.m_8061_(EquipmentSlot.MAINHAND, stack);
                    continue;
                }
                if (100 <= j && j < 104) {
                    this.m_8061_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(j - 100)), stack);
                    continue;
                }
                if (j != 150) continue;
                this.m_8061_(EquipmentSlot.OFFHAND, stack);
            }
        }
        if (TameableUtil.hasTameOwner((OwnableEntity)this)) {
            TameableUtil.setWait(this, nbt.m_128471_("Wait"));
            this.setMovingMode(MovingMode.fromId(nbt.m_128445_("MovingMode")));
            this.setMasterStance(nbt.m_128445_("MasterStance") == 0 ? TargetingSystem.MasterStance.GUARD : TargetingSystem.MasterStance.SUPPORT);
            this.readContractable(nbt);
            this.readIFF(nbt);
            this.readModeData(nbt);
            this.setBloodSuck(nbt.m_128471_("isBloodSuck"));
            if (this.getMovingMode() == MovingMode.FREEDOM && nbt.m_128441_("FreedomPos")) {
                this.freedomPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("FreedomPos"));
            }
        }
        this.multiModel.readFromNbt(nbt);
        this.m_6210_();
        if (nbt.m_128441_("SoundConfigName")) {
            LMConfigManager.INSTANCE.getConfig(nbt.m_128461_("SoundConfigName")).ifPresent(this::setConfigHolder);
        }
        this.accelerationTicks = nbt.m_128451_("accelerationTicks");
    }

    public void setRandomTexture() {
        List<TextureHolder> textureHolderList = LMTextureManager.INSTANCE.getAllTextures().stream().filter(h -> h.hasSkinTexture(false)).filter(h -> LMModelManager.INSTANCE.hasModel(h.getModelName())).toList();
        if (textureHolderList.isEmpty()) {
            return;
        }
        TextureHolder textureHolder = textureHolderList.get(this.idFactor % textureHolderList.size());
        List<TextureColors> colorList = Arrays.stream(TextureColors.values()).filter(c -> textureHolder.getTexture(c, false, false).isPresent()).toList();
        if (colorList.isEmpty()) {
            return;
        }
        TextureColors color = colorList.get(this.idFactor % colorList.size());
        this.setColorMM(color);
        this.setTextureHolder(textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD);
        if (textureHolder.hasArmorTexture()) {
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.HEAD);
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.BODY);
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.LEGS);
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.INNER, IHasMultiModel.Part.FEET);
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.HEAD);
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.BODY);
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.LEGS);
            this.setTextureHolder(textureHolder, IHasMultiModel.Layer.OUTER, IHasMultiModel.Part.FEET);
        }
    }

    public void setRandomVoice() {
        if (LittleMaidEntity.getConfig().spawn.silentDefaultVoice) {
            this.soundPlayer.setConfigHolder(LMConfigManager.EMPTY_CONFIG);
        } else {
            List configs = LMConfigManager.INSTANCE.getAllConfig();
            this.soundPlayer.setConfigHolder((ConfigHolder)configs.get(this.idFactor % configs.size()));
        }
        String defaultSoundPackName = LittleMaidEntity.getConfig().spawn.defaultSoundPackName;
        if (!defaultSoundPackName.isEmpty()) {
            LMConfigManager.INSTANCE.getAllConfig().stream().filter(c -> c.getPackName().equalsIgnoreCase(defaultSoundPackName)).findAny().ifPresent(arg_0 -> ((SoundPlayableCompound)this.soundPlayer).setConfigHolder(arg_0));
        }
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.getColorMM());
        buf.writeBoolean(this.isContractMM());
        buf.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).getTextureName());
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            buf.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName());
            buf.m_130070_(this.getTextureHolder(IHasMultiModel.Layer.OUTER, part).getTextureName());
        }
        buf.m_130070_(this.getConfigHolder().getName());
        buf.m_130055_(this.getInventory().m_8020_(17));
        buf.writeFloat(this.m_146909_());
        buf.writeFloat(this.m_146908_());
        buf.m_130130_(this.accelerationTicks);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        this.setColorMM((TextureColors)buf.m_130066_(TextureColors.class));
        this.setContractMM(buf.readBoolean());
        LMTextureManager textureManager = LMTextureManager.INSTANCE;
        textureManager.getTexture(buf.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD));
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            textureManager.getTexture(buf.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.INNER, part));
            textureManager.getTexture(buf.m_130277_()).ifPresent(textureHolder -> this.setTextureHolder((TextureHolder)textureHolder, IHasMultiModel.Layer.OUTER, part));
        }
        LMConfigManager.INSTANCE.getConfig(buf.m_130277_()).ifPresent(this::setConfigHolder);
        this.getInventory().m_6836_(17, buf.m_130267_());
        this.m_146926_(buf.readFloat());
        this.m_146922_(buf.readFloat());
        this.accelerationTicks = buf.m_130242_();
    }

    public void m_7822_(byte status) {
        switch (status) {
            case 70: {
                this.m_21834_(true);
                this.play("se_getCake");
                break;
            }
            case 71: {
                this.m_21834_(true);
                this.play("se_Recontract");
                break;
            }
            case 72: {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 0.25, 0.0, 0.0);
                break;
            }
            case 73: {
                this.showFreedomParticle();
                break;
            }
            case 74: {
                this.m_21834_(false);
                break;
            }
            case 75: {
                this.showTracerParticle();
                break;
            }
            default: {
                super.m_7822_(status);
            }
        }
    }

    protected void showFreedomParticle() {
        for (int i = 0; i < 7; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(this.f_19796_.m_188501_(), this.f_19796_.m_188501_(), this.f_19796_.m_188501_()), 1.0f), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    protected void showTracerParticle() {
        for (int i = 0; i < 7; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    public void m_8119_() {
        int tickMultiple = this.getTickMultiple();
        for (int i = 0; i < tickMultiple; ++i) {
            this.inTickMultiplePre();
            super.m_8119_();
            this.inTickMultiplePost();
        }
    }

    protected void inTickMultiplePre() {
        if (this.experiencePickUpDelay > 0) {
            --this.experiencePickUpDelay;
        }
        if (this.m_9236_().f_46443_) {
            this.tickInterestedAngle();
        }
        this.playSoundCool = Math.max(0, this.playSoundCool - 1);
        this.decAccelerationTicks();
    }

    protected void inTickMultiplePost() {
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    protected void m_8024_() {
        super.m_8024_();
        if (TameableUtil.hasTameOwner((OwnableEntity)this) || LittleMaidEntity.getConfig().misc.canPickupItemByNoOwner) {
            this.pickupItem();
        }
        this.itemContractable.tick();
        this.hasModeImpl.tick();
    }

    protected void pickupItem() {
        LMCollidable collidable;
        if (!LittleMaidEntity.getConfig().misc.canPickupExperienceOrb && !LittleMaidEntity.getConfig().misc.canPickupItem) {
            return;
        }
        if (this.m_21223_() <= 0.0f || this.m_5833_()) {
            return;
        }
        AABB aabb = this.m_20191_().m_82377_(1.0, 0.5, 1.0);
        List aroundItems = this.m_9236_().m_45933_((Entity)this, aabb);
        ArrayList exps = Lists.newArrayList();
        for (Entity entity : aroundItems) {
            if (entity instanceof ExperienceOrb) {
                if (!LittleMaidEntity.getConfig().misc.canPickupExperienceOrb) continue;
                exps.add(entity);
                continue;
            }
            if (!LittleMaidEntity.getConfig().misc.canPickupItem || entity.m_213877_() || !(entity instanceof LMCollidable)) continue;
            LMCollidable collidable2 = (LMCollidable)entity;
            collidable2.onCollision_LMRB(this);
        }
        if (!exps.isEmpty() && (collidable = (LMCollidable)Util.m_214621_((List)exps, (RandomSource)this.f_19796_)) != null) {
            collidable.onCollision_LMRB(this);
        }
    }

    public boolean m_6785_(double distanceSquared) {
        return LittleMaidEntity.getConfig().spawn.canDespawn && TameableUtil.getTameOwnerUuid((OwnableEntity)this).isEmpty();
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)world, pos) ? 10.0f : world.m_220419_(pos);
    }

    public boolean m_6779_(LivingEntity target) {
        return super.m_6779_(target) && !this.isFriend(target);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public double m_6048_() {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        return model.getMountedYOffset(this.getCaps());
    }

    public double m_6049_() {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        return model.getyOffset(this.getCaps()) - this.m_20206_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        IMultiModel model = this.getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD).orElse(LMModelManager.INSTANCE.getDefaultModel());
        float height = model.getHeight(this.getCaps(), MMPose.convertPose((Pose)pose));
        float width = model.getWidth(this.getCaps(), MMPose.convertPose((Pose)pose));
        EntityDimensions dimensions = EntityDimensions.m_20395_((float)width, (float)height);
        return dimensions.m_20388_(this.m_6134_());
    }

    @Nullable
    public Entity m_5489_(ServerLevel destination) {
        Entity entity = super.m_5489_(destination);
        if (entity == null) {
            return null;
        }
        if (entity instanceof LittleMaidEntity && this.getMovingMode() == MovingMode.FREEDOM) {
            ((LittleMaidEntity)entity).setFreedomPos(null);
        }
        return entity;
    }

    public boolean m_21444_(BlockPos pos) {
        if (pos.m_123314_((Vec3i)pos, 16.0) || TameableUtil.getTameOwner((OwnableEntity)this).filter(owner -> owner.m_20183_().m_123314_((Vec3i)pos, 16.0)).isPresent()) {
            return super.m_21444_(pos);
        }
        return false;
    }

    public void m_8032_() {
        if (this.m_9236_().f_46443_ || this.f_20890_ || this.getConfigHolder().getParameter("LivingVoiceRate").map(s -> {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(Float.valueOf(0.2f)).floatValue() < this.f_19796_.m_188501_()) {
            return;
        }
        if (this.m_21223_() / this.m_21233_() < 0.3f) {
            this.play("se_living_whine");
        } else if (this.f_19797_ % 4 == 0 && this.m_9236_().m_45527_(this.m_20183_())) {
            Biome biome = (Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_();
            if (biome.m_198904_(this.m_20183_())) {
                this.play("se_living_cold");
            } else if (2.0f <= biome.m_47554_()) {
                this.play("se_living_hot");
            }
        } else if (this.f_19797_ % 4 == 1 && this.m_9236_().m_46471_()) {
            BlockPos pos = this.m_20183_();
            Biome biome = (Biome)this.m_9236_().m_204166_(pos).m_203334_();
            if (biome.m_264600_(pos) == Biome.Precipitation.RAIN) {
                this.play("se_living_rain");
            } else if (biome.m_264600_(pos) == Biome.Precipitation.SNOW) {
                this.play("se_living_snow");
            }
        } else if (this.m_21205_().m_41720_() == Items.f_42524_ || this.m_21206_().m_41720_() == Items.f_42524_) {
            int time = (int)(this.m_9236_().m_46468_() % 24000L);
            if (time < 1500 || 23500 <= time) {
                this.play("se_living_morning");
            } else if (12500 <= time) {
                this.play("se_living_night");
            } else {
                this.play("se_living_daytime");
            }
        } else {
            this.play("se_living_daytime");
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.playSoundCool = 0;
        this.play("se_death");
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            TameableUtil.getTameOwnerUuid((OwnableEntity)this).ifPresent(id -> {
                MaidSoulEntity maidSoulEntity = new MaidSoulEntity((Level)serverWorld, new MaidSoul(this.m_20240_(new CompoundTag())));
                maidSoulEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                maidSoulEntity.m_20256_(new Vec3(this.f_19796_.m_188583_() * 0.02, 0.2, this.f_19796_.m_188583_() * 0.02));
                serverWorld.m_7967_((Entity)maidSoulEntity);
            });
        }
    }

    public void installMaidSoul(MaidSoul maidSoul) {
        this.m_20258_(maidSoul.getNbt());
        this.m_21153_(this.m_21233_());
        this.m_146912_();
        this.f_20890_ = false;
        this.f_20919_ = 0;
    }

    public boolean m_7327_(Entity target) {
        boolean result = super.m_7327_(target);
        if (this.isBloodSuck()) {
            this.play("se_attack_bloodsuck");
        } else {
            this.play("se_attack");
        }
        if (result) {
            ItemStack mainHandStack = this.m_21205_();
            Entity entity = target;
            if (target instanceof EnderDragonPart) {
                entity = ((EnderDragonPart)target).f_31010_;
            }
            if (!this.m_9236_().f_46443_ && !mainHandStack.m_41619_() && entity instanceof LivingEntity) {
                try {
                    mainHandStack.m_41720_().m_7579_(mainHandStack, (LivingEntity)entity, (LivingEntity)this);
                }
                catch (Exception e) {
                    LMRBMod.LOGGER.error("\u30e1\u30a4\u30c9\u3055\u3093\u306e\u653b\u6483\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                }
                if (mainHandStack.m_41619_()) {
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
        }
        return result;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_20890_) {
            return super.m_6469_(source, amount);
        }
        if (!this.m_9236_().f_46443_ && amount <= 0.0f && source.m_7640_() instanceof Snowball) {
            this.play("se_hurt_snow");
            return false;
        }
        LMRBConfig config = LittleMaidEntity.getConfig();
        if (config.health.nonMobDamageImmunity && source.m_7639_() == null) {
            return false;
        }
        if (config.health.immortal && !source.m_276093_(DamageTypes.f_268724_) && !source.m_19390_()) {
            return false;
        }
        if (config.health.fallImmunity && source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        Entity attacker = source.m_7639_();
        if (!config.health.enableFriendlyFire && attacker instanceof LivingEntity && this.isFriend((LivingEntity)attacker)) {
            return false;
        }
        float factor = config.health.generalMaidDamageFactor;
        factor = (config.health.enableWorkInEmergency || !this.isEmergency()) && !TameableUtil.isWait(this) && this.getMode().map(Mode::isBattleMode).orElse(false).booleanValue() ? (factor *= config.health.battleModeMaidDamageFactor) : (factor *= config.health.nonBattleModeMaidDamageFactor);
        boolean isHurtTime = 0 < this.f_20916_;
        boolean result = super.m_6469_(source, amount *= factor);
        if (!this.m_9236_().f_46443_ && !isHurtTime) {
            if (result && 0.0f < amount && TameableUtil.isWait(this) && TameableUtil.getTameOwnerUuid((OwnableEntity)this).isPresent()) {
                TameableUtil.setWait(this, false);
            }
            if (!result || amount <= 0.0f) {
                this.play("se_hurt_nodamege");
            } else if (amount > 0.0f && this.m_21275_(source)) {
                this.play("se_hurt_guard");
            } else if (source.m_276093_(DamageTypes.f_268671_)) {
                this.play("se_hurt_fall");
            } else if (source.m_269415_().f_268686_() == DamageEffects.BURNING) {
                this.play("se_hurt_fire");
            } else {
                this.play("se_hurt");
            }
        }
        return result;
    }

    public boolean isEmergency() {
        LMRBConfig config = LittleMaidEntity.getConfig();
        return this.m_21223_() / this.m_21233_() <= config.health.emergencyMaidHealthThreshold;
    }

    public void m_21153_(float health) {
        LMRBConfig config = LittleMaidEntity.getConfig();
        if (config.health.disableMaidDeath && health <= 0.0f) {
            super.m_21153_(1.0f);
            return;
        }
        super.m_21153_(health);
    }

    public boolean m_214076_(ServerLevel world, LivingEntity other) {
        if (this.isBloodSuck()) {
            this.play("se_laughter");
        }
        return super.m_214076_(world, other);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        ItemStack stack = this.m_21205_();
        ItemStack arrowStack = this.m_6298_(stack);
        if (arrowStack.m_41619_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) == 0) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof BowItem) {
            BowItem bowItem = (BowItem)item;
            AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)pullProgress);
            arrow = EPEntityUtil.arrowCustomHook(bowItem, arrow);
            double xDiff = target.m_20185_() - this.m_20185_();
            double yDiff = target.m_20188_() - arrow.m_20186_();
            double zDiff = target.m_20189_() - this.m_20189_();
            double horizonLen = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            arrow.m_6686_(xDiff, yDiff + horizonLen * 0.025, zDiff, pullProgress * 3.0f * LittleMaidEntity.getConfig().work.archerShootVelocityFactor, 6.0f);
            this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 1.2f) + pullProgress * 0.5f);
            this.m_9236_().m_7967_((Entity)arrow);
            arrowStack.m_41774_(1);
        } else if (stack.m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, CrossbowItemInvoker.getSpeed(stack));
        }
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void m_6136_(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public void m_5811_(LivingEntity target, ItemStack crossbow, Projectile projectile, float multiShotSpray) {
        this.m_32322_((LivingEntity)this, target, projectile, multiShotSpray, CrossbowItemInvoker.getSpeed(crossbow));
    }

    public void m_32322_(LivingEntity entity, LivingEntity target, Projectile projectile, float multishotSpray, float speed) {
        double xDiff = target.m_20185_() - entity.m_20185_();
        double yDiff = target.m_20188_() - projectile.m_20186_();
        double zDiff = target.m_20189_() - entity.m_20189_();
        double horizonLen = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        Vector3f targetAt = this.m_252851_(entity, new Vec3(xDiff, yDiff + horizonLen * 0.025, zDiff), multishotSpray);
        projectile.m_6686_((double)targetAt.x(), (double)targetAt.y(), (double)targetAt.z(), speed * LittleMaidEntity.getConfig().work.archerShootVelocityFactor, (float)(14 - entity.m_9236_().m_46791_().m_19028_() * 4));
        entity.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (entity.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_5847_() {
    }

    protected Vec3 m_5763_(Vec3 movement, MoverType type) {
        if (type != MoverType.SELF && type != MoverType.PLAYER) {
            return movement;
        }
        LMRBConfig config = LittleMaidEntity.getConfig();
        if (!config.health.immortal && !LittleMaidEntity.getConfig().health.nonMobDamageImmunity && config.health.enableSafeMove && this.canClipAtLedge()) {
            boolean shouldBackByFall;
            boolean shouldBackByDamage = this.isDamageSourceEmpty(this.m_20191_()) && !this.isDamageSourceEmpty(this.m_20191_().m_82386_(movement.f_82479_, 0.0, movement.f_82481_));
            boolean bl = shouldBackByFall = !config.health.fallImmunity && !this.isSafeFallHeight(this.m_20182_().m_82520_(movement.f_82479_, 0.0, movement.f_82481_));
            if (shouldBackByDamage || shouldBackByFall) {
                BiPredicate<Double, Double> finalPredicate;
                BiPredicate<Double, Double> shouldBackPredicate = (x, z) -> false;
                if (shouldBackByDamage) {
                    finalPredicate = shouldBackPredicate;
                    shouldBackPredicate = (x, z) -> finalPredicate.test((Double)x, (Double)z) || !this.isDamageSourceEmpty(this.m_20191_().m_82386_(x.doubleValue(), 0.0, z.doubleValue()));
                }
                if (shouldBackByFall) {
                    finalPredicate = shouldBackPredicate;
                    shouldBackPredicate = (x, z) -> finalPredicate.test((Double)x, (Double)z) || this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(x.doubleValue(), 0.0, z.doubleValue()).m_82363_(0.0, (double)(-(this.getDangerHeightThreshold() - this.f_19789_)), 0.0)) || this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(x.doubleValue(), 0.0, z.doubleValue()).m_82363_(0.0, (double)(-this.m_274421_()), 0.0)) && !this.isDamageSourceEmpty(this.m_20191_().m_82386_(x.doubleValue(), 0.0, z.doubleValue()).m_82363_(0.0, (double)(-this.getDangerHeightThreshold()), 0.0));
                }
                movement = this.pushBack(movement, shouldBackPredicate);
            }
        }
        return movement;
    }

    private Vec3 pushBack(Vec3 movement, BiPredicate<Double, Double> pushBackPredicate) {
        double dot = 0.05;
        double mX = movement.f_82479_;
        double mZ = movement.f_82481_;
        while (mX != 0.0 && pushBackPredicate.test(mX, 0.0)) {
            if (mX < dot && mX >= -dot) {
                mX = 0.0;
                continue;
            }
            if (mX > 0.0) {
                mX -= dot;
                continue;
            }
            mX += dot;
        }
        while (mZ != 0.0 && pushBackPredicate.test(0.0, mZ)) {
            if (mZ < dot && mZ >= -dot) {
                mZ = 0.0;
                continue;
            }
            if (mZ > 0.0) {
                mZ -= dot;
                continue;
            }
            mZ += dot;
        }
        while (mX != 0.0 && mZ != 0.0 && pushBackPredicate.test(mX, mZ)) {
            double d = mX < dot && mX >= -dot ? 0.0 : (mX = mX > 0.0 ? mX - dot : mX + dot);
            if (mZ < dot && mZ >= -dot) {
                mZ = 0.0;
                continue;
            }
            if (mZ > 0.0) {
                mZ -= dot;
                continue;
            }
            mZ += dot;
        }
        return new Vec3(mX, movement.f_82480_, mZ);
    }

    private boolean isDamageSourceEmpty(AABB box) {
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14107_((double)box.f_82291_);
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14107_((double)box.f_82292_);
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14107_((double)box.f_82293_);
        for (int x = 0; x < maxX - minX + 1; ++x) {
            for (int y = 0; y < maxY - minY + 1; ++y) {
                for (int z = 0; z < maxZ - minZ + 1; ++z) {
                    BlockPathTypes pathNodeType = this.m_21573_().m_26575_().m_8086_((BlockGetter)this.m_9236_(), minX + x, minY + y, minZ + z);
                    if (pathNodeType != BlockPathTypes.DAMAGE_FIRE && pathNodeType != BlockPathTypes.DAMAGE_OTHER && pathNodeType != BlockPathTypes.LAVA) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isSafeFallHeight(Vec3 pos) {
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(pos, pos.m_82492_(0.0, (double)(this.getDangerHeightThreshold() - this.f_19789_) + 0.1, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        Vec3 hitPos = result.m_82450_();
        if ((double)(this.getDangerHeightThreshold() - this.f_19789_) < pos.f_82480_ - hitPos.f_82480_) {
            return false;
        }
        BlockPos checkPos = new BlockPos(Mth.m_14107_((double)pos.f_82479_), Mth.m_14107_((double)(pos.f_82480_ - 1.0)), Mth.m_14107_((double)pos.f_82481_));
        int i = 0;
        while ((double)i < pos.f_82480_ - hitPos.f_82480_ + 1.0) {
            BlockPathTypes pathNodeType = this.m_21573_().m_26575_().m_8086_((BlockGetter)this.m_9236_(), checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_());
            if (pathNodeType == BlockPathTypes.WALKABLE || pathNodeType == BlockPathTypes.BLOCKED) {
                return true;
            }
            if (pathNodeType == BlockPathTypes.DAMAGE_FIRE || pathNodeType == BlockPathTypes.DAMAGE_OTHER || pathNodeType == BlockPathTypes.LAVA) {
                return false;
            }
            checkPos = checkPos.m_7495_();
            ++i;
        }
        return false;
    }

    private boolean canClipAtLedge() {
        float canClipHeight = this.getDangerHeightThreshold() + 1.0f;
        return this.m_20096_() || this.f_19789_ < canClipHeight && !this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82363_(0.0, (double)(this.f_19789_ - canClipHeight), 0.0));
    }

    private float getDangerHeightThreshold() {
        int fallDamage = this.m_5639_(0.0f, 1.0f);
        return -fallDamage;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(this.m_20192_() - 0.15f), 0.0625);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (TameableUtil.getTameOwnerUuid((OwnableEntity)this).isEmpty()) {
            if (stack.m_204117_(LMTags.Items.MAIDS_EMPLOYABLE)) {
                return this.contract(player, stack, false);
            }
            return InteractionResult.PASS;
        }
        if (!player.m_20148_().equals(this.m_21805_())) {
            return InteractionResult.PASS;
        }
        if (this.isStrike()) {
            if (stack.m_204117_(LMTags.Items.MAIDS_EMPLOYABLE)) {
                return this.contract(player, stack, true);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)6);
            return InteractionResult.PASS;
        }
        if (stack.m_41720_() instanceof SaddleItem) {
            if (!this.m_20159_()) {
                if (player.m_20160_()) {
                    player.m_20153_();
                }
                this.m_20329_((Entity)player);
            } else {
                Entity vehicle = this.m_20202_();
                if (vehicle == player) {
                    this.m_8127_();
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_20202_() == player) {
            return InteractionResult.PASS;
        }
        if (stack.m_204117_(LMTags.Items.MAIDS_SALARY)) {
            LMRBConfig config = LittleMaidEntity.getConfig();
            this.m_5634_(config.health.healAmount);
            return this.changeState(player, stack);
        }
        if (stack.m_41720_() == Items.f_42402_) {
            if (this.getMovingMode() == MovingMode.ESCORT) {
                this.m_9236_().m_7605_((Entity)this, (byte)73);
                this.setMovingMode(MovingMode.FREEDOM);
                this.setFreedomPos(this.m_20183_());
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)74);
                this.setMovingMode(MovingMode.ESCORT);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if ((this.getMovingMode() == MovingMode.FREEDOM || this.getMovingMode() == MovingMode.TRACER) && stack.m_41720_() == Items.f_42451_) {
            if (this.getMovingMode() == MovingMode.FREEDOM) {
                this.m_9236_().m_7605_((Entity)this, (byte)75);
                this.setMovingMode(MovingMode.TRACER);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)73);
                this.setMovingMode(MovingMode.FREEDOM);
                this.setFreedomPos(this.m_20183_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.f_21364_ >= 7 && stack.m_150930_(Items.f_42590_)) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11770_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42612_.m_7968_());
            player.m_21008_(hand, itemStack2);
            this.addExperience(-7);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (LittleMaidEntity.getConfig().misc.canMilking && stack.m_150930_(Items.f_42446_)) {
            player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
            player.m_21008_(hand, itemStack2);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (stack.m_41720_() == Items.f_42403_) {
            int maxAccelerationStack = LittleMaidEntity.getConfig().misc.maxAccelerationStack;
            int accelerationTicks = LittleMaidEntity.getConfig().misc.accelerationTicksPerStack;
            int resumeCount = Math.min(maxAccelerationStack, stack.m_41613_());
            int acTicks = resumeCount * accelerationTicks;
            this.setAccelerationTicks(acTicks);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(resumeCount);
                if (stack.m_41619_()) {
                    player.m_150109_().m_36057_(stack);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        this.openInventory(player);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public InteractionResult changeState(Player player, ItemStack stack) {
        this.m_9236_().m_7605_((Entity)this, (byte)72);
        this.m_5496_(SoundEvents.f_12019_, 1.0f, this.f_19796_.m_188501_() * 0.1f + 1.0f);
        this.setFreedomPos(this.m_20183_());
        this.m_21573_().m_26573_();
        TameableUtil.switchWait(this);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_150109_().m_36057_(stack);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public InteractionResult contract(Player player, ItemStack stack, boolean isReContract) {
        if (!isReContract) {
            this.m_9236_().m_7605_((Entity)this, (byte)70);
            if (player instanceof ServerPlayer) {
                LMRBCriteria.CONTRACT_MAID.trigger((ServerPlayer)player, this);
            }
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)71);
        }
        this.m_21816_(player.m_20148_());
        this.setContractMM(true);
        if (!this.m_9236_().f_46443_) {
            SyncMultiModelPacket.sendS2CPacket((Entity)this, (IHasMultiModel)this);
        }
        this.setStrike(false);
        this.itemContractable.setUnpaidTimes(0);
        this.m_21573_().m_26573_();
        this.setMovingMode(MovingMode.ESCORT);
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                player.m_150109_().m_36057_(stack);
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public void addExperience(int experience) {
        this.f_21364_ = Mth.m_14045_((int)(this.f_21364_ + experience), (int)0, (int)Integer.MAX_VALUE);
    }

    public void openInventory(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        this.m_6703_(null);
        this.m_21573_().m_26573_();
        this.setModeName(this.getMode().map(Mode::getName).orElse(""));
        MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)this.screenFactory);
    }

    public void setLMMFlag(int index, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(LMM_FLAGS)).byteValue();
        int mask = 1 << index;
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(LMM_FLAGS, (Object)((byte)i));
    }

    public boolean getLMMFlag(int index) {
        return ((Byte)this.f_19804_.m_135370_(LMM_FLAGS) & 1 << index) != 0;
    }

    @Override
    public MovingMode getMovingMode() {
        return MovingMode.fromId(((Byte)this.f_19804_.m_135370_(MOVING_MODE)).byteValue());
    }

    @Override
    public void setMovingMode(MovingMode movingMode) {
        this.f_19804_.m_135381_(MOVING_MODE, (Object)((byte)movingMode.getId()));
    }

    public TargetingSystem.MasterStance getMasterStance() {
        return (Byte)this.f_19804_.m_135370_(MASTER_STANCE) == 0 ? TargetingSystem.MasterStance.GUARD : TargetingSystem.MasterStance.SUPPORT;
    }

    public void setMasterStance(TargetingSystem.MasterStance masterStance) {
        this.f_19804_.m_135381_(MASTER_STANCE, (Object)(masterStance == TargetingSystem.MasterStance.GUARD ? (byte)0 : 1));
    }

    public void addFleeEntity(Mob entity, Predicate<Mob> removePredicate) {
        this.fleeEntities.put(entity, removePredicate);
    }

    @Override
    public Container getInventory() {
        return this.littleMaidInventory.getInventory();
    }

    @Override
    public void writeInventory(CompoundTag tag) {
        this.littleMaidInventory.writeInventory(tag);
    }

    @Override
    public void readInventory(CompoundTag tag) {
        this.littleMaidInventory.readInventory(tag);
    }

    public int getWorkItemSlotSize() {
        return this.littleMaidInventory.getWorkItemSlotSize();
    }

    public void setWorkItemSlotNum(int num) {
        this.littleMaidInventory.setWorkItemSlotSize(num);
    }

    protected void m_6472_(DamageSource source, float amount) {
        if (!(amount <= 0.0f)) {
            float f;
            amount /= 4.0f;
            if (f < 1.0f) {
                amount = 1.0f;
            }
            int i = -1;
            for (ItemStack stack : this.m_6168_()) {
                ++i;
                if (source.m_269533_(DamageTypeTags.f_268745_) && stack.m_41720_().m_41475_() || !(stack.m_41720_() instanceof ArmorItem)) continue;
                EquipmentSlot slot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i);
                stack.m_41622_((int)amount, (LivingEntity)this, arg -> arg.m_21166_(slot));
            }
        }
    }

    protected void m_142642_(DamageSource source, float amount) {
        if (!(amount <= 0.0f)) {
            float f;
            amount /= 4.0f;
            if (f < 1.0f) {
                amount = 1.0f;
            }
            ItemStack stack = this.m_6844_(EquipmentSlot.HEAD);
            if (source.m_269533_(DamageTypeTags.f_268745_) && stack.m_41720_().m_41475_() || !(stack.m_41720_() instanceof ArmorItem)) {
                return;
            }
            stack.m_41622_((int)amount, (LivingEntity)this, arg -> arg.m_21166_(EquipmentSlot.HEAD));
        }
    }

    protected void m_7909_(float amount) {
    }

    public SlotAccess m_141942_(int mappedIndex) {
        Container inv = this.getInventory();
        int i = mappedIndex - 200;
        if (0 <= i && i < inv.m_6643_()) {
            return SlotAccess.m_147292_((Container)inv, (int)i);
        }
        return super.m_141942_(mappedIndex);
    }

    public ItemStack m_6298_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ProjectileWeaponItem)) {
            return ItemStack.f_41583_;
        }
        ProjectileWeaponItem ranged = (ProjectileWeaponItem)item;
        Predicate predicate = ranged.m_6442_();
        ItemStack itemStack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
        if (!itemStack.m_41619_()) {
            return EPEntityUtil.arrowCustomHook((LivingEntity)this, stack, itemStack);
        }
        predicate = ranged.m_6437_();
        Container inv = this.getInventory();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemStack2 = inv.m_8020_(i);
            if (!predicate.test(itemStack2)) continue;
            return EPEntityUtil.arrowCustomHook((LivingEntity)this, stack, itemStack2);
        }
        return EPEntityUtil.arrowCustomHook((LivingEntity)this, stack, ItemStack.f_41583_);
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        super.m_8061_(slot, stack);
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.multiModel.updateArmor();
        }
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean allowDrops) {
    }

    protected void m_5907_() {
        Container inv = this.getInventory();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)stack)) continue;
            this.m_19983_(stack);
            inv.m_6836_(i, ItemStack.f_41583_);
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = this.m_6844_(slot);
            if (stack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)stack)) continue;
            this.m_19983_(stack);
            this.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    public void m_20084_(UUID uuid) {
        super.m_20084_(uuid);
        this.initIdFactor();
    }

    public void initIdFactor() {
        this.idFactor = Math.abs(this.m_20148_().hashCode());
    }

    public int getIdFactor() {
        return this.idFactor;
    }

    public void m_21816_(@Nullable UUID uuid) {
        super.m_21816_(uuid);
        this.setContract(true);
    }

    public void setFreedomPos(@Nullable BlockPos freedomPos) {
        this.freedomPos = freedomPos;
    }

    public Optional<BlockPos> getFreedomPos() {
        if (this.getMovingMode() != MovingMode.FREEDOM) {
            return Optional.empty();
        }
        if (this.freedomPos == null) {
            this.freedomPos = this.m_20183_();
        }
        return Optional.of(this.freedomPos);
    }

    public void m_21837_(boolean inSittingPose) {
    }

    public boolean m_21825_() {
        return TameableUtil.isWait(this);
    }

    public void m_21839_(boolean sitting) {
        this.setLMMFlag(0, sitting);
    }

    public boolean m_21827_() {
        return this.getLMMFlag(0);
    }

    public boolean m_21824_() {
        return TameableUtil.getTameOwnerUuid((OwnableEntity)this).isPresent();
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public boolean isBegging() {
        return this.getLMMFlag(2);
    }

    public void setBegging(boolean begging) {
        this.setLMMFlag(2, begging);
    }

    public boolean isBloodSuck() {
        return this.getLMMFlag(3);
    }

    public void setBloodSuck(boolean isBloodSuck) {
        this.setLMMFlag(3, isBloodSuck);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float tickDelta) {
        return (this.prevInterestedAngle + (this.interestedAngle - this.prevInterestedAngle) * tickDelta) * ((this.m_19879_() % 2 == 0 ? 0.08f : -0.08f) * (float)Math.PI);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickInterestedAngle() {
        this.prevInterestedAngle = this.interestedAngle;
        this.interestedAngle = this.isBegging() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
    }

    public int getTickMultiple() {
        return this.isAcceleration() ? LittleMaidEntity.getConfig().misc.accelerationMultiple : 1;
    }

    public void setAccelerationTicks(int ticks) {
        this.accelerationTicks = ticks;
        if (ticks > 0) {
            this.f_19804_.m_135381_(ACCELERATE, (Object)true);
        }
    }

    public void decAccelerationTicks() {
        if (this.accelerationTicks > 0) {
            --this.accelerationTicks;
        }
        if (this.accelerationTicks <= 0) {
            this.accelerationTicks = 0;
            this.f_19804_.m_135381_(ACCELERATE, (Object)false);
        }
    }

    public int getAccelerationTicks() {
        return this.accelerationTicks;
    }

    public boolean isAcceleration() {
        return (Boolean)this.f_19804_.m_135370_(ACCELERATE);
    }

    @Override
    public boolean isContract() {
        return TameableUtil.getTameOwnerUuid((OwnableEntity)this).isPresent();
    }

    @Override
    public void setContract(boolean isContract) {
        this.itemContractable.setContract(isContract);
    }

    @Override
    public boolean isStrike() {
        return this.getLMMFlag(4);
    }

    @Override
    public void setStrike(boolean strike) {
        this.itemContractable.setStrike(strike);
        this.setLMMFlag(4, strike);
    }

    @Override
    public void writeContractable(CompoundTag nbt) {
        this.itemContractable.writeContractable(nbt);
    }

    @Override
    public void readContractable(CompoundTag nbt) {
        this.itemContractable.readContractable(nbt);
        if (this.itemContractable.isStrike()) {
            this.setStrike(true);
        }
    }

    public int getUnpaidDays() {
        return this.itemContractable.getUnpaidTimes();
    }

    @Override
    public void listenSalaryBoxPos(BlockPos pos) {
        this.itemContractable.listenSalaryBoxPos(pos);
    }

    @Override
    public Optional<Mode> getMode() {
        if (this.isStrike()) {
            return Optional.empty();
        }
        return this.hasModeImpl.getMode();
    }

    @Override
    public void writeModeData(CompoundTag tag) {
        this.hasModeImpl.writeModeData(tag);
    }

    @Override
    public void readModeData(CompoundTag tag) {
        this.hasModeImpl.readModeData(tag);
    }

    public void addMode(Mode mode) {
        this.hasModeImpl.addMode(mode);
    }

    public void addAllMode(Collection<Mode> mode) {
        this.hasModeImpl.addAllMode(mode);
    }

    public void setModeName(String modeName) {
        this.f_19804_.m_135381_(MODE_NAME, (Object)modeName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<String> getModeName() {
        String modeName = (String)this.f_19804_.m_135370_(MODE_NAME);
        if (modeName.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(modeName);
    }

    @Override
    public Optional<IFFTag> identify(LivingEntity target) {
        UUID ownerId = this.m_21805_();
        if (ownerId != null) {
            OwnableEntity tameableTarget;
            if (ownerId.equals(target.m_20148_())) {
                return Optional.of(IFFTag.FRIEND);
            }
            if (target instanceof OwnableEntity && TameableUtil.equalTameOwner((OwnableEntity)this, tameableTarget = (OwnableEntity)target)) {
                return Optional.of(IFFTag.FRIEND);
            }
        }
        return TameableUtil.getTameOwner((OwnableEntity)this).filter(owner -> owner instanceof HasIFF).map(owner -> (HasIFF)owner).flatMap(t -> t.identify(target));
    }

    @Override
    public void setIFFs(List<IFF> iffs) {
    }

    @Override
    public List<IFF> getIFFs() {
        return Lists.newArrayList();
    }

    @Override
    public void writeIFF(CompoundTag nbt) {
    }

    @Override
    public void readIFF(CompoundTag nbt) {
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        return !this.isFriend(target);
    }

    public boolean isFriend(LivingEntity entity) {
        return this.identify(entity).orElse(null) == IFFTag.FRIEND;
    }

    public boolean isEnemy(LivingEntity entity) {
        if (!TameableUtil.hasTameOwner((OwnableEntity)this)) {
            return false;
        }
        return this.isBloodSuck() ? !this.isFriend(entity) : this.identify(entity).orElse(null) == IFFTag.ENEMY;
    }

    @Override
    public boolean isAimingBow() {
        return this.getLMMFlag(1);
    }

    @Override
    public void setAimingBow(boolean aiming) {
        this.setLMMFlag(1, aiming);
    }

    public boolean isAllowChangeTexture(Entity entity, TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.isAllowChangeTexture(entity, textureHolder, layer, part);
    }

    public void setTextureHolder(TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        this.multiModel.setTextureHolder(textureHolder, layer, part);
        if (layer == IHasMultiModel.Layer.SKIN) {
            this.m_6210_();
        }
    }

    public TextureHolder getTextureHolder(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.getTextureHolder(layer, part);
    }

    public void setColorMM(TextureColors textureColor) {
        this.multiModel.setColorMM(textureColor);
    }

    public TextureColors getColorMM() {
        return this.multiModel.getColorMM();
    }

    public void setContractMM(boolean isContract) {
        this.multiModel.setContractMM(isContract);
    }

    public boolean isContractMM() {
        return this.multiModel.isContractMM();
    }

    public Optional<IMultiModel> getModel(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
        return this.multiModel.getModel(layer, part);
    }

    public Optional<ResourceLocation> getTexture(IHasMultiModel.Layer layer, IHasMultiModel.Part part, boolean isLight) {
        return this.multiModel.getTexture(layer, part, isLight);
    }

    public IModelCaps getCaps() {
        return this.caps;
    }

    public boolean isArmorVisible(IHasMultiModel.Part part) {
        return this.multiModel.isArmorVisible(part);
    }

    public boolean isArmorGlint(IHasMultiModel.Part part) {
        return this.multiModel.isArmorGlint(part);
    }

    public boolean isPlayingSnow() {
        return this.getLMMFlag(5);
    }

    public void setPlayingSnow(boolean isPlayingSnow) {
        this.setLMMFlag(5, isPlayingSnow);
    }

    public void play(String soundName) {
        if (0 < this.playSoundCool) {
            return;
        }
        this.playSoundCool = LittleMaidEntity.getConfig().misc.playSoundInterval;
        if (this.isBloodSuck()) {
            if (soundName.equals("se_findTarget_N")) {
                soundName = "se_findTarget_B";
            } else if (soundName.equals("se_attack")) {
                soundName = "se_attack_bloodsuck";
            }
        }
        this.soundPlayer.play(soundName);
    }

    public void setConfigHolder(ConfigHolder configHolder) {
        this.soundPlayer.setConfigHolder(configHolder);
    }

    public ConfigHolder getConfigHolder() {
        return this.soundPlayer.getConfigHolder();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return SpawnLittleMaidPacket.create(this);
    }

    public static LMRBConfig getConfig() {
        return LMRBMod.getConfig();
    }

    public static class MaidSoul {
        private final CompoundTag nbt;

        public MaidSoul(CompoundTag nbt) {
            this.nbt = nbt;
        }

        public CompoundTag getNbt() {
            return this.nbt;
        }

        public Optional<UUID> getOwnerUUID() {
            return Optional.ofNullable(this.nbt.m_128342_("Owner"));
        }
    }

    public static class LMStareAtHeldItemGoal<T extends LittleMaidEntity>
    extends TameableStareAtHeldItemGoal<T> {
        private final LittleMaidEntity maid;

        public LMStareAtHeldItemGoal(T mob, Supplier<Float> stareAtRange, Predicate<ItemStack> targetItem, boolean isTamed) {
            super(mob, stareAtRange, targetItem, isTamed);
            this.maid = mob;
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            this.maid.setBegging(this.maid.m_21573_().m_26571_());
        }

        public void m_8041_() {
            super.m_8041_();
            this.maid.setBegging(false);
        }
    }
}

