/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.util.HasInventory;

public class LMHasInventory
implements HasInventory {
    private final Container inventory;
    private int workItemSlotSize;

    public LMHasInventory() {
        this.workItemSlotSize = LMRBMod.getConfig().work.defaultWorkItemSlotSize;
        this.inventory = new SimpleContainer(18);
    }

    public LMHasInventory(int workItemSlotSize) {
        this.workItemSlotSize = LMRBMod.getConfig().work.defaultWorkItemSlotSize;
        this.inventory = new SimpleContainer(18);
        this.workItemSlotSize = workItemSlotSize;
    }

    @Override
    public Container getInventory() {
        return this.inventory;
    }

    public int getWorkItemSlotSize() {
        return this.workItemSlotSize;
    }

    public void setWorkItemSlotSize(int workItemSlotSize) {
        this.workItemSlotSize = workItemSlotSize;
    }

    @Override
    public void writeInventory(CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.writeNbt(new ListTag()));
        nbt.m_128344_("workItemSlotSize", (byte)this.workItemSlotSize);
    }

    @Override
    public void readInventory(CompoundTag nbt) {
        int maidVersion = nbt.m_128445_("maidVersion") & 0xFF;
        if (maidVersion == 0) {
            this.readNbtOld(nbt.m_128437_("Inventory", 10));
        } else {
            this.readNbt(nbt.m_128437_("Inventory", 10));
        }
        if (nbt.m_128441_("workItemSlotSize")) {
            this.workItemSlotSize = nbt.m_128445_("workItemSlotSize") & 0xFF;
        }
    }

    public ListTag writeNbt(ListTag nbtList) {
        for (int i = 0; i < 18; ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Slot", (byte)i);
            stack.m_41739_(nbt);
            nbtList.add((Object)nbt);
        }
        return nbtList;
    }

    public void readNbt(ListTag nbtList) {
        this.inventory.m_6211_();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("Slot") & 0xFF;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbtCompound);
            if (stack.m_41619_() || j >= 18) continue;
            this.inventory.m_6836_(j, stack);
        }
    }

    public void readNbtOld(ListTag nbtList) {
        this.inventory.m_6211_();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("Slot") & 0xFF;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbtCompound);
            if (stack.m_41619_() || 1 > j || j > 18) continue;
            this.inventory.m_6836_(j - 1, stack);
        }
    }

    public static Container getInvAndHands(final LittleMaidEntity maid) {
        final Container inv = maid.getInventory();
        return new Container(){

            public int m_6643_() {
                return 20;
            }

            public boolean m_7983_() {
                return inv.m_7983_() && maid.m_21205_().m_41619_() && maid.m_21206_().m_41619_();
            }

            public ItemStack m_8020_(int slot) {
                if (slot == 0) {
                    return maid.m_21205_();
                }
                if (slot == 1) {
                    return maid.m_21206_();
                }
                return inv.m_8020_(slot - 2);
            }

            public ItemStack m_7407_(int slot, int amount) {
                if (slot == 0) {
                    ItemStack itemStack = maid.m_21205_();
                    if (itemStack.m_41619_() || amount <= 0) {
                        return ItemStack.f_41583_;
                    }
                    if (!(itemStack = itemStack.m_41620_(amount)).m_41619_()) {
                        this.m_6596_();
                    }
                    return itemStack;
                }
                if (slot == 1) {
                    ItemStack itemStack = maid.m_21206_();
                    if (itemStack.m_41619_() || amount <= 0) {
                        return ItemStack.f_41583_;
                    }
                    if (!(itemStack = itemStack.m_41620_(amount)).m_41619_()) {
                        this.m_6596_();
                    }
                    return itemStack;
                }
                return inv.m_7407_(slot - 2, amount);
            }

            public ItemStack m_8016_(int slot) {
                if (slot == 0) {
                    ItemStack stack = maid.m_21205_();
                    if (stack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    maid.m_21008_(InteractionHand.MAIN_HAND, stack);
                    return stack;
                }
                if (slot == 1) {
                    ItemStack stack = maid.m_21206_();
                    if (stack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    maid.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                    return stack;
                }
                return inv.m_8016_(slot - 2);
            }

            public void m_6836_(int slot, ItemStack stack) {
                if (slot == 0) {
                    maid.m_21008_(InteractionHand.MAIN_HAND, stack);
                } else if (slot == 1) {
                    maid.m_21008_(InteractionHand.OFF_HAND, stack);
                } else {
                    inv.m_6836_(slot - 2, stack);
                }
            }

            public void m_6596_() {
                inv.m_6596_();
            }

            public boolean m_6542_(Player player) {
                return inv.m_6542_(player);
            }

            public void m_6211_() {
                inv.m_6211_();
            }
        };
    }
}

