/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.entity;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.sistr.littlemaidrebirth.entity.util.Contractable;
import net.sistr.littlemaidrebirth.entity.util.HasInventory;

public class ItemContractable<T extends LivingEntity>
implements Contractable {
    protected final T mob;
    protected final Supplier<Integer> maxConsumeInterval;
    protected final Supplier<Integer> maxUnpaidTimes;
    protected final Predicate<ItemStack> salaryItems;
    protected int consumeInterval;
    protected int unpaidTimes;
    protected boolean contract;
    protected boolean strike;

    public ItemContractable(T mob, Supplier<Integer> maxConsumeInterval, Supplier<Integer> maxUnpaidTimes, Predicate<ItemStack> salaryItems) {
        this.mob = mob;
        this.maxConsumeInterval = maxConsumeInterval;
        this.maxUnpaidTimes = maxUnpaidTimes;
        this.salaryItems = salaryItems;
    }

    public void tick() {
        if (this.mob.m_9236_().m_5776_() || !this.contract) {
            return;
        }
        ++this.consumeInterval;
        if ((this.mob.m_19879_() + ((LivingEntity)this.mob).f_19797_) % 20 != 0) {
            return;
        }
        this.intervalTick();
    }

    protected void intervalTick() {
        if (this.maxConsumeInterval.get() < this.consumeInterval) {
            this.consumeInterval = 0;
            ++this.unpaidTimes;
        }
        if (this.strike) {
            return;
        }
        this.nonStrikeIntervalTick();
    }

    protected void nonStrikeIntervalTick() {
        if (0 < this.unpaidTimes) {
            this.receiveSalary(((HasInventory)this.mob).getInventory());
            if (this.maxUnpaidTimes.get() < this.unpaidTimes) {
                this.strike = true;
                this.onStrike();
            }
        }
    }

    protected void onStrike() {
    }

    public boolean isSalary(ItemStack stack) {
        return !stack.m_41619_() && this.salaryItems.test(stack);
    }

    public void receiveSalary(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            while (0 < this.unpaidTimes && this.isSalary(stack)) {
                --this.unpaidTimes;
                stack.m_41774_(1);
                this.postReceive();
                if (!stack.m_41619_()) continue;
                inventory.m_8016_(i);
            }
        }
    }

    public int checkSalarySlots() {
        int count = 0;
        Container inv = ((HasInventory)this.mob).getInventory();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!this.isSalary(stack)) continue;
            ++count;
        }
        return count;
    }

    protected void postReceive() {
    }

    public void setUnpaidTimes(int unpaidTimes) {
        this.unpaidTimes = unpaidTimes;
    }

    public int getUnpaidTimes() {
        return this.unpaidTimes;
    }

    @Override
    public boolean isContract() {
        return this.contract;
    }

    @Override
    public void setContract(boolean isContract) {
        this.contract = isContract;
    }

    @Override
    public boolean isStrike() {
        return this.strike;
    }

    @Override
    public void setStrike(boolean strike) {
        this.strike = strike;
    }

    @Override
    public void writeContractable(CompoundTag nbt) {
        CompoundTag itemContractable = new CompoundTag();
        itemContractable.m_128379_("contract", this.contract);
        itemContractable.m_128379_("strike", this.strike);
        itemContractable.m_128405_("consumeInterval", this.consumeInterval);
        nbt.m_128365_("ItemContractable", (Tag)itemContractable);
    }

    @Override
    public void readContractable(CompoundTag nbt) {
        if (!nbt.m_128441_("ItemContractable")) {
            return;
        }
        CompoundTag itemContractable = nbt.m_128469_("ItemContractable");
        this.contract = itemContractable.m_128471_("contract");
        this.strike = itemContractable.m_128471_("strike");
        this.consumeInterval = itemContractable.m_128451_("consumeInterval");
    }
}

