/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.screen.ModelSelectScreen;
import net.sistr.littlemaidmodelloader.client.screen.SoundPackSelectScreen;
import net.sistr.littlemaidmodelloader.util.Tuple;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;
import net.sistr.littlemaidrebirth.entity.LittleMaidScreenHandler;
import net.sistr.littlemaidrebirth.entity.util.MovingMode;
import net.sistr.littlemaidrebirth.entity.util.TameableUtil;
import net.sistr.littlemaidrebirth.entity.util.TargetingSystem;
import net.sistr.littlemaidrebirth.network.C2SSetBloodSuckPacket;
import net.sistr.littlemaidrebirth.network.C2SSetMasterStancePacket;
import net.sistr.littlemaidrebirth.network.C2SSetMovingStatePacket;
import net.sistr.littlemaidrebirth.network.C2SSetWorkItemSlotSizePacket;
import net.sistr.littlemaidrebirth.network.OpenIFFScreenPacket;

@OnlyIn(value=Dist.CLIENT)
public class LittleMaidScreen
extends AbstractContainerScreen<LittleMaidScreenHandler> {
    private static final ResourceLocation GUI = new ResourceLocation("lmreengaged", "textures/gui/container/littlemaidinventory2.png");
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");
    private static final ItemStack ARMOR = Items.f_42408_.m_7968_();
    private static final ItemStack BOOK = Items.f_42517_.m_7968_();
    private static final ItemStack NOTE = Items.f_41859_.m_7968_();
    private static final ItemStack FEATHER = Items.f_42402_.m_7968_();
    private static final ItemStack IRON_SWORD = Items.f_42383_.m_7968_();
    private static final ItemStack IRON_AXE = Items.f_42386_.m_7968_();
    private static final ItemStack CHEST = Items.f_42009_.m_7968_();
    private static final ItemStack SHIELD = Items.f_42740_.m_7968_();
    private static final ItemStack SUPPORT = Items.f_42009_.m_7968_();
    private final LittleMaidEntity owner;
    private Component stateText;
    private final MovingMode prevMovingMode;
    private MovingMode movingMode;
    private int workItemSlotSize;
    private boolean isSettingWISS;

    public LittleMaidScreen(LittleMaidScreenHandler screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97727_ = 208;
        this.owner = screenContainer.getGuiEntity();
        this.workItemSlotSize = screenContainer.getWorkItemSlotSize();
        this.prevMovingMode = this.movingMode = this.owner.getMovingMode();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.owner == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        int left = (int)((float)(this.f_96543_ - this.f_97726_) / 2.0f) - 5;
        int right = (int)((float)(this.f_96543_ - this.f_97726_) / 2.0f) + this.f_97726_ + 5;
        int top = (int)((float)(this.f_96544_ - this.f_97727_) / 2.0f);
        int size = 20;
        int layer = -1;
        this.m_142416_((GuiEventListener)new IconButtonWidget(left - size, top + size * ++layer, BOOK, (Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.open_iff_setting"), button -> TameableUtil.getTameOwner((OwnableEntity)this.owner).ifPresent(OpenIFFScreenPacket::sendC2SPacket)));
        this.m_142416_((GuiEventListener)new IconButtonWidget(left - size, top + size * ++layer, NOTE, (Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.open_sound_pack_select"), button -> this.f_96541_.m_91152_((Screen)new SoundPackSelectScreen(this.f_96539_, (Entity)this.owner))));
        this.m_142416_((GuiEventListener)new IconButtonWidget(left - size, top + size * ++layer, ARMOR, (Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.open_model_select"), button -> this.f_96541_.m_91152_((Screen)new ModelSelectScreen(this.f_96539_, this.owner.m_9236_(), (Entity)this.owner))));
        this.m_142416_((GuiEventListener)new IconButtonWidget(left - size, top + size * ++layer, FEATHER, (Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.change_moving_mode"), button -> {
            if (this.owner.isStrike()) {
                return;
            }
            switch (this.movingMode) {
                case ESCORT: {
                    this.movingMode = MovingMode.FREEDOM;
                    break;
                }
                case FREEDOM: {
                    this.movingMode = MovingMode.TRACER;
                    break;
                }
                case TRACER: {
                    this.movingMode = MovingMode.ESCORT;
                }
            }
            this.stateText = this.getStateText();
        }));
        this.m_142416_((GuiEventListener)new IconButtonWidget(left - size, top + size * ++layer, FEATHER, (Component)Component.m_237119_(), button -> C2SSetBloodSuckPacket.sendC2SPacket((Entity)this.owner, !this.owner.isBloodSuck())){
            private static final Component changeBloodSuck = Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.change_blood_suck");
            private static final Component toBloodSuck = changeBloodSuck.m_6881_().m_7220_((Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.change_blood_suck.to_blood_suck"));
            private static final Component isBloodSuck = changeBloodSuck.m_6881_().m_7220_((Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.change_blood_suck.is_blood_suck"));

            @Override
            protected ItemStack getIconItem() {
                return LittleMaidScreen.this.owner.isBloodSuck() ? IRON_AXE : IRON_SWORD;
            }

            @Override
            protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
                super.m_87963_(context, mouseX, mouseY, delta);
                this.m_257544_(Tooltip.m_257550_((Component)(LittleMaidScreen.this.owner.isBloodSuck() ? isBloodSuck : toBloodSuck)));
            }
        });
        this.m_142416_((GuiEventListener)new IconButtonWidget(left - size * 2, top + size * layer, FEATHER, (Component)Component.m_237119_(), button -> C2SSetMasterStancePacket.sendC2SPacket((Entity)this.owner, this.owner.getMasterStance() == TargetingSystem.MasterStance.GUARD ? TargetingSystem.MasterStance.SUPPORT : TargetingSystem.MasterStance.GUARD)){
            private static final Component changeMasterStance = Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.change_master_stance");
            private static final Component isGuard = changeMasterStance.m_6881_().m_7220_((Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.change_master_stance.to_support"));
            private static final Component isSupport = changeMasterStance.m_6881_().m_7220_((Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.change_master_stance.is_guard"));

            @Override
            protected ItemStack getIconItem() {
                return LittleMaidScreen.this.owner.getMasterStance() == TargetingSystem.MasterStance.GUARD ? SHIELD : SUPPORT;
            }

            @Override
            protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
                super.m_87963_(context, mouseX, mouseY, delta);
                this.m_257544_(Tooltip.m_257550_((Component)(LittleMaidScreen.this.owner.getMasterStance() == TargetingSystem.MasterStance.GUARD ? isSupport : isGuard)));
            }
        });
        this.m_142416_((GuiEventListener)new IconButtonWidget(right, top + 75, CHEST, (Component)Component.m_237115_((String)"gui.littlemaidrebirth.littlemaid.tooltip.setting_work_item_slot"), button -> {
            this.isSettingWISS = true;
        }));
        this.stateText = this.getStateText();
    }

    public Component getStateText() {
        if (this.owner.isStrike()) {
            return Component.m_237115_((String)"state.littlemaidrebirth.Strike");
        }
        MutableComponent stateText = Component.m_237115_((String)("state.littlemaidrebirth." + this.movingMode.getName()));
        this.owner.getModeName().ifPresent(modeName -> stateText.m_130946_(" : ").m_7220_((Component)Component.m_237115_((String)("mode.littlemaidrebirth." + modeName))));
        return stateText;
    }

    public void m_181908_() {
        super.m_181908_();
        this.stateText = this.getStateText();
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(context, mouseX, mouseY, partialTicks);
        this.m_280072_(context, mouseX, mouseY);
        InventoryScreen.m_274545_((GuiGraphics)context, (int)((this.f_96543_ - this.f_97726_) / 2 + 52), (int)((this.f_96544_ - this.f_97727_) / 2 + 59), (int)20, (float)((float)(this.f_96543_ - this.f_97726_) / 2.0f + 52.0f - (float)mouseX), (float)((float)(this.f_96544_ - this.f_97727_) / 2.0f + 30.0f - (float)mouseY), (LivingEntity)this.owner);
        if (this.isSettingWISS) {
            this.renderWISSSetting(context, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isSettingWISS) {
            this.getMaidSlotPos(mouseX, mouseY).ifPresent(pos -> {
                this.workItemSlotSize = this.convSlotIndex((Integer)pos.getA(), (Integer)pos.getB());
                C2SSetWorkItemSlotSizePacket.sendC2SPacket(this.owner, this.workItemSlotSize);
            });
            this.isSettingWISS = false;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public Optional<Tuple<Integer, Integer>> getMaidSlotPos(double x, double y) {
        float left = (float)(this.f_96543_ - this.f_97726_) / 2.0f;
        float top = (float)(this.f_96544_ - this.f_97727_) / 2.0f;
        float baseLeft = left + 7.0f;
        float baseTop = top + 75.0f;
        int size = 18;
        int slotCol = 9;
        int slotRow = 2;
        if ((double)baseLeft <= x && x < (double)(baseLeft + (float)(size * slotCol)) && (double)baseTop <= y && y < (double)(baseTop + (float)(size * slotRow))) {
            int indexX = Mth.m_14107_((double)((x - (double)baseLeft) / (double)size));
            int indexY = Mth.m_14107_((double)((y - (double)baseTop) / (double)size));
            return Optional.of(new Tuple((Object)indexX, (Object)indexY));
        }
        return Optional.empty();
    }

    public int convSlotIndex(int x, int y) {
        return y * 9 + x;
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        RenderSystem.disableBlend();
        context.m_280056_(this.f_96547_, this.stateText.getString(), 8, 65, 0x404040, false);
        String insideSkirt = Component.m_237115_((String)"entity.littlemaidrebirth.little_maid_mob.InsideSkirt").getString();
        context.m_280056_(this.f_96547_, insideSkirt, 168 - this.f_96547_.m_92895_(insideSkirt), 65, 0x404040, false);
        float left = (float)(this.f_96543_ - this.f_97726_) / 2.0f;
        float top = (float)(this.f_96544_ - this.f_97727_) / 2.0f;
        if (left + 7.0f <= (float)mouseX && (float)mouseX < left + 96.0f && top + 7.0f <= (float)mouseY && (float)mouseY < top + 60.0f) {
            this.drawArmor(context);
        } else {
            this.drawHealth(context, mouseX, mouseY);
        }
    }

    protected void drawHealth(GuiGraphics context, int mouseX, int mouseY) {
        float left = (float)(this.f_96543_ - this.f_97726_) / 2.0f;
        float top = (float)(this.f_96544_ - this.f_97727_) / 2.0f;
        if (left + 98.0f <= (float)mouseX && (float)mouseX < left + 98.0f + 45.0f && top + 7.0f <= (float)mouseY && (float)mouseY < top + 7.0f + 18.0f) {
            String healthStr = Mth.m_14167_((float)this.owner.m_21223_()) + " / " + Mth.m_14167_((float)this.owner.m_21233_());
            int n = 98 + (int)((float)(45 - this.f_96547_.m_92895_(healthStr)) / 2.0f);
            Objects.requireNonNull(this.f_96547_);
            context.m_280056_(this.f_96547_, healthStr, n, 16 - (int)(9.0f / 2.0f), 0x404040, false);
        } else {
            float health = this.owner.m_21223_() / this.owner.m_21233_() * 20.0f;
            this.drawHealth(context, 98, 7, Mth.m_14036_((float)(health - 10.0f), (float)0.0f, (float)10.0f), 5);
            this.drawHealth(context, 98, 16, Mth.m_14036_((float)health, (float)0.0f, (float)10.0f), 5);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
    }

    protected void drawArmor(GuiGraphics context) {
        float armor = this.owner.m_21230_();
        this.drawArmor(context, 98, 7, Mth.m_14036_((float)(armor - 10.0f), (float)0.0f, (float)10.0f), 5);
        this.drawArmor(context, 98, 16, Mth.m_14036_((float)armor, (float)0.0f, (float)10.0f), 5);
    }

    protected void drawHealth(GuiGraphics context, int x, int y, float health, int rowHeart) {
        this.drawIcon(context, x, y, health, rowHeart, 16, 0, 52, 0, 61, 0);
    }

    protected void drawArmor(GuiGraphics context, int x, int y, float health, int rowHeart) {
        this.drawIcon(context, x, y, health, rowHeart, 16, 9, 34, 9, 25, 9);
    }

    protected void drawIcon(GuiGraphics context, int x, int y, float num, int row, int baseU, int baseV, int overU, int overV, int halfU, int halfV) {
        for (int i = 0; i < row; ++i) {
            context.m_280218_(ICONS, x + i * 9, y, baseU, baseV, 9, 9);
            if (1.0f < num) {
                context.m_280218_(ICONS, x + i * 9, y, overU, overV, 9, 9);
            } else if (0.0f < num) {
                context.m_280218_(ICONS, x + i * 9, y, halfU, halfV, 9, 9);
            }
            num -= 2.0f;
        }
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        context.m_280218_(GUI, relX, relY, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.isSettingWISS) {
            this.drawWorkItemSlotOverlay(context, this.workItemSlotSize);
        }
    }

    public void renderWISSSetting(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        int slotSize = 18;
        int top = relY + 75;
        int bottom = top + slotSize * 2;
        int left = relX + 7;
        int right = left + slotSize * 9;
        int color = Integer.MIN_VALUE;
        context.m_280509_(0, 0, this.f_96543_, top, color);
        context.m_280509_(0, top, left, bottom, color);
        context.m_280509_(right, top, this.f_96543_, bottom, color);
        context.m_280509_(0, bottom, this.f_96543_, this.f_96544_, color);
        Optional<Tuple<Integer, Integer>> optional = this.getMaidSlotPos(mouseX, mouseY);
        if (optional.isPresent()) {
            Tuple<Integer, Integer> pos = optional.get();
            int index = this.convSlotIndex((Integer)pos.getA(), (Integer)pos.getB());
            this.drawWorkItemSlotOverlay(context, index);
        } else {
            this.drawWorkItemSlotOverlay(context, this.workItemSlotSize);
        }
    }

    public void drawWorkItemSlotOverlay(GuiGraphics context, int num) {
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < num; ++i) {
            int slotSize = 18;
            int baseX = relX + 7;
            int baseY = relY + 75;
            int x = baseX + slotSize * (i % 9);
            int y = baseY + slotSize * (i / 9);
            context.m_280509_(x, y, x + slotSize, y + slotSize, 0x40FF4040);
        }
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.prevMovingMode != this.movingMode) {
            C2SSetMovingStatePacket.sendC2SPacket((Entity)this.owner, this.movingMode);
        }
    }

    public static class IconButtonWidget
    extends Button {
        public static final int DEFAULT_SIZE = 20;
        private final ItemStack iconItem;

        public IconButtonWidget(int x, int y, ItemStack iconItem, Component tooltip, Button.OnPress onPress) {
            this(x, y, 20, 20, (Component)Component.m_237119_(), onPress, Supplier::get, iconItem);
            this.m_257544_(Tooltip.m_257550_((Component)tooltip));
        }

        public IconButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration narrationSupplier, ItemStack iconItem) {
            super(x, y, width, height, message, onPress, narrationSupplier);
            this.iconItem = iconItem;
        }

        protected ItemStack getIconItem() {
            return this.iconItem;
        }

        protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.m_87963_(context, mouseX, mouseY, delta);
            context.m_280480_(this.getIconItem(), this.m_252754_() - 8 + this.f_93618_ / 2, this.m_252907_() - 8 + this.f_93619_ / 2);
        }
    }
}

