/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidrebirth.entity.LittleMaidEntity;

@OnlyIn(value=Dist.CLIENT)
public class LMHeadFeatureRenderer<T extends LittleMaidEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final Map<SkullBlock.Type, SkullModelBase> headModels;

    public LMHeadFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet loader) {
        this(context, loader, 1.0f, 1.0f, 1.0f);
    }

    public LMHeadFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet loader, float scaleX, float scaleY, float scaleZ) {
        super(context);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.headModels = SkullBlockRenderer.m_173661_((EntityModelSet)loader);
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, T livingEntity, float animationProgress, float g, float h, float j, float k, float l) {
        boolean showHeadItem;
        ItemStack lastStack = ((LittleMaidEntity)livingEntity).getInventory().m_8020_(17);
        Item lastItem = lastStack.m_41720_();
        boolean showLastItem = !lastStack.m_41619_() && lastItem instanceof BlockItem && ((BlockItem)lastItem).m_40614_() instanceof BushBlock;
        ItemStack itemStack = livingEntity.m_6844_(EquipmentSlot.HEAD);
        boolean bl = showHeadItem = !itemStack.m_41619_();
        if (!showLastItem && !showHeadItem) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85841_(this.scaleX, this.scaleY, this.scaleZ);
        ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(matrixStack);
        if (showLastItem) {
            matrixStack.m_85836_();
            LMHeadFeatureRenderer.translate(matrixStack, false);
            matrixStack.m_85837_(-0.5, 0.35, -0.5);
            Minecraft.m_91087_().m_91289_().m_110912_(((BlockItem)lastItem).m_40614_().m_49966_(), matrixStack, vertexConsumerProvider, light, OverlayTexture.f_118083_);
            matrixStack.m_85849_();
        }
        if (showHeadItem) {
            Item item = itemStack.m_41720_();
            if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock) {
                CompoundTag nbtCompound;
                matrixStack.m_85841_(1.1875f, -1.1875f, -1.1875f);
                GameProfile gameProfile = null;
                if (itemStack.m_41782_() && (nbtCompound = itemStack.m_41783_()).m_128425_("SkullOwner", 10)) {
                    gameProfile = NbtUtils.m_129228_((CompoundTag)nbtCompound.m_128469_("SkullOwner"));
                }
                matrixStack.m_85837_(-0.5, 0.0, -0.5);
                SkullBlock.Type skullType = ((AbstractSkullBlock)((BlockItem)item).m_40614_()).m_48754_();
                SkullModelBase skullBlockEntityModel = this.headModels.get(skullType);
                RenderType renderLayer = SkullBlockRenderer.m_112523_((SkullBlock.Type)skullType, (GameProfile)gameProfile);
                SkullBlockRenderer.m_173663_(null, (float)180.0f, (float)animationProgress, (PoseStack)matrixStack, (MultiBufferSource)vertexConsumerProvider, (int)light, (SkullModelBase)skullBlockEntityModel, (RenderType)renderLayer);
            } else if (!(item instanceof ArmorItem) || ((ArmorItem)item).m_40402_() != EquipmentSlot.HEAD) {
                LMHeadFeatureRenderer.translate(matrixStack, false);
                Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(livingEntity, itemStack, ItemDisplayContext.HEAD, false, matrixStack, vertexConsumerProvider, light);
            }
        }
        matrixStack.m_85849_();
    }

    public static void translate(PoseStack matrices, boolean villager) {
        matrices.m_85837_(0.0, -0.25, 0.0);
        matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrices.m_85841_(0.625f, -0.625f, -0.625f);
        if (villager) {
            matrices.m_85837_(0.0, 0.1875, 0.0);
        }
    }
}

