/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.ListGUI;
import net.sistr.littlemaidmodelloader.client.screen.ListGUIElement;
import net.sistr.littlemaidmodelloader.client.screen.MarginedClickable;
import net.sistr.littlemaidmodelloader.client.screen.ScrollBar;
import net.sistr.littlemaidmodelloader.client.screen.TextureAddress;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.iff.IFF;
import net.sistr.littlemaidrebirth.entity.iff.IFFTag;
import net.sistr.littlemaidrebirth.network.C2SSetIFFPacket;

@OnlyIn(value=Dist.CLIENT)
public class IFFScreen
extends Screen {
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 196;
    public static final ResourceLocation MODEL_SELECT_GUI_TEXTURE = new ResourceLocation("littlemaidmodelloader", "textures/gui/model_select.png");
    private final Entity entity;
    private final ImmutableList<IFF> iffs;
    private ScrollBar scrollBar;
    private ListGUI<IFFGUIElement> iffGui;

    public IFFScreen(Entity entity, List<IFF> iffs) {
        super((Component)Component.m_237119_());
        this.entity = entity;
        this.iffs = ImmutableList.copyOf(iffs);
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        int scale = 15;
        int widthRatio = 16;
        int heightRatio = 3;
        int heightStack = 4;
        int x = (this.f_96543_ - scale * widthRatio) / 2;
        int y = (this.f_96544_ - scale * heightRatio * heightStack) / 2;
        this.iffGui = new ListGUI(x, y, 1, heightStack, scale * widthRatio, scale * heightRatio, (Collection)this.iffs.stream().map(IFFGUIElement::new).collect(Collectors.toList()));
        this.scrollBar = new ScrollBar((this.f_96543_ + 256) / 2 + 4, (this.f_96544_ - 196) / 2, 8, 196, this.iffGui.size(), new TextureAddress(0, 200, 8, 8, 256, 256), new TextureAddress(0, 208, 8, 8, 256, 256), new TextureAddress(0, 216, 8, 8, 256, 256), new TextureAddress(0, 224, 10, 6, 256, 256), MODEL_SELECT_GUI_TEXTURE);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        assert (this.f_96541_ != null);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MODEL_SELECT_GUI_TEXTURE);
        int relX = (this.f_96543_ - 256) / 2;
        int relY = (this.f_96544_ - 196) / 2;
        context.m_280218_(MODEL_SELECT_GUI_TEXTURE, relX, relY, 0, 0, 256, 196);
        this.iffGui.m_88315_(context, mouseX, mouseY, delta);
        this.scrollBar.m_88315_(context, mouseX, mouseY, delta);
    }

    public void m_86600_() {
        super.m_86600_();
    }

    public void m_280273_(GuiGraphics context) {
        super.m_280273_(context);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrollBar.m_6375_(mouseX, mouseY, button)) {
            this.iffGui.setScroll(this.scrollBar.getPoint());
            return true;
        }
        return this.iffGui.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            this.iffGui.setScroll(this.scrollBar.getPoint());
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollBar.m_6348_(mouseX, mouseY, button);
        return this.iffGui.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.scrollBar.m_6050_(mouseX, mouseY, amount)) {
            this.iffGui.setScroll(this.scrollBar.getPoint());
            return true;
        }
        if (this.iffGui.m_6050_(mouseX, mouseY, amount)) {
            this.scrollBar.setPoint(this.iffGui.getScroll());
            return true;
        }
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        C2SSetIFFPacket.sendC2SPacket(this.entity, this.iffs);
    }

    public static class IFFGUIElement
    extends GUIElement
    implements ListGUIElement {
        private final IFF iff;
        private final MarginedClickable clickable = new MarginedClickable(4);
        private boolean renderClashed;

        public IFFGUIElement(IFF iff) {
            super(240, 45);
            this.iff = iff;
        }

        public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.iff.getIFFType().getTargetEntityExample().ifPresent(entity -> {
                EntityType entityType = entity.m_6095_();
                if (this.renderClashed) {
                    return;
                }
                try {
                    InventoryScreen.m_274545_((GuiGraphics)context, (int)(this.x + 180 + 7), (int)(this.y + 45), (int)15, (float)((float)(this.x + 180) + 7.5f - (float)mouseX), (float)((float)(this.y + 45 - mouseY) - entity.m_20236_(Pose.STANDING) * 15.0f), (LivingEntity)entity);
                }
                catch (Exception e) {
                    LMRBMod.LOGGER.warn("\u63cf\u753b\u51e6\u7406\u304c\u30af\u30e9\u30c3\u30b7\u30e5\u3057\u307e\u3057\u305f\u3002" + String.valueOf(entityType) + ":" + String.valueOf(entity));
                    e.printStackTrace();
                    this.renderClashed = true;
                    context.m_280262_();
                    EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
                    entityRenderDispatcher.m_114468_(true);
                    context.m_280168_().m_85849_();
                    Lighting.m_84931_();
                }
            });
            Font textRenderer = Minecraft.m_91087_().f_91062_;
            context.m_280614_(textRenderer, (Component)Component.m_237115_((String)this.iff.getEntityType().m_20675_()), this.x, this.y, -1, true);
            int color = switch (this.iff.getIFFTag()) {
                case IFFTag.FRIEND -> -12517568;
                case IFFTag.ENEMY -> -49088;
                default -> -192;
            };
            String string = this.iff.getIFFTag().getName();
            Objects.requireNonNull(textRenderer);
            context.m_280056_(textRenderer, string, this.x, this.y + 9 * 2, color, true);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.clickable.click(mouseX, mouseY);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            if (button == 0 && this.clickable.release(mouseX, mouseY)) {
                IFFTag tag = this.iff.getIFFTag();
                switch (tag) {
                    case ENEMY: {
                        this.iff.setTag(IFFTag.FRIEND);
                        break;
                    }
                    case FRIEND: {
                        this.iff.setTag(IFFTag.UNKNOWN);
                        break;
                    }
                    default: {
                        this.iff.setTag(IFFTag.ENEMY);
                    }
                }
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
            return super.m_6348_(mouseX, mouseY, button);
        }

        public void setSelected(boolean b) {
        }

        public boolean isSelected() {
            return false;
        }
    }
}

