/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidrebirth.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sistr.littlemaidrebirth.LMRBMod;
import net.sistr.littlemaidrebirth.entity.util.SalaryBoxPosListener;
import net.sistr.littlemaidrebirth.setup.Registration;
import net.sistr.littlemaidrebirth.tags.LMTags;

public class SalaryBoxBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void m_142292_(Level world, BlockPos pos, BlockState state) {
            SalaryBoxBlockEntity.this.playSound(state, SoundEvents.f_11725_);
            SalaryBoxBlockEntity.this.setOpen(state, true);
        }

        protected void m_142289_(Level world, BlockPos pos, BlockState state) {
            SalaryBoxBlockEntity.this.playSound(state, SoundEvents.f_11724_);
            SalaryBoxBlockEntity.this.setOpen(state, false);
        }

        protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof ChestMenu) {
                Container inventory = ((ChestMenu)player.f_36096_).m_39261_();
                return inventory == SalaryBoxBlockEntity.this;
            }
            return false;
        }
    };

    public SalaryBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.SALARY_BOX_BLOCK_ENTITY.get(), pos, state);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.littlemaidrebirth.salary_box");
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return ChestMenu.m_39237_((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void tick() {
        if (!this.f_58859_) {
            this.stateManager.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void setOpen(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static boolean isinNotifyRange(Vec3i boxPos, Vec3 entityPos) {
        return boxPos.m_203193_((Position)entityPos) < (double)(SalaryBoxBlockEntity.getConfigNotifyRange() * SalaryBoxBlockEntity.getConfigNotifyRange());
    }

    public static void tick(Level world, BlockPos pos, BlockState state, SalaryBoxBlockEntity blockEntity) {
        if (!blockEntity.hasSalary()) {
            return;
        }
        if (world.m_213780_().m_188501_() > 1.0f / (float)SalaryBoxBlockEntity.getConfigInterval()) {
            return;
        }
        Vec3 centerPos = pos.m_252807_();
        float range = SalaryBoxBlockEntity.getConfigNotifyRange();
        AABB box = new AABB(centerPos.f_82479_ - (double)range, centerPos.f_82480_ - (double)range, centerPos.f_82481_ - (double)range, centerPos.f_82479_ + (double)range, centerPos.f_82480_ + (double)range, centerPos.f_82481_ + (double)range);
        List entityList = world.m_6443_(Entity.class, box, e -> e instanceof SalaryBoxPosListener && SalaryBoxBlockEntity.isinNotifyRange((Vec3i)pos, e.m_20182_()));
        for (Entity entity : entityList) {
            ((SalaryBoxPosListener)entity).listenSalaryBoxPos(pos);
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return stack.m_204117_(LMTags.Items.MAIDS_SALARY);
    }

    public boolean hasSalary() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_() || !stack.m_204117_(LMTags.Items.MAIDS_SALARY)) continue;
            return true;
        }
        return false;
    }

    private static float getConfigNotifyRange() {
        return LMRBMod.getConfig().contract.memorySalaryBoxDistance;
    }

    private static int getConfigInterval() {
        return LMRBMod.getConfig().contract.memorySalaryBoxInterval;
    }
}

