/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.rei.squeezer;

import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.compress.utils.Lists;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.rei.squeezer.ReiSqueezerCategory;

public class ReiSqueezerRecipe
implements Display {
    private final RecipeSqueezer recipe;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;

    public ReiSqueezerRecipe(RecipeSqueezer recipe) {
        this.recipe = recipe;
        this.inputs = Lists.newArrayList();
        this.outputs = Lists.newArrayList();
        this.inputs.add(EntryIngredients.ofIngredient((Ingredient)recipe.getInputIngredient()));
        for (RecipeSqueezer.IngredientChance outputItem : recipe.getOutputItems()) {
            if (outputItem.getChance() != 1.0f) continue;
            this.outputs.add(EntryIngredients.of((ItemStack)outputItem.getIngredientFirst()));
        }
        this.outputs.add(EntryIngredients.of((Fluid)recipe.getOutputFluid().getFluid(), (long)recipe.getOutputFluid().getAmount()));
    }

    public RecipeSqueezer getRecipe() {
        return this.recipe;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiSqueezerCategory.ID;
    }
}

