/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils.text;

import java.util.ArrayList;
import moze_intel.projecte.utils.text.IHasTextComponent;
import moze_intel.projecte.utils.text.IHasTranslationKey;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TextComponentUtil {
    private TextComponentUtil() {
    }

    public static MutableComponent build(Object ... components) {
        MutableComponent result = null;
        Style cachedStyle = Style.f_131099_;
        for (Object component : components) {
            if (component == null) continue;
            MutableComponent current = null;
            if (component instanceof IHasTextComponent) {
                IHasTextComponent hasTextComponent = (IHasTextComponent)component;
                current = hasTextComponent.getTextComponent().m_6881_();
            } else if (component instanceof IHasTranslationKey) {
                IHasTranslationKey hasTranslationKey = (IHasTranslationKey)component;
                current = TextComponentUtil.translate(hasTranslationKey.getTranslationKey(), new Object[0]);
            } else if (component instanceof Component) {
                Component c = (Component)component;
                current = c.m_6881_();
            } else if (component instanceof ChatFormatting) {
                cachedStyle = cachedStyle.m_131157_((ChatFormatting)component);
            } else if (component instanceof ClickEvent) {
                cachedStyle = cachedStyle.m_131142_((ClickEvent)component);
            } else if (component instanceof HoverEvent) {
                cachedStyle = cachedStyle.m_131144_((HoverEvent)component);
            } else if (component instanceof Block) {
                Block block = (Block)component;
                current = TextComponentUtil.translate(block.m_7705_(), new Object[0]);
            } else if (component instanceof Item) {
                Item item = (Item)component;
                current = TextComponentUtil.translate(item.m_5524_(), new Object[0]);
            } else if (component instanceof ItemStack) {
                ItemStack stack = (ItemStack)component;
                current = stack.m_41786_().m_6881_();
            } else if (component instanceof FluidStack) {
                FluidStack stack = (FluidStack)component;
                current = stack.getDisplayName().m_6881_();
            } else if (component instanceof Fluid) {
                Fluid fluid = (Fluid)component;
                current = TextComponentUtil.translate(fluid.getFluidType().getDescriptionId(), new Object[0]);
            } else {
                current = TextComponentUtil.getString(component.toString());
            }
            if (current == null) continue;
            if (!cachedStyle.m_131179_()) {
                current.m_6270_(cachedStyle);
                cachedStyle = Style.f_131099_;
            }
            if (result == null) {
                result = current;
                continue;
            }
            result.m_7220_((Component)current);
        }
        return result;
    }

    public static MutableComponent getString(String component) {
        return Component.m_237113_((String)TextComponentUtil.cleanString(component));
    }

    private static String cleanString(String component) {
        return component.replace("\u00a0", " ");
    }

    public static MutableComponent translate(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static MutableComponent smartTranslate(String key, Object ... components) {
        if (components.length == 0) {
            return TextComponentUtil.translate(key, new Object[0]);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Style cachedStyle = Style.f_131099_;
        for (Object component : components) {
            if (component == null) {
                args.add(null);
                cachedStyle = Style.f_131099_;
                continue;
            }
            MutableComponent current = null;
            if (component instanceof IHasTextComponent) {
                IHasTextComponent hasTextComponent = (IHasTextComponent)component;
                current = hasTextComponent.getTextComponent().m_6881_();
            } else if (component instanceof IHasTranslationKey) {
                IHasTranslationKey hasTranslationKey = (IHasTranslationKey)component;
                current = TextComponentUtil.translate(hasTranslationKey.getTranslationKey(), new Object[0]);
            } else if (component instanceof Block) {
                Block block = (Block)component;
                current = TextComponentUtil.translate(block.m_7705_(), new Object[0]);
            } else if (component instanceof Item) {
                Item item = (Item)component;
                current = TextComponentUtil.translate(item.m_5524_(), new Object[0]);
            } else if (component instanceof ItemStack) {
                ItemStack stack = (ItemStack)component;
                current = stack.m_41786_().m_6881_();
            } else if (component instanceof FluidStack) {
                FluidStack stack = (FluidStack)component;
                current = stack.getDisplayName().m_6881_();
            } else if (component instanceof Fluid) {
                Fluid fluid = (Fluid)component;
                current = TextComponentUtil.translate(fluid.getFluidType().getDescriptionId(), new Object[0]);
            } else {
                ChatFormatting formatting;
                if (component instanceof ChatFormatting && !TextComponentUtil.hasStyleType(cachedStyle, formatting = (ChatFormatting)component)) {
                    cachedStyle = cachedStyle.m_131157_(formatting);
                    continue;
                }
                if (component instanceof ClickEvent && cachedStyle.m_131182_() == null) {
                    cachedStyle = cachedStyle.m_131142_((ClickEvent)component);
                    continue;
                }
                if (component instanceof HoverEvent && cachedStyle.m_131186_() == null) {
                    cachedStyle = cachedStyle.m_131144_((HoverEvent)component);
                    continue;
                }
                if (!cachedStyle.m_131179_()) {
                    if (component instanceof Component) {
                        Component c = (Component)component;
                        current = c.m_6881_();
                    } else {
                        current = TextComponentUtil.getString(component.toString());
                    }
                } else if (component instanceof String) {
                    component = TextComponentUtil.cleanString((String)component);
                }
            }
            if (!cachedStyle.m_131179_()) {
                if (current == null) {
                    args.add(component);
                } else {
                    args.add(current.m_6270_(cachedStyle));
                }
                cachedStyle = Style.f_131099_;
                continue;
            }
            if (current == null) {
                args.add(component);
                continue;
            }
            args.add(current);
        }
        if (!cachedStyle.m_131179_()) {
            args.add(components[components.length - 1]);
        }
        return TextComponentUtil.translate(key, args.toArray());
    }

    private static boolean hasStyleType(Style current, ChatFormatting formatting) {
        return switch (formatting) {
            case ChatFormatting.OBFUSCATED -> current.m_131176_();
            case ChatFormatting.BOLD -> current.m_131154_();
            case ChatFormatting.STRIKETHROUGH -> current.m_131168_();
            case ChatFormatting.UNDERLINE -> current.m_131171_();
            case ChatFormatting.ITALIC -> current.m_131161_();
            case ChatFormatting.RESET -> current.m_131179_();
            default -> current.m_131135_() != null;
        };
    }
}

