/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.items.armor.PEArmor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public abstract class GemArmorBase
extends PEArmor {
    public GemArmorBase(ArmorItem.Type armorType, Item.Properties props) {
        super(GemArmorMaterial.INSTANCE, armorType, props);
    }

    @Override
    public float getFullSetBaseReduction() {
        return 0.9f;
    }

    @Override
    public float getMaxDamageAbsorb(ArmorItem.Type type, DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            return 750.0f;
        }
        if (type == ArmorItem.Type.BOOTS && source.m_269533_(DamageTypeTags.f_268549_)) {
            return 15.0f / this.getPieceEffectiveness(type);
        }
        if (type == ArmorItem.Type.HELMET && source.m_269533_(DamageTypeTags.f_268581_)) {
            return 15.0f / this.getPieceEffectiveness(type);
        }
        if (source.m_269533_(DamageTypeTags.f_268490_)) {
            return 0.0f;
        }
        if (type == ArmorItem.Type.HELMET || type == ArmorItem.Type.BOOTS) {
            return 400.0f;
        }
        return 500.0f;
    }

    public static boolean hasAnyPiece(Player player) {
        return player.m_150109_().f_35975_.stream().anyMatch(i -> !i.m_41619_() && i.m_41720_() instanceof GemArmorBase);
    }

    public static boolean hasFullSet(Player player) {
        return player.m_150109_().f_35975_.stream().noneMatch(i -> i.m_41619_() || !(i.m_41720_() instanceof GemArmorBase));
    }

    private static class GemArmorMaterial
    implements ArmorMaterial {
        private static final GemArmorMaterial INSTANCE = new GemArmorMaterial();

        private GemArmorMaterial() {
        }

        public int m_266425_(@NotNull ArmorItem.Type type) {
            return 0;
        }

        public int m_7366_(@NotNull ArmorItem.Type type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.BOOTS -> 3;
                case ArmorItem.Type.LEGGINGS -> 6;
                case ArmorItem.Type.CHESTPLATE -> 8;
                case ArmorItem.Type.HELMET -> 3;
            };
        }

        public int m_6646_() {
            return 0;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11673_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        @NotNull
        public String m_6082_() {
            return PECore.rl("gem_armor").toString();
        }

        public float m_6651_() {
            return 2.0f;
        }

        public float m_6649_() {
            return 0.25f;
        }
    }
}

