/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.nbt.processor;

import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NBTProcessor
public class DecoratedPotProcessor
implements INBTProcessor {
    @Override
    public String getName() {
        return "DecoratedPotProcessor";
    }

    @Override
    public String getDescription() {
        return "Takes the different sherds into account for each decorated pot.";
    }

    @Override
    public boolean hasPersistentNBT() {
        return true;
    }

    @Override
    public long recalculateEMC(@NotNull ItemInfo info, long currentEMC) throws ArithmeticException {
        CompoundTag beTag;
        DecoratedPotBlockEntity.Decorations decorations;
        CompoundTag tag;
        if (info.getItem() == Items.f_271478_ && (tag = info.getNBT()) != null && tag.m_128425_("BlockEntityTag", 10) && !(decorations = DecoratedPotBlockEntity.Decorations.m_284207_((CompoundTag)(beTag = tag.m_128469_("BlockEntityTag")))).equals((Object)DecoratedPotBlockEntity.Decorations.f_283770_)) {
            long decorationEmc = decorations.m_284195_().mapToLong(EMCHelper::getEmcValue).reduce(0L, Math::addExact);
            return Math.addExact(currentEMC - EMCHelper.getEmcValue((ItemLike)Items.f_271478_), decorationEmc);
        }
        return currentEMC;
    }

    @Override
    @Nullable
    public CompoundTag getPersistentNBT(@NotNull ItemInfo info) {
        CompoundTag beTag;
        CompoundTag tag;
        if (info.getItem() == Items.f_271478_ && (tag = info.getNBT()) != null && tag.m_128425_("BlockEntityTag", 10) && (beTag = tag.m_128469_("BlockEntityTag")).m_128425_("sherds", 9)) {
            CompoundTag toReturnIntermediary = new CompoundTag();
            toReturnIntermediary.m_128365_("sherds", (Tag)beTag.m_128437_("sherds", 8));
            CompoundTag toReturn = new CompoundTag();
            toReturn.m_128365_("BlockEntityTag", (Tag)toReturnIntermediary);
            return toReturn;
        }
        return null;
    }
}

