/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetPlayerLookTarget<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_26367_, (Object)MemoryStatus.VALUE_PRESENT)});
    protected BiPredicate<E, Player> lookPredicate = this::defaultPredicate;
    protected Predicate<Player> predicate = pl -> true;
    protected Player target = null;

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetPlayerLookTarget<E> lookPredicate(BiPredicate<E, Player> predicate) {
        this.lookPredicate = predicate;
        return this;
    }

    @Deprecated
    public SetPlayerLookTarget<E> predicate(Predicate<Player> predicate) {
        return this.lookPredicate((entity, player) -> predicate.test((Player)player));
    }

    @Override
    protected boolean m_6114_(ServerLevel level, E entity) {
        for (Player player : (List)BrainUtils.getMemory(entity, MemoryModuleType.f_26367_)) {
            if (!this.predicate.test(player) || !this.lookPredicate.test(entity, player)) continue;
            this.target = player;
            break;
        }
        return this.target != null;
    }

    protected boolean defaultPredicate(E entity, Player player) {
        Mob mob;
        if (entity.m_20363_((Entity)player)) {
            return false;
        }
        if (entity instanceof Mob ? !(mob = (Mob)entity).m_21574_().m_148306_((Entity)player) : !entity.m_142582_((Entity)player)) {
            return false;
        }
        double visibleDistance = Math.max(player.m_20968_(entity) * 16.0, 2.0);
        return entity.m_20280_((Entity)player) <= visibleDistance * visibleDistance;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.f_26371_, new EntityTracker((Entity)this.target, true));
    }

    @Override
    protected void stop(E entity) {
        this.target = null;
    }
}

