/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.modules;

import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModuleGrid
extends com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid {
    private final TileChaosHolderBase tile;

    public ModuleGrid(ModuleHostContainer container, Inventory player, TileChaosHolderBase tile) {
        super(container, player);
        this.tile = tile;
    }

    public InstallResult cellClicked(ModuleGrid.GridPos pos, double x, double y, int button, ClickType clickType) {
        ItemStack stack = this.player.f_35978_.f_36096_.m_142621_();
        Module module = ModuleItem.getModule((ItemStack)stack);
        boolean holdingStack = !stack.m_41619_();
        ModuleContext context = this.container.getModuleContext();
        if (holdingStack && module == null || !pos.isValidCell()) {
            return null;
        }
        if (clickType == ClickType.PICKUP) {
            if (holdingStack) {
                ModuleEntity entity = module.createEntity();
                entity.setPos(pos.getGridX(), pos.getGridY());
                InstallResult result = this.checkInstall(entity);
                if (result.resultType == InstallResult.InstallResultType.YES) {
                    entity.readFromItemStack(stack, context);
                    this.getModuleHost().addModule(entity, context);
                    stack.m_41774_(1);
                    this.onGridChange();
                    return null;
                }
                return result;
            }
            if (pos.hasEntity()) {
                ModuleEntity entity = pos.getEntity();
                if (!this.tile.canRemoveModule(entity)) {
                    return null;
                }
                ItemStack extracted = new ItemStack((ItemLike)entity.getModule().getItem());
                entity.writeToItemStack(extracted, context);
                this.getModuleHost().removeModule(entity, context);
                this.player.f_35978_.f_36096_.m_142503_(extracted);
                this.onGridChange();
            }
        } else if (clickType == ClickType.QUICK_MOVE) {
            if (pos.hasEntity()) {
                ModuleEntity entity = pos.getEntity();
                if (!this.tile.canRemoveModule(entity)) {
                    return null;
                }
                ItemStack extracted = new ItemStack((ItemLike)entity.getModule().getItem());
                entity.writeToItemStack(extracted, context);
                if (this.player.m_36054_(extracted)) {
                    this.getModuleHost().removeModule(entity, context);
                    this.onGridChange();
                }
            }
        } else if (clickType == ClickType.PICKUP_ALL && module != null) {
            for (ModuleEntity entity : ImmutableList.copyOf((Collection)this.getModuleHost().getModuleEntities())) {
                if (entity.getModule() == module && this.tile.canRemoveModule(entity)) {
                    ItemStack modStack = new ItemStack((ItemLike)module.getItem());
                    entity.writeToItemStack(modStack, context);
                    if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)modStack) && stack.m_41613_() < stack.m_41741_()) {
                        stack.m_41769_(1);
                        this.getModuleHost().removeModule(entity, context);
                    }
                }
                this.onGridChange();
            }
        } else if (clickType == ClickType.CLONE && this.player.f_35978_.m_150110_().f_35937_ && this.player.f_35978_.f_36095_.m_142621_().m_41619_() && pos.hasEntity()) {
            ModuleEntity entity = pos.getEntity();
            ItemStack modStack = new ItemStack((ItemLike)entity.getModule().getItem());
            entity.writeToItemStack(modStack, context);
            this.player.f_35978_.f_36096_.m_142503_(modStack);
        }
        return null;
    }
}

