/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.datagen;

import codechicken.lib.datagen.recipe.FurnaceRecipeBuilder;
import codechicken.lib.datagen.recipe.RecipeBuilder;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.lib.datagen.recipe.ShapedRecipeBuilder;
import codechicken.lib.datagen.recipe.ShapelessRecipeBuilder;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.datagen.FusionRecipeBuilder;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.DETags;
import java.util.function.Function;
import java.util.function.Supplier;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.foxmcloud.draconicadditions.lib.DAModules;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(PackOutput pOutput) {
        super(pOutput, "draconicadditions");
    }

    protected void registerRecipes() {
        this.blocks();
        this.items();
        this.modules();
    }

    private void blocks() {
        if (DAContent.chaosLiquifier != null) {
            this.fusionRecipe((Supplier<? extends ItemLike>)DAContent.itemChaosLiquifier, "blocks").catalyst(new ItemLike[]{(ItemLike)DEContent.CRAFTING_CORE.get()}).energy(2500000L).techLevel(TechLevel.CHAOTIC).ingredient(DAContent.chaosContainer);
        }
        if (DAContent.chaosInfuser != null) {
            this.fusionRecipe((Supplier<? extends ItemLike>)DAContent.itemChaosInfuser, "blocks").catalyst(new ItemLike[]{(ItemLike)DEContent.ENERGY_TRANSFUSER.get()}).energy(2000000L).techLevel(TechLevel.CHAOTIC).ingredient(DAContent.chaosContainer);
        }
        if (DAContent.chaosExtractor != null) {
            this.fusionRecipe((Supplier<? extends ItemLike>)DAContent.itemChaosExtractor, "blocks").catalyst(DAContent.itemChaosInfuser).energy(100000L).techLevel(TechLevel.CHAOTIC).ingredient(new ItemLike[]{(ItemLike)DEContent.ENERGY_TRANSFUSER.get()});
        }
        if (DAContent.chaosCrystalizer != null) {
            this.fusionRecipe((Supplier<? extends ItemLike>)DAContent.itemChaosCrystalizer, "blocks").catalyst(DAContent.itemChaosLiquifier).energy(100000L).techLevel(TechLevel.CHAOTIC).ingredient(new ItemLike[]{(ItemLike)DEContent.ENERGY_TRANSFUSER.get()});
        }
    }

    private void items() {
        if (DAContent.inertPotatoHelm != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.inertPotatoHelm, "items").patternLine("PBP").patternLine("P P").key('P', (ItemLike)Items.f_42620_).key('B', (ItemLike)Items.f_42675_);
        }
        if (DAContent.inertPotatoChest != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.inertPotatoChest, "items").patternLine("P P").patternLine("PBP").patternLine("PPP").key('P', (ItemLike)Items.f_42620_).key('B', (ItemLike)Items.f_42675_);
        }
        if (DAContent.inertPotatoLegs != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.inertPotatoLegs, "items").patternLine("PBP").patternLine("P P").patternLine("P P").key('P', (ItemLike)Items.f_42620_).key('B', (ItemLike)Items.f_42675_);
        }
        if (DAContent.inertPotatoBoots != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.inertPotatoBoots, "items").patternLine("P P").patternLine("P P").key('P', (ItemLike)Items.f_42620_);
        }
        if (DAContent.infusedPotatoHelm != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.infusedPotatoHelm, "items").patternLine("DRD").patternLine("RIR").patternLine("DRD").key('D', DETags.Items.INGOTS_DRACONIUM).key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE).key('I', DAContent.inertPotatoHelm);
        }
        if (DAContent.infusedPotatoChest != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.infusedPotatoChest, "items").patternLine("DRD").patternLine("RIR").patternLine("DRD").key('D', DETags.Items.INGOTS_DRACONIUM).key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE).key('I', DAContent.inertPotatoChest);
        }
        if (DAContent.infusedPotatoLegs != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.infusedPotatoLegs, "items").patternLine("DRD").patternLine("RIR").patternLine("DRD").key('D', DETags.Items.INGOTS_DRACONIUM).key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE).key('I', DAContent.inertPotatoLegs);
        }
        if (DAContent.infusedPotatoBoots != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.infusedPotatoBoots, "items").patternLine("DRD").patternLine("RIR").patternLine("DRD").key('D', DETags.Items.INGOTS_DRACONIUM).key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE).key('I', DAContent.inertPotatoBoots);
        }
        if (DAContent.chaosContainer != null) {
            this.fusionRecipe((Supplier<? extends ItemLike>)DAContent.chaosContainer, "items").catalyst(new ItemLike[]{Items.f_42446_}).energy(250000L).techLevel(TechLevel.DRACONIC).ingredient(new ItemLike[]{(ItemLike)DEContent.INFUSED_OBSIDIAN.get()}).ingredient(new ItemLike[]{(ItemLike)DEContent.INFUSED_OBSIDIAN.get()}).ingredient(new ItemLike[]{(ItemLike)DEContent.ENERGY_CORE_WYVERN.get()}).ingredient(new ItemLike[]{(ItemLike)DEContent.DISLOCATOR.get()});
        }
        if (DAContent.necklaceWyvern != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.necklaceWyvern, "items").patternLine("GGG").patternLine("G G").patternLine(" C ").key('G', Tags.Items.INGOTS_GOLD).key('C', (ItemLike)DEContent.CORE_WYVERN.get());
        }
        if (DAContent.necklaceDraconic != null) {
            this.shapelessRecipe((Supplier)DAContent.necklaceDraconic).addIngredient(DAContent.necklaceWyvern).addIngredient((ItemLike)DEContent.CORE_AWAKENED.get());
        }
        if (DAContent.necklaceChaotic != null) {
            this.shapelessRecipe((Supplier)DAContent.necklaceChaotic).addIngredient(DAContent.necklaceDraconic).addIngredient((ItemLike)DEContent.CORE_CHAOTIC.get());
        }
        if (DAContent.harnessWyvern != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.harnessWyvern, "items").patternLine("DDD").patternLine("DLD").patternLine("DSD").key('D', DETags.Items.INGOTS_DRACONIUM).key('L', (ItemLike)DEContent.DISLOCATOR.get()).key('S', (ItemLike)((Module)DEModules.WYVERN_SHIELD_CONTROL.get()).getItem());
        }
        if (DAContent.harnessDraconic != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.harnessDraconic, "items").patternLine("AAA").patternLine("AHA").patternLine("ASA").key('A', DETags.Items.INGOTS_DRACONIUM_AWAKENED).key('H', DAContent.harnessWyvern).key('S', (ItemLike)((Module)DEModules.DRACONIC_SHIELD_CONTROL.get()).getItem());
        }
        if (DAContent.harnessChaotic != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.harnessChaotic, "items").patternLine("CCC").patternLine("CHC").patternLine("CSC").key('C', (ItemLike)DEContent.CHAOS_FRAG_MEDIUM.get()).key('H', DAContent.harnessDraconic).key('S', (ItemLike)((Module)DEModules.CHAOTIC_SHIELD_CONTROL.get()).getItem());
        }
        if (DAContent.hermal != null) {
            this.shapedRecipe((Supplier<? extends ItemLike>)DAContent.hermal, "items").patternLine("CCC").patternLine("CPC").patternLine("CCC").key('C', (ItemLike)DEContent.CHAOS_FRAG_MEDIUM.get()).key('P', (ItemLike)Items.f_42675_);
        }
    }

    private void modules() {
        if (DAModules.chaoticAutoFeed != null) {
            this.shapedRecipe((ItemLike)((Module)DAModules.chaoticAutoFeed.get()).getItem(), "modules").patternLine("FCF").patternLine("DAD").patternLine("FCF").key('F', (ItemLike)DEContent.CHAOS_FRAG_MEDIUM.get()).key('D', (ItemLike)DEContent.CORE_DRACONIUM.get()).key('A', (ItemLike)((Module)DEModules.DRACONIC_AUTO_FEED.get()).getItem()).key('C', (ItemLike)Items.f_42572_);
        }
        if (DAModules.draconicTickAccel != null) {
            this.shapedRecipe((ItemLike)((Module)DAModules.draconicTickAccel.get()).getItem(), "modules").patternLine("A A").patternLine("SCS").patternLine("A A").key('A', DETags.Items.INGOTS_DRACONIUM_AWAKENED).key('S', (ItemLike)((Module)DEModules.WYVERN_SPEED.get()).getItem()).key('C', (ItemLike)DEContent.MODULE_CORE.get());
        }
        if (DAModules.chaoticTickAccel != null) {
            this.shapedRecipe((ItemLike)((Module)DAModules.chaoticTickAccel.get()).getItem(), "modules").patternLine("C C").patternLine("SDS").patternLine("C C").key('C', (Supplier)DEContent.CHAOS_FRAG_MEDIUM).key('S', (ItemLike)((Module)DEModules.DRACONIC_SPEED.get()).getItem()).key('D', (ItemLike)((Module)DAModules.draconicTickAccel.get()).getItem());
        }
        if (DAModules.semiStableChaos != null) {
            this.shapedRecipe((ItemLike)((Module)DAModules.semiStableChaos.get()).getItem(), "modules").patternLine("CRC").patternLine("SHS").patternLine("CRC").key('C', (Supplier)DEContent.CHAOS_FRAG_LARGE).key('S', (ItemLike)((Module)DEModules.DRACONIC_SHIELD_CAPACITY.get()).getItem()).key('R', (ItemLike)((Module)DEModules.DRACONIC_SHIELD_RECOVERY.get()).getItem()).key('H', (Supplier)DEContent.DRAGON_HEART);
        }
        if (DAModules.stableChaos != null) {
            this.shapedRecipe((ItemLike)((Module)DAModules.stableChaos.get()).getItem(), "modules").patternLine("CRC").patternLine("RHR").patternLine("CRC").key('C', (Supplier)DEContent.CHAOS_FRAG_LARGE).key('R', (ItemLike)((Module)DEModules.DRACONIC_SHIELD_RECOVERY.get()).getItem()).key('H', (Supplier)DEContent.DRAGON_HEART);
        }
        if (DAModules.unstableChaos != null) {
            this.shapedRecipe((ItemLike)((Module)DAModules.unstableChaos.get()).getItem(), "modules").patternLine("CSC").patternLine("SHS").patternLine("CSC").key('C', (Supplier)DEContent.CHAOS_FRAG_LARGE).key('S', (ItemLike)((Module)DEModules.DRACONIC_SHIELD_CAPACITY.get()).getItem()).key('H', (Supplier)DEContent.DRAGON_HEART);
        }
        if (DAModules.chaosInjector != null) {
            this.shapedRecipe((ItemLike)((Module)DAModules.chaosInjector.get()).getItem(), "modules").patternLine("CGC").patternLine("GMG").patternLine("CGC").key('C', (Supplier)DEContent.CHAOS_FRAG_MEDIUM).key('G', (ItemLike)Items.f_41904_).key('M', (Supplier)DEContent.MODULE_CORE);
        }
    }

    protected FusionRecipeBuilder fusionRecipe(Supplier<? extends ItemLike> result, ResourceLocation id) {
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemLike)result.get(), (int)1, (ResourceLocation)id));
    }

    protected FusionRecipeBuilder fusionRecipe(ItemLike result) {
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemLike)result));
    }

    protected FusionRecipeBuilder fusionRecipe(ItemLike result, int count) {
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemStack)new ItemStack(result, count)));
    }

    protected FusionRecipeBuilder fusionRecipe(Supplier<? extends ItemLike> result) {
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemLike)result.get(), (int)1));
    }

    protected FusionRecipeBuilder fusionRecipe(Supplier<? extends ItemLike> result, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemLike)result.get(), (int)1, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected FusionRecipeBuilder fusionRecipe(Supplier<? extends ItemLike> result, String folder, Function<String, String> customPath) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemLike)result.get(), (int)1, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + customPath.apply(id.m_135815_()))));
    }

    protected FusionRecipeBuilder fusionRecipe(Supplier<? extends ItemLike> result, int count, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemLike)result.get(), (int)count, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected FusionRecipeBuilder fusionRecipe(Supplier<? extends ItemLike> result, int count) {
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemStack)new ItemStack(result.get(), count)));
    }

    protected FusionRecipeBuilder fusionRecipe(ItemStack result) {
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemStack)result, (ResourceLocation)ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected FusionRecipeBuilder fusionRecipe(ItemStack result, ResourceLocation id) {
        return (FusionRecipeBuilder)this.builder((RecipeBuilder)FusionRecipeBuilder.builder((ItemStack)result, (ResourceLocation)id));
    }

    protected FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (FurnaceRecipeBuilder)this.builder((RecipeBuilder)FurnaceRecipeBuilder.smelting((ItemLike)result.get(), (int)1, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result, String folder, Function<String, String> customPath) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (FurnaceRecipeBuilder)this.builder((RecipeBuilder)FurnaceRecipeBuilder.smelting((ItemLike)result.get(), (int)1, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + customPath.apply(id.m_135815_()))));
    }

    protected ShapedRecipeBuilder shapedRecipe(Supplier<? extends ItemLike> result, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.builder((ItemLike)result.get(), (int)1, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemLike result, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_());
        return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.builder((ItemLike)result, (int)1, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected ShapedRecipeBuilder shapedRecipe(Supplier<? extends ItemLike> result, int count, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.builder((ItemLike)result.get(), (int)count, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected ShapedRecipeBuilder shapedRecipe(Supplier<? extends ItemLike> result, int count, String folder, Function<String, String> customPath) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (ShapedRecipeBuilder)this.builder((RecipeBuilder)ShapedRecipeBuilder.builder((ItemLike)result.get(), (int)count, (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + customPath.apply(id.m_135815_()))));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(Supplier<? extends ItemLike> result, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.builder((ItemStack)new ItemStack(result.get(), 1), (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(Supplier<? extends ItemLike> result, String folder, Function<String, String> customPath) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.builder((ItemStack)new ItemStack(result.get(), 1), (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + customPath.apply(id.m_135815_()))));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(Supplier<? extends ItemLike> result, int count, String folder) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.get().m_5456_());
        return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.builder((ItemStack)new ItemStack(result.get(), count), (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + id.m_135815_())));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result, int count, ResourceLocation id) {
        return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.builder((ItemStack)new ItemStack(result, count), (ResourceLocation)id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result, int count, String folder, Function<String, String> customPath) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_());
        return (ShapelessRecipeBuilder)this.builder((RecipeBuilder)ShapelessRecipeBuilder.builder((ItemStack)new ItemStack(result, count), (ResourceLocation)new ResourceLocation(id.m_135827_(), folder + "/" + customPath.apply(id.m_135815_()))));
    }

    public static class NBTIngredient
    extends StrictNBTIngredient {
        public NBTIngredient(ItemStack stack) {
            super(stack);
        }
    }
}

