/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.datagen;

import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.foxmcloud.draconicadditions.lib.DAModules;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "draconicadditions", existingFileHelper);
    }

    protected void registerModels() {
        this.blockItem((Block)DAContent.chaosLiquifier.get());
        this.blockItem((Block)DAContent.chaosInfuser.get());
        this.blockItem((Block)DAContent.chaosExtractor.get());
        this.blockItem((Block)DAContent.chaosCrystalizer.get());
        this.simpleItem((Item)DAContent.chaosHeart.get());
        this.simpleItem((Item)DAContent.inertPotatoHelm.get());
        this.simpleItem((Item)DAContent.inertPotatoChest.get());
        this.simpleItem((Item)DAContent.inertPotatoLegs.get());
        this.simpleItem((Item)DAContent.inertPotatoBoots.get());
        this.simpleArmor((Item)DAContent.infusedPotatoHelm.get());
        this.simpleArmor((Item)DAContent.infusedPotatoChest.get());
        this.simpleArmor((Item)DAContent.infusedPotatoLegs.get());
        this.simpleArmor((Item)DAContent.infusedPotatoBoots.get());
        this.simpleItem((Item)DAContent.chaosContainer.get(), "item/tools/animated");
        this.simpleCurios((Item)DAContent.necklaceWyvern.get());
        this.simpleCurios((Item)DAContent.necklaceDraconic.get());
        this.simpleCurios((Item)DAContent.necklaceChaotic.get());
        this.simpleCurios((Item)DAContent.harnessWyvern.get());
        this.simpleCurios((Item)DAContent.harnessDraconic.get());
        this.simpleCurios((Item)DAContent.harnessChaotic.get());
        this.simpleItem((Item)DAContent.hermal.get(), new ResourceLocation("minecraft", "item/poisonous_potato"));
        this.simpleModule((Module)DAModules.chaoticAutoFeed.get());
        this.simpleModule((Module)DAModules.draconicTickAccel.get());
        this.simpleModule((Module)DAModules.chaoticTickAccel.get());
        this.simpleModule((Module)DAModules.semiStableChaos.get());
        this.simpleModule((Module)DAModules.stableChaos.get());
        this.simpleModule((Module)DAModules.unstableChaos.get());
        this.simpleModule((Module)DAModules.chaosInjector.get());
    }

    private void simpleItem(Item item) {
        this.simpleItem(item, "item/crafting");
    }

    private void simpleArmor(Item item) {
        this.simpleItem(item, "item/armor");
    }

    private void simpleCurios(Item item) {
        this.simpleItem(item, "item/curios");
    }

    private void simpleItem(Item item, String textureFolder) {
        if (item == null) {
            return;
        }
        ResourceLocation reg = ForgeRegistries.ITEMS.getKey((Object)item);
        this.simpleItem(item, new ResourceLocation(reg.m_135827_(), textureFolder + "/" + reg.m_135815_()));
    }

    private void simpleItem(Item item, ResourceLocation texture) {
        if (item == null) {
            return;
        }
        ResourceLocation reg = ForgeRegistries.ITEMS.getKey((Object)item);
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private void simpleModule(Module<?> module) {
        this.simpleModule(module, "item/modules");
    }

    private void simpleModule(Module<?> module, String textureFolder) {
        if (module == null || module.getItem() == null) {
            return;
        }
        ResourceLocation reg = ModuleRegistry.getRegistry().getKey(module);
        this.simpleItem(module.getItem(), new ResourceLocation(reg.m_135827_(), textureFolder + "/" + reg.m_135815_().replace("_module", "")));
    }

    private void blockItem(Block block) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = ForgeRegistries.BLOCKS.getKey((Object)block);
        this.blockItem(block, new ResourceLocation(reg.m_135827_(), "block/" + reg.m_135815_()));
    }

    private void blockItem(Block block, ResourceLocation blockModel) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = ForgeRegistries.BLOCKS.getKey((Object)block);
        ((ItemModelBuilder)this.getBuilder(reg.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(blockModel));
    }

    private void dummyModel(Block block) {
        this.dummyModel(block.m_5456_());
    }

    private void dummyModel(Item item) {
        ((ItemModelBuilder)this.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"));
    }

    public String m_6055_() {
        return "Draconic Additions Item Models";
    }
}

