/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.IPayloadRegistrar;
import mcjty.lib.network.PlayPayloadContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class SimpleWrapperRegistrar
implements IPayloadRegistrar {
    private final String modid;
    private SimpleChannel channel = null;
    private String version = "1.0";
    private int packetId = 0;

    public SimpleWrapperRegistrar(String modid) {
        this.modid = modid;
    }

    @Override
    public IPayloadRegistrar versioned(String version) {
        this.version = version;
        return this;
    }

    @Override
    public IPayloadRegistrar optional() {
        return this;
    }

    private int id() {
        return this.packetId++;
    }

    @Override
    public <T extends CustomPacketPayload> void play(final Class<T> clazz, final Function<FriendlyByteBuf, T> create, Consumer<IHandlerGetter<T>> handler) {
        handler.accept(new IHandlerGetter<T>(){

            @Override
            public void client(BiConsumer<T, PlayPayloadContext> handle) {
                SimpleWrapperRegistrar.this.getChannel().registerMessage(SimpleWrapperRegistrar.this.id(), clazz, (t, buf) -> t.write((FriendlyByteBuf)buf), create, PlayPayloadContext.wrap(handle));
            }

            @Override
            public void server(BiConsumer<T, PlayPayloadContext> handle) {
                SimpleWrapperRegistrar.this.getChannel().registerMessage(SimpleWrapperRegistrar.this.id(), clazz, (t, buf) -> t.write((FriendlyByteBuf)buf), create, PlayPayloadContext.wrap(handle));
            }
        });
    }

    @Override
    public SimpleChannel getChannel() {
        if (this.channel == null) {
            this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(this.modid, this.modid)).networkProtocolVersion(() -> this.version).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        }
        return this.channel;
    }

    public static interface IHandlerGetter<T extends CustomPacketPayload> {
        public void client(BiConsumer<T, PlayPayloadContext> var1);

        public void server(BiConsumer<T, PlayPayloadContext> var1);
    }
}

