/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum TextureIndexes {
    NONE(-1, -1),
    COLOR(0, 15),
    DEFAULT_CONTRACT_LIGHT(19, 19),
    DEFAULT_WILD_LIGHT(20, 20),
    GUI(32, 32),
    COLOR_WILD(48, 63),
    ARMOR_1_DAMAGED(64, 73),
    ARMOR_2_DAMAGED(80, 89),
    COLOR_CONTRACT_LIGHT(96, 111),
    COLOR_WILD_LIGHT(112, 127),
    ARMOR_1_DAMAGED_LIGHT(128, 137),
    ARMOR_2_DAMAGED_LIGHT(144, 153);

    private static final Logger LOGGER;
    private final int indexMin;
    private final int indexMax;

    private TextureIndexes(int indexMin, int indexMax) {
        this.indexMin = indexMin;
        this.indexMax = indexMax;
    }

    public boolean isArmor() {
        switch (this) {
            case ARMOR_1_DAMAGED: 
            case ARMOR_2_DAMAGED: 
            case ARMOR_1_DAMAGED_LIGHT: 
            case ARMOR_2_DAMAGED_LIGHT: {
                return true;
            }
        }
        return false;
    }

    public int getIndexMin() {
        return this.indexMin;
    }

    public int getIndexMax() {
        return this.indexMax;
    }

    public static TextureIndexes getTextureIndexes(int index) {
        for (TextureIndexes textureIndex : TextureIndexes.values()) {
            if (textureIndex.getIndexMin() > index || index > textureIndex.getIndexMax()) continue;
            return textureIndex;
        }
        LOGGER.warn("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 : " + index);
        return NONE;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

