/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.util;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.util.TexturePair;

public class ArmorPart {
    private final TexturePair innerTex;
    private final TexturePair outerTex;
    private final IMultiModel innerModel;
    private final IMultiModel outerModel;

    public ArmorPart(ResourceLocation innerTex, ResourceLocation innerTexLight, ResourceLocation outerTex, ResourceLocation outerTexLight, IMultiModel innerModel, IMultiModel outerModel) {
        this.innerTex = new TexturePair(innerTex, innerTexLight);
        this.outerTex = new TexturePair(outerTex, outerTexLight);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
    }

    public ResourceLocation getTexture(IHasMultiModel.Layer layer, boolean isLight) {
        if (!layer.isArmor()) {
            throw new IllegalArgumentException("\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (layer == IHasMultiModel.Layer.INNER) {
            return this.innerTex.getTexture(isLight);
        }
        return this.outerTex.getTexture(isLight);
    }

    public IMultiModel getModel(IHasMultiModel.Layer layer) {
        if (!layer.isArmor()) {
            throw new IllegalArgumentException("\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (layer == IHasMultiModel.Layer.INNER) {
            return this.innerModel;
        }
        return this.outerModel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArmorPart that = (ArmorPart)o;
        return Objects.equals(this.innerTex, that.innerTex) && Objects.equals(this.outerTex, that.outerTex) && Objects.equals(this.innerModel, that.innerModel) && Objects.equals(this.outerModel, that.outerModel);
    }

    public int hashCode() {
        return Objects.hash(this.innerTex, this.outerTex, this.innerModel, this.outerModel);
    }

    public static final class Builder {
        private static final Map<TextureHolder, List<WeakReference<ArmorPart>>> REFERENCES = new HashMap<TextureHolder, List<WeakReference<ArmorPart>>>();
        private ResourceLocation innerTex;
        private ResourceLocation innerTexLight;
        private ResourceLocation outerTex;
        private ResourceLocation outerTexLight;
        private IMultiModel innerModel;
        private IMultiModel outerModel;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder innerTex(ResourceLocation innerTex) {
            this.innerTex = innerTex;
            return this;
        }

        public Builder innerTexLight(ResourceLocation innerTexLight) {
            this.innerTexLight = innerTexLight;
            return this;
        }

        public Builder outerTex(ResourceLocation outerTex) {
            this.outerTex = outerTex;
            return this;
        }

        public Builder outerTexLight(ResourceLocation outerTexLight) {
            this.outerTexLight = outerTexLight;
            return this;
        }

        public Builder innerModel(IMultiModel innerModel) {
            this.innerModel = innerModel;
            return this;
        }

        public Builder outerModel(IMultiModel outerModel) {
            this.outerModel = outerModel;
            return this;
        }

        public ArmorPart build() {
            return new ArmorPart(this.innerTex, this.innerTexLight, this.outerTex, this.outerTexLight, this.innerModel, this.outerModel);
        }

        private static ArmorPart getNewDataAndCache(TextureHolder textureHolder, ResourceLocation innerTex, ResourceLocation innerTexLight, ResourceLocation outerTex, ResourceLocation outerTexLight, IMultiModel innerModel, IMultiModel outerModel) {
            Builder.refreshReferences();
            List<WeakReference<ArmorPart>> references = REFERENCES.get(textureHolder);
            if (references != null) {
                Iterator<WeakReference<ArmorPart>> iterator = references.iterator();
                while (iterator.hasNext()) {
                    WeakReference<ArmorPart> reference = iterator.next();
                    ArmorPart weakData = (ArmorPart)reference.get();
                    if (weakData == null) {
                        iterator.remove();
                        continue;
                    }
                    if (weakData.getTexture(IHasMultiModel.Layer.INNER, false) != innerTex) continue;
                    return weakData;
                }
            }
            ArmorPart data = new ArmorPart(innerTex, innerTexLight, outerTex, outerTexLight, innerModel, outerModel);
            REFERENCES.put(textureHolder, Lists.newArrayList((Object[])new WeakReference[]{new WeakReference<ArmorPart>(data)}));
            return data;
        }

        private static void refreshReferences() {
            REFERENCES.forEach((texturePackage, references) -> {
                references.removeIf(reference -> reference.get() == null);
                if (references.size() <= 0) {
                    REFERENCES.remove(texturePackage);
                }
            });
        }
    }
}

