/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.loader;

import dev.architectury.platform.Platform;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.sistr.littlemaidmodelloader.client.resource.ResourceWrapper;
import net.sistr.littlemaidmodelloader.resource.loader.LMLoader;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.ResourceHelper;

public class LMTextureLoader
implements LMLoader {
    private final LMTextureManager textureManager;
    private final HashMap<String, String> converter = new HashMap();

    public LMTextureLoader(LMTextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public void addPathConverter(String target, String to) {
        this.converter.put(target, to);
    }

    @Override
    public boolean canLoad(String path, Path folderPath, InputStream inputStream, boolean isArchive) {
        return Platform.getEnv() == Dist.CLIENT && path.endsWith(".png") && ResourceHelper.getParentFolderName(path, isArchive).isPresent() && ResourceHelper.getIndex(path) != -1;
    }

    @Override
    public void load(String path, Path folderPath, InputStream inputStream, boolean isArchive) {
        ResourceLocation texturePath = this.getResourceLocation(path, isArchive).orElseThrow(() -> new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002"));
        String textureName = ResourceHelper.getTexturePackName(path, isArchive).orElseThrow(() -> new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002"));
        String modelName = ResourceHelper.getModelName(textureName);
        this.textureManager.addTexture(ResourceHelper.getFileName(path, isArchive), textureName, modelName, ResourceHelper.getIndex(path), texturePath);
        if (Platform.getEnv() == Dist.CLIENT) {
            ResourceWrapper.addResourcePath(texturePath, path, folderPath, isArchive);
        }
    }

    private Optional<ResourceLocation> getResourceLocation(String path, boolean isArchive) {
        String texturePath = path.toLowerCase();
        if (!isArchive) {
            texturePath = texturePath.replace("\\", "/");
        }
        for (Map.Entry<String, String> entry : this.converter.entrySet()) {
            texturePath = texturePath.replace(entry.getKey(), entry.getValue());
        }
        int firstSplitter = texturePath.indexOf("/");
        if (firstSplitter == -1) {
            return Optional.empty();
        }
        texturePath = texturePath.replaceAll("[^a-z0-9/._\\-]", "-");
        String namePath = texturePath.substring(firstSplitter + 1);
        return Optional.of(new ResourceLocation("littlemaidmodelloader", namePath));
    }
}

