/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.holder;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.resource.util.TextureIndexes;

public class TextureHolder {
    private final String name;
    private final String modelName;
    private final Map<Integer, ResourceLocation> textures = new HashMap<Integer, ResourceLocation>();
    private final Map<String, Map<Integer, ResourceLocation>> armors = new HashMap<String, Map<Integer, ResourceLocation>>();

    public TextureHolder(String name, String modelName) {
        this.name = name;
        this.modelName = modelName;
    }

    public String getTextureName() {
        return this.name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void addTexture(int index, ResourceLocation texturePath) {
        this.textures.put(index, texturePath);
    }

    public void addArmorTexture(String armorType, int index, ResourceLocation texturePath) {
        Map armorMap = this.armors.computeIfAbsent(armorType.toLowerCase(), k -> new HashMap());
        armorMap.put(index, texturePath);
    }

    public Optional<ResourceLocation> getTexture(TextureColors color, boolean isContract, boolean isLight) {
        int index = color.getIndex();
        if (isLight) {
            index += isContract ? TextureIndexes.COLOR_WILD_LIGHT.getIndexMin() : TextureIndexes.COLOR_CONTRACT_LIGHT.getIndexMin();
        } else if (!isContract) {
            index += TextureIndexes.COLOR_WILD.getIndexMin();
        }
        return Optional.ofNullable(this.textures.get(index));
    }

    public Optional<ResourceLocation> getArmorTexture(IHasMultiModel.Layer layer, String armorName, float damagePercent, boolean isLight) {
        if (this.armors.isEmpty()) {
            return Optional.empty();
        }
        Optional<ResourceLocation> optional = this.getArmorTextureInner(layer, armorName, damagePercent, isLight);
        if (optional.isPresent()) {
            return optional;
        }
        if (this.armors.containsKey("default") && !armorName.toLowerCase().equals("default")) {
            return this.getArmorTextureInner(layer, "default", damagePercent, isLight);
        }
        return this.armors.keySet().stream().filter(this.armors::containsKey).map(s -> this.getArmorTextureInner(layer, (String)s, damagePercent, isLight).orElse(null)).filter(Objects::nonNull).findAny();
    }

    public Optional<ResourceLocation> getArmorTextureInner(IHasMultiModel.Layer layer, String armorName, float damagePercent, boolean isLight) {
        if (this.armors.isEmpty()) {
            return Optional.empty();
        }
        Map<Integer, ResourceLocation> armorTextures = this.armors.get(armorName.toLowerCase());
        if (armorTextures == null || armorTextures.isEmpty()) {
            return Optional.empty();
        }
        int index = switch (layer) {
            case IHasMultiModel.Layer.INNER -> (isLight ? TextureIndexes.ARMOR_1_DAMAGED_LIGHT : TextureIndexes.ARMOR_1_DAMAGED).getIndexMin();
            case IHasMultiModel.Layer.OUTER -> (isLight ? TextureIndexes.ARMOR_2_DAMAGED_LIGHT : TextureIndexes.ARMOR_2_DAMAGED).getIndexMin();
            default -> throw new IllegalArgumentException("\u305d\u308c\u306f\u9632\u5177\u3067\u306f\u306a\u3044\u304bnull\u3067\u3042\u308b");
        };
        int damageIndex = Mth.m_14045_((int)((int)(damagePercent * 10.0f - 1.0f)), (int)0, (int)9);
        ResourceLocation armorTexture = armorTextures.get(index + damageIndex);
        if (armorTexture != null) {
            return Optional.of(armorTexture);
        }
        for (int i = 1; i <= damageIndex; ++i) {
            ResourceLocation temp = armorTextures.get(index + damageIndex - i);
            if (temp == null) continue;
            return Optional.of(temp);
        }
        return Optional.empty();
    }

    public Collection<String> getArmorNames() {
        return this.armors.keySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    public boolean hasSkinTexture(boolean isContract) {
        for (TextureColors color : TextureColors.values()) {
            if (!this.getTexture(color, isContract, false).isPresent() && !this.getTexture(color, isContract, true).isPresent()) continue;
            return true;
        }
        return false;
    }

    public boolean hasArmorTexture() {
        return !this.armors.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureHolder that = (TextureHolder)o;
        return this.name.equals(that.name) && this.modelName.equals(that.modelName) && this.textures.equals(that.textures) && this.armors.equals(that.armors);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.modelName, this.textures, this.armors);
    }
}

