/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.resource.classloader;

import dev.architectury.platform.Platform;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.sistr.littlemaidmodelloader.resource.classloader.MultiModelClassTransformer;
import org.apache.commons.io.IOUtils;

public class MultiModelClassLoader
extends URLClassLoader {
    private final MultiModelClassTransformer transformer = new MultiModelClassTransformer();

    public MultiModelClassLoader(List<Path> folderPaths) {
        super(MultiModelClassLoader.getClassLoaderURL(folderPaths), MultiModelClassLoader.class.getClassLoader());
    }

    private static URL[] getClassLoaderURL(List<Path> folderPaths) {
        ArrayList urlList = new ArrayList();
        folderPaths.forEach(folderPath -> {
            try (Stream<Path> stream = Files.walk(folderPath, new FileVisitOption[0]);){
                stream.filter(resourcePath -> !Files.isDirectory(resourcePath, new LinkOption[0])).map(resourcePath -> {
                    try {
                        return resourcePath.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                        return null;
                    }
                }).forEach(urlList::add);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return urlList.toArray(new URL[urlList.size()]);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        byte[] bytes;
        InputStream inputstream = this.getResourceAsStream(className.replace(".", "/") + ".class");
        if (inputstream == null) {
            throw new ClassNotFoundException(className + ":inputstream:" + className.replace(".", "/") + ".class");
        }
        try {
            bytes = IOUtils.toByteArray((InputStream)inputstream);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(className + ":toByteArray[" + String.valueOf(e) + "]");
        }
        if (bytes == null) {
            throw new ClassNotFoundException(className + ":bytes");
        }
        byte[] transBytes = this.transformer.transform(bytes);
        try {
            return this.defineClass(className, transBytes, 0, transBytes.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(className + ":defineClass_Exception:[" + String.valueOf(e) + "]");
        }
        catch (Error e) {
            throw new ClassNotFoundException(className + ":defineClass_Error:[" + String.valueOf(e) + "]");
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (Platform.isForge()) {
            try {
                return super.loadClass(name, resolve);
            }
            catch (IndexOutOfBoundsException e) {
                if (name.lastIndexOf(46) == -1) {
                    Class<?> c = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
                throw new ClassNotFoundException(name);
            }
        }
        return super.loadClass(name, resolve);
    }
}

