/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.entity.compound.SoundPlayable;
import net.sistr.littlemaidmodelloader.util.PlayerList;

public class LMSoundPacket {
    public static final ResourceLocation ID = new ResourceLocation("littlemaidmodelloader", "lm_sound");

    public static void sendS2CPacket(Entity entity, String soundName) {
        FriendlyByteBuf passedData = LMSoundPacket.createS2CPacket(entity, soundName);
        NetworkManager.sendToPlayers(PlayerList.tracking(entity).stream().filter(p -> p.m_20280_(entity) < 256.0).toList(), (ResourceLocation)ID, (FriendlyByteBuf)passedData);
    }

    public static FriendlyByteBuf createS2CPacket(Entity entity, String soundName) {
        FriendlyByteBuf passedData = new FriendlyByteBuf(Unpooled.buffer());
        passedData.m_130130_(entity.m_19879_());
        passedData.m_130070_(soundName);
        return passedData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveS2CPacket(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int entityId = buf.m_130242_();
        String soundName = buf.m_130277_();
        context.queue(() -> LMSoundPacket.playSoundClient(entityId, soundName));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundClient(int entityId, String soundName) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(entityId);
        if (entity instanceof SoundPlayable) {
            ((SoundPlayable)entity).play(soundName);
        }
    }
}

