/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.ListGUI;
import net.sistr.littlemaidmodelloader.client.screen.ListGUIElement;
import net.sistr.littlemaidmodelloader.network.SyncSoundPackPacket;
import net.sistr.littlemaidmodelloader.resource.holder.ConfigHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMConfigManager;

public class SoundPackSelectScreen<T extends Entity>
extends Screen {
    public static final ResourceLocation MODEL_SELECT_GUI_TEXTURE = new ResourceLocation("littlemaidmodelloader", "textures/gui/model_select.png");
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 196;
    private final T entity;
    private ListGUI<SoundPackGUI> soundPackListGUI;

    public SoundPackSelectScreen(Component titleIn, T owner) {
        super(titleIn);
        this.entity = owner;
    }

    protected void m_7856_() {
        int scale = 15;
        int allColor = 16;
        int heightRatio = 3;
        int heightStack = 4;
        int n = (this.f_96543_ - scale * allColor) / 2;
        int n2 = (this.f_96544_ - scale * heightRatio * heightStack) / 2;
        Objects.requireNonNull(this.f_96547_);
        int n3 = scale * heightRatio * heightStack / ((9 + 1) * 3);
        Objects.requireNonNull(this.f_96547_);
        this.soundPackListGUI = new ListGUI(n, n2, 1, n3, scale * allColor, (9 + 1) * 3, LMConfigManager.INSTANCE.getAllConfig().stream().map(c -> {
            Objects.requireNonNull(this.f_96547_);
            return new SoundPackGUI(scale * allColor, (9 + 1) * 3, this.f_96547_, (ConfigHolder)c);
        }).collect(Collectors.toList()));
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        assert (this.f_96541_ != null);
        int relX = (this.f_96543_ - 256) / 2;
        int relY = (this.f_96544_ - 196) / 2;
        context.m_280218_(MODEL_SELECT_GUI_TEXTURE, relX, relY, 0, 0, 256, 196);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.soundPackListGUI.m_88315_(context, mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.soundPackListGUI.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.soundPackListGUI.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.soundPackListGUI.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_7379_() {
        super.m_7379_();
        this.soundPackListGUI.getSelectElement().ifPresent(gui -> SyncSoundPackPacket.sendC2SPacket(this.entity, gui.getConfigHolder()));
    }

    public static class SoundPackGUI
    extends GUIElement
    implements ListGUIElement {
        private final Font textRenderer;
        private final ConfigHolder configHolder;
        private boolean selected;

        protected SoundPackGUI(int width, int height, Font textRenderer, ConfigHolder configHolder) {
            super(width, height);
            this.textRenderer = textRenderer;
            this.configHolder = configHolder;
        }

        public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            context.m_280056_(this.textRenderer, this.configHolder.getPackName(), this.x, this.y + 1, 0xFFFFFF, false);
            String string = this.configHolder.getParentName();
            Objects.requireNonNull(this.textRenderer);
            context.m_280056_(this.textRenderer, string, this.x, this.y + 1 + (9 + 1), 0xFFFFFF, false);
            String string2 = this.configHolder.getFileName();
            Objects.requireNonNull(this.textRenderer);
            context.m_280056_(this.textRenderer, string2, this.x, this.y + 1 + (9 + 1) * 2, 0xFFFFFF, false);
            context.m_280509_(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height, -1);
            if (this.selected) {
                context.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, -2130706433);
            }
        }

        @Override
        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        public ConfigHolder getConfigHolder() {
            return this.configHolder;
        }
    }
}

