/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.RangeChecker;
import net.sistr.littlemaidmodelloader.client.screen.TextureAddress;

public class ScrollBar
extends GUIElement {
    private final int elemSize;
    private final TextureAddress sliderT;
    private final TextureAddress sliderM;
    private final TextureAddress sliderB;
    private final TextureAddress pointer;
    private final ResourceLocation texture;
    private boolean clicked;
    private int point;

    public ScrollBar(int x, int y, int width, int height, int elemSize, TextureAddress sliderT, TextureAddress sliderM, TextureAddress sliderB, TextureAddress pointer, ResourceLocation texture) {
        super(width, height);
        this.x = x;
        this.y = y;
        this.elemSize = elemSize;
        this.sliderT = sliderT;
        this.sliderM = sliderM;
        this.sliderB = sliderB;
        this.pointer = pointer;
        this.texture = texture;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.draw(context, this.x, this.y, this.sliderT);
        int midRange = this.height - (this.sliderT.height() + this.sliderB.height());
        int i = 0;
        while (i < midRange) {
            this.draw(context, this.x, this.y + (i += this.sliderM.height()), this.sliderM);
        }
        this.draw(context, this.x, this.y + this.height - this.sliderB.height(), this.sliderB);
        this.draw(context, this.x + (this.sliderT.width() - this.pointer.width()) / 2, (int)((float)this.y + (float)(this.width - this.pointer.height()) / 2.0f + this.getPercent() * (float)(this.height - this.width)), this.pointer);
    }

    private void draw(GuiGraphics context, int x, int y, TextureAddress texture) {
        context.m_280163_(this.texture, x, y, (float)texture.u(), (float)texture.v(), texture.width(), texture.height(), texture.texSizeW(), texture.texSizeH());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        if (!RangeChecker.checkFromWidth(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            return false;
        }
        this.clicked = true;
        this.pointAt(mouseY);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button != 0) {
            return false;
        }
        if (!this.clicked && !RangeChecker.checkFromWidth(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            return false;
        }
        this.clicked = true;
        this.pointAt(mouseY);
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.clicked = false;
            return false;
        }
        return false;
    }

    public void pointAt(double y) {
        float percent = ((float)y - (float)this.y - (float)this.width / 2.0f) / (float)(this.height - this.width);
        this.point = Mth.m_14143_((float)(percent * (float)this.elemSize));
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!RangeChecker.checkFromWidth(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            return false;
        }
        this.point += 0.0 < amount ? -1 : 1;
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
        return true;
    }

    public float getPercent() {
        return (float)this.getPoint() / (float)this.elemSize;
    }

    public void setPercent(float percent) {
        this.point = Mth.m_14143_((float)(percent * (float)this.elemSize));
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int point) {
        this.point = point;
        this.point = Mth.m_14045_((int)this.point, (int)0, (int)(this.elemSize - 1));
    }
}

