/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.screen.ModelSelectScreen;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.EntityCaps;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMPose;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.util.ArmorPart;
import net.sistr.littlemaidmodelloader.resource.util.ArmorSets;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.resource.util.TexturePair;
import net.sistr.littlemaidmodelloader.setup.Registration;

public class MultiModelGUIUtil {
    public static Optional<IMultiModel> getModel(LMModelManager modelManager, TextureHolder texture) {
        if (modelManager.getModel(texture.getModelName(), IHasMultiModel.Layer.SKIN).isEmpty()) {
            return Optional.empty();
        }
        return modelManager.getModel(texture.getModelName(), IHasMultiModel.Layer.SKIN);
    }

    public static Optional<TexturePair> getTexturePair(TextureHolder holder, TextureColors color, boolean isContract) {
        Optional<ResourceLocation> optional = holder.getTexture(color, isContract, false);
        return optional.map(resourceLocation -> new TexturePair((ResourceLocation)resourceLocation, holder.getTexture(color, isContract, true).orElse(null)));
    }

    public static void renderModel(GuiGraphics context, int posX, int posY, float mouseX, float mouseY, int scale, IMultiModel model, TexturePair texturePair, DummyModelEntity dummy) {
        dummy.setSkinModel(model);
        dummy.setSkinTexture(texturePair);
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            dummy.setArmorVisible(false, part);
            dummy.setArmorData(ModelSelectScreen.EMPTY_ARMOR_DATA, part);
        }
        dummy.setAllArmorVisible(false);
        MultiModelGUIUtil.renderEntity(context, posX, posY, mouseX, mouseY, scale, model, dummy);
    }

    public static ArmorPart getArmorDate(LMModelManager modelManager, TextureHolder texture, String armorName) {
        IMultiModel innerModel = modelManager.getModel(texture.getModelName(), IHasMultiModel.Layer.INNER).orElseThrow(() -> new IllegalStateException("\u30e2\u30c7\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093"));
        IMultiModel outerModel = modelManager.getModel(texture.getModelName(), IHasMultiModel.Layer.OUTER).orElseThrow(() -> new IllegalStateException("\u30e2\u30c7\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093"));
        ResourceLocation innerTex = texture.getArmorTexture(IHasMultiModel.Layer.INNER, armorName, 0.0f, false).orElse(null);
        ResourceLocation innerLightTex = texture.getArmorTexture(IHasMultiModel.Layer.INNER, armorName, 0.0f, true).orElse(null);
        ResourceLocation outerTex = texture.getArmorTexture(IHasMultiModel.Layer.OUTER, armorName, 0.0f, false).orElse(null);
        ResourceLocation outerLightTex = texture.getArmorTexture(IHasMultiModel.Layer.OUTER, armorName, 0.0f, true).orElse(null);
        return new ArmorPart(innerTex, innerLightTex, outerTex, outerLightTex, innerModel, outerModel);
    }

    public static void renderArmor(GuiGraphics context, int posX, int posY, float mouseX, float mouseY, int scale, IMultiModel model, ArmorPart data, DummyModelEntity dummy) {
        dummy.setSkinModel(model);
        dummy.setSkinTexture(ModelSelectScreen.EMPTY_TEXTURE_PAIR);
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            dummy.setArmorVisible(true, part);
            dummy.setArmorData(data, part);
        }
        MultiModelGUIUtil.renderEntity(context, posX, posY, mouseX, mouseY, scale, model, dummy);
    }

    public static void renderArmorPart(GuiGraphics context, int posX, int posY, float mouseX, float mouseY, int scale, IMultiModel model, ArmorPart data, IHasMultiModel.Part armorPart, DummyModelEntity dummy) {
        dummy.setSkinModel(model);
        dummy.setSkinTexture(ModelSelectScreen.EMPTY_TEXTURE_PAIR);
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            dummy.setArmorVisible(false, part);
            dummy.setArmorData(ModelSelectScreen.EMPTY_ARMOR_DATA, part);
        }
        dummy.setArmorVisible(true, armorPart);
        dummy.setArmorData(data, armorPart);
        MultiModelGUIUtil.renderEntity(context, posX, posY, mouseX, mouseY, scale, model, dummy);
    }

    public static void renderEntity(GuiGraphics context, int posX, int posY, float mouseX, float mouseY, int scale, IMultiModel model, DummyModelEntity dummy) {
        InventoryScreen.m_274545_((GuiGraphics)context, (int)posX, (int)posY, (int)scale, (float)((float)posX - mouseX), (float)((float)posY - mouseY - model.getEyeHeight(dummy.getCaps(), MMPose.STANDING) * (float)scale), (LivingEntity)dummy);
    }

    public static class DummyModelEntity
    extends LivingEntity
    implements IHasMultiModel {
        private final EntityCaps caps = new EntityCaps(this);
        private IMultiModel skinModel;
        private TexturePair skinTexture;
        private final ArmorSets<ArmorPart> armorsData = new ArmorSets();
        private final ArmorSets<Boolean> armorsVisible = new ArmorSets();

        public DummyModelEntity(Level worldIn) {
            this((EntityType<DummyModelEntity>)((EntityType)Registration.DUMMY_MODEL_ENTITY.get()), worldIn);
        }

        public DummyModelEntity(EntityType<DummyModelEntity> type, Level worldIn) {
            super(type, worldIn);
        }

        public void setSkinModel(IMultiModel model) {
            this.skinModel = model;
        }

        public void setSkinTexture(TexturePair skinTexture) {
            this.skinTexture = skinTexture;
        }

        public void setArmorData(ArmorPart data, IHasMultiModel.Part part) {
            this.armorsData.setArmor(data, part);
        }

        public void setArmorVisible(boolean visible, IHasMultiModel.Part part) {
            this.armorsVisible.setArmor(visible, part);
        }

        public void setAllArmorVisible(boolean visible) {
            for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
                this.armorsVisible.setArmor(visible, part);
            }
        }

        public Iterable<ItemStack> m_6168_() {
            return Lists.newArrayList((Object[])new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_});
        }

        public ItemStack m_6844_(EquipmentSlot slot) {
            return ItemStack.f_41583_;
        }

        public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        }

        public HumanoidArm m_5737_() {
            return HumanoidArm.RIGHT;
        }

        @Override
        @Deprecated
        public void setTextureHolder(TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public TextureHolder getTextureHolder(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void setColorMM(TextureColors color) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public TextureColors getColorMM() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void setContractMM(boolean isContract) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean isContractMM() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<IMultiModel> getModel(IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
            if (layer == IHasMultiModel.Layer.SKIN) {
                return Optional.ofNullable(this.skinModel);
            }
            return this.armorsData.getArmor(part).map(armorPart -> armorPart.getModel(layer));
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Optional<ResourceLocation> getTexture(IHasMultiModel.Layer layer, IHasMultiModel.Part part, boolean isLight) {
            if (layer == IHasMultiModel.Layer.SKIN) {
                if (this.skinTexture == null) {
                    return Optional.empty();
                }
                return Optional.ofNullable(this.skinTexture.getTexture(isLight));
            }
            return this.armorsData.getArmor(part).map(armorPart -> armorPart.getTexture(layer, isLight));
        }

        @Override
        public IModelCaps getCaps() {
            return this.caps;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean isArmorVisible(IHasMultiModel.Part part) {
            return this.armorsVisible.getArmor(part).orElse(false);
        }

        @Override
        public boolean isArmorGlint(IHasMultiModel.Part part) {
            return false;
        }

        @Override
        @Deprecated
        public boolean isAllowChangeTexture(Entity changer, TextureHolder textureHolder, IHasMultiModel.Layer layer, IHasMultiModel.Part part) {
            throw new UnsupportedOperationException();
        }
    }
}

