/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.screen.ArmorModelGUI;
import net.sistr.littlemaidmodelloader.client.screen.ListGUI;
import net.sistr.littlemaidmodelloader.client.screen.MultiModelGUI;
import net.sistr.littlemaidmodelloader.client.screen.MultiModelGUIUtil;
import net.sistr.littlemaidmodelloader.client.screen.ScrollBar;
import net.sistr.littlemaidmodelloader.client.screen.TextureAddress;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.network.SyncMultiModelPacket;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.manager.LMTextureManager;
import net.sistr.littlemaidmodelloader.resource.util.ArmorPart;
import net.sistr.littlemaidmodelloader.resource.util.ArmorSets;
import net.sistr.littlemaidmodelloader.resource.util.TextureColors;
import net.sistr.littlemaidmodelloader.resource.util.TexturePair;

@OnlyIn(value=Dist.CLIENT)
public class ModelSelectScreen<T extends Entity>
extends Screen {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("littlemaidmodelloader", "textures/empty.png");
    public static final TexturePair EMPTY_TEXTURE_PAIR = new TexturePair(EMPTY_TEXTURE, null);
    public static final ArmorPart EMPTY_ARMOR_DATA = new ArmorPart(null, null, null, null, null, null);
    public static final ResourceLocation MODEL_SELECT_GUI_TEXTURE = new ResourceLocation("littlemaidmodelloader", "textures/gui/model_select.png");
    private static final ItemStack ARMOR = Items.f_42473_.m_7968_();
    private static final ItemStack MODEL = Items.f_42650_.m_7968_();
    private static final ItemStack WILD = Items.f_42500_.m_7968_();
    private static final ItemStack CONTRACT = Items.f_42502_.m_7968_();
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 196;
    private final T entity;
    private final MultiModelGUIUtil.DummyModelEntity dummy;
    private final ArmorSets<ArmorModelGUI> armors = new ArmorSets();
    private final int scale = 15;
    private final int heightRatio = 3;
    private final int heightStack = 4;
    private ScrollBar modelScrollBar;
    private ScrollBar armorScrollBar;
    private ListGUI<MultiModelGUI> modelListGUI;
    private ListGUI<ArmorModelGUI> armorListGUI;
    private boolean guiSwitch = true;
    private boolean isContract = true;

    public ModelSelectScreen(Component titleIn, Level world, T entity) {
        super(titleIn);
        this.entity = entity;
        this.dummy = new MultiModelGUIUtil.DummyModelEntity(world);
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        Collection<TextureHolder> textureHolders = LMTextureManager.INSTANCE.getAllTextures();
        HashMap<String, TextureHolder> map = new HashMap<String, TextureHolder>();
        textureHolders.forEach(textureHolder -> map.put(textureHolder.getTextureName().toLowerCase(), (TextureHolder)textureHolder));
        this.initModelGUI(textureHolders, map);
        this.initArmorGUI(textureHolders, map);
    }

    protected void initModelGUI(Collection<TextureHolder> textureHolders, Map<String, TextureHolder> textureHolderMap) {
        int allColor = 16;
        LMModelManager modelManager = LMModelManager.INSTANCE;
        this.modelListGUI = new ListGUI((this.f_96543_ - 15 * allColor) / 2, (this.f_96544_ - 180) / 2, 1, 4, 15 * allColor, 45, textureHolders.stream().map(TextureHolder::getTextureName).map(String::toLowerCase).sorted(Comparator.naturalOrder()).map(textureHolderMap::get).filter(textureHolder -> textureHolder.hasSkinTexture(this.isContract) && modelManager.getModel(textureHolder.getModelName(), IHasMultiModel.Layer.SKIN).isPresent()).map(t -> new MultiModelGUI((TextureHolder)t, this.isContract, 15, this.dummy)).collect(Collectors.toList()));
        this.modelScrollBar = new ScrollBar((this.f_96543_ + 256) / 2 + 4, (this.f_96544_ - 196) / 2, 8, 196, this.modelListGUI.size(), new TextureAddress(0, 200, 8, 8, 256, 256), new TextureAddress(0, 208, 8, 8, 256, 256), new TextureAddress(0, 216, 8, 8, 256, 256), new TextureAddress(0, 224, 10, 6, 256, 256), MODEL_SELECT_GUI_TEXTURE);
        TextureHolder ownerSkinTex = ((IHasMultiModel)this.entity).getTextureHolder(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD);
        int index = 0;
        for (MultiModelGUI g : this.modelListGUI.getAllElements()) {
            if (g.getTexture() == ownerSkinTex) {
                this.modelScrollBar.setPoint(index);
                this.modelListGUI.setScroll(index);
            }
            ++index;
        }
    }

    protected void initArmorGUI(Collection<TextureHolder> textureHolders, Map<String, TextureHolder> map) {
        LMModelManager modelManager = LMModelManager.INSTANCE;
        int allColor = 16;
        this.armorListGUI = new ListGUI((this.f_96543_ - 15 * allColor) / 2, (this.f_96544_ - 180) / 2, 1, 4, 15 * allColor, 45, textureHolders.stream().map(TextureHolder::getTextureName).map(String::toLowerCase).sorted(Comparator.naturalOrder()).map(map::get).filter(textureHolder -> textureHolder.hasArmorTexture() && modelManager.getModel(textureHolder.getModelName(), IHasMultiModel.Layer.INNER).isPresent()).map(t -> new ArmorModelGUI((TextureHolder)t, 15, this.dummy, this.armors)).collect(Collectors.toList()));
        this.armorScrollBar = new ScrollBar((this.f_96543_ + 256) / 2 + 4, (this.f_96544_ - 196) / 2, 8, 196, this.armorListGUI.size(), new TextureAddress(0, 200, 8, 8, 256, 256), new TextureAddress(0, 208, 8, 8, 256, 256), new TextureAddress(0, 216, 8, 8, 256, 256), new TextureAddress(0, 224, 10, 6, 256, 256), MODEL_SELECT_GUI_TEXTURE);
        TextureHolder ownerArmorTex = ((IHasMultiModel)this.entity).getTextureHolder(IHasMultiModel.Layer.INNER, IHasMultiModel.Part.HEAD);
        int index = 0;
        for (ArmorModelGUI g : this.armorListGUI.getAllElements()) {
            if (g.getTexture() == ownerArmorTex) {
                this.armorScrollBar.setPoint(index);
                this.armorListGUI.setScroll(index);
            }
            ++index;
        }
    }

    public static void renderColor(GuiGraphics context, int minX, int minY, int maxX, int maxY, int rgba) {
        context.m_280509_(minX, minY, maxX, maxY, rgba);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        assert (this.f_96541_ != null);
        int relX = (this.f_96543_ - 256) / 2;
        int relY = (this.f_96544_ - 196) / 2;
        context.m_280218_(MODEL_SELECT_GUI_TEXTURE, relX, relY, 0, 0, 256, 196);
        context.m_280480_(this.guiSwitch ? ARMOR : MODEL, relX - 24, relY + 196 - 16);
        context.m_280480_(this.isContract ? WILD : CONTRACT, relX - 24, relY + 196 - 48);
        context.m_280218_(MODEL_SELECT_GUI_TEXTURE, relX - 24, relY + 196 - 16, 0, 240, 16, 16);
        context.m_280218_(MODEL_SELECT_GUI_TEXTURE, relX - 24, relY + 196 - 48, 0, 240, 16, 16);
        if (this.guiSwitch) {
            this.modelListGUI.m_88315_(context, mouseX, mouseY, partialTicks);
            this.modelListGUI.getSelectElement().filter(MultiModelGUI::isSelected).ifPresent(g -> g.getSelectColor().ifPresent(color -> {
                TextureHolder texture = g.getTexture();
                MultiModelGUIUtil.getModel(LMModelManager.INSTANCE, texture).ifPresent(model -> {
                    int scale = 45;
                    MultiModelGUIUtil.getTexturePair(texture, color, true).ifPresent(texturePair -> MultiModelGUIUtil.renderModel(context, (this.f_96543_ + 240 + scale * 2) / 2, this.f_96544_ - scale, mouseX, mouseY, scale, model, texturePair, this.dummy));
                });
            }));
            this.modelScrollBar.m_88315_(context, mouseX, mouseY, partialTicks);
        } else {
            this.armorListGUI.m_88315_(context, mouseX, mouseY, partialTicks);
            this.armors.foreach((p, g) -> {
                TextureHolder texture = g.getTexture();
                MultiModelGUIUtil.getModel(LMModelManager.INSTANCE, texture).ifPresent(model -> {
                    int scale = 45;
                    LMModelManager modelManager = LMModelManager.INSTANCE;
                    ArmorPart armorData = MultiModelGUIUtil.getArmorDate(modelManager, texture, "default");
                    MultiModelGUIUtil.renderArmorPart(context, (this.f_96543_ + 240 + scale * 2) / 2, this.f_96544_ - scale, mouseX, mouseY, scale, model, armorData, p, this.dummy);
                });
            });
            this.armorScrollBar.m_88315_(context, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        int minX = (this.f_96543_ - 256) / 2 - 24;
        int minY = (this.f_96544_ - 196) / 2 + 196 - 16;
        if ((double)minX <= x && x < (double)(minX + 16) && (double)minY <= y && y < (double)(minY + 16)) {
            this.guiSwitch = !this.guiSwitch;
            ModelSelectScreen.playDownSound();
            return true;
        }
        if ((double)minX <= x && x < (double)(minX + 16) && (double)(minY - 32) <= y && y < (double)(minY - 16)) {
            this.isContract = !this.isContract;
            Collection<TextureHolder> textureHolders = LMTextureManager.INSTANCE.getAllTextures();
            HashMap<String, TextureHolder> map = new HashMap<String, TextureHolder>();
            textureHolders.forEach(textureHolder -> map.put(textureHolder.getTextureName().toLowerCase(), (TextureHolder)textureHolder));
            this.initModelGUI(textureHolders, map);
            ModelSelectScreen.playDownSound();
            return true;
        }
        if (this.guiSwitch) {
            if (this.modelScrollBar.m_6375_(x, y, button)) {
                this.modelListGUI.setScroll(this.modelScrollBar.getPoint());
                return true;
            }
            return this.modelListGUI.m_6375_(x, y, button);
        }
        if (this.armorScrollBar.m_6375_(x, y, button)) {
            this.armorListGUI.setScroll(this.armorScrollBar.getPoint());
            return true;
        }
        return this.armorListGUI.m_6375_(x, y, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.guiSwitch) {
            if (this.modelScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
                this.modelListGUI.setScroll(this.modelScrollBar.getPoint());
                return true;
            }
        } else if (this.armorScrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            this.armorListGUI.setScroll(this.armorScrollBar.getPoint());
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.guiSwitch) {
            this.modelScrollBar.m_6348_(mouseX, mouseY, button);
            return this.modelListGUI.m_6348_(mouseX, mouseY, button);
        }
        this.armorScrollBar.m_6348_(mouseX, mouseY, button);
        return this.armorListGUI.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double scrollAmount) {
        if (this.guiSwitch) {
            if (this.modelScrollBar.m_6050_(x, y, scrollAmount)) {
                this.modelListGUI.setScroll(this.modelScrollBar.getPoint());
                return true;
            }
            if (this.modelListGUI.m_6050_(x, y, scrollAmount)) {
                this.modelScrollBar.setPoint(this.modelListGUI.getScroll());
                return true;
            }
            return false;
        }
        if (this.armorScrollBar.m_6050_(x, y, scrollAmount)) {
            this.armorListGUI.setScroll(this.armorScrollBar.getPoint());
            return true;
        }
        if (this.armorListGUI.m_6050_(x, y, scrollAmount)) {
            this.armorScrollBar.setPoint(this.armorListGUI.getScroll());
            return true;
        }
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        this.modelListGUI.getSelectElement().ifPresent(g -> g.getSelectColor().ifPresent(color -> {
            TextureHolder texture = g.getTexture();
            ((IHasMultiModel)this.entity).setColorMM((TextureColors)((Object)((Object)color)));
            ((IHasMultiModel)this.entity).setContractMM(this.isContract);
            ((IHasMultiModel)this.entity).setTextureHolder(texture, IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.HEAD);
            for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
                ((IHasMultiModel)this.entity).setTextureHolder(texture, IHasMultiModel.Layer.INNER, part);
            }
        }));
        this.armors.foreach((p, g) -> ((IHasMultiModel)this.entity).setTextureHolder(g.getTexture(), IHasMultiModel.Layer.INNER, (IHasMultiModel.Part)((Object)p)));
        ArmorSets<String> armorNames = new ArmorSets<String>();
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            armorNames.setArmor(((IHasMultiModel)this.entity).getTextureHolder(IHasMultiModel.Layer.INNER, part).getTextureName(), part);
        }
        SyncMultiModelPacket.sendC2SPacket(this.entity, (IHasMultiModel)this.entity);
    }

    public static void playDownSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }
}

