/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.screen;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sistr.littlemaidmodelloader.client.screen.GUIElement;
import net.sistr.littlemaidmodelloader.client.screen.ListGUIElement;
import net.sistr.littlemaidmodelloader.client.screen.MarginedClickable;
import net.sistr.littlemaidmodelloader.client.screen.ModelSelectScreen;
import net.sistr.littlemaidmodelloader.client.screen.MultiModelGUIUtil;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.IMultiModel;
import net.sistr.littlemaidmodelloader.resource.holder.TextureHolder;
import net.sistr.littlemaidmodelloader.resource.manager.LMModelManager;
import net.sistr.littlemaidmodelloader.resource.util.ArmorPart;
import net.sistr.littlemaidmodelloader.resource.util.ArmorSets;

public class ArmorModelGUI
extends GUIElement
implements ListGUIElement {
    private static final ArmorSets<ItemStack> ARMOR_ICONS = new ArmorSets();
    private final MarginedClickable selectBox = new MarginedClickable(4);
    private final int scale;
    private final MultiModelGUIUtil.DummyModelEntity dummy;
    private final TextureHolder texture;
    private final ImmutableList<String> armorNames;
    private final ArmorSets<ArmorModelGUI> armors;
    private boolean selected;

    public ArmorModelGUI(TextureHolder texture, int scale, MultiModelGUIUtil.DummyModelEntity dummy, ArmorSets<ArmorModelGUI> armors) {
        super(scale * 16, scale * 3);
        this.scale = scale;
        this.dummy = dummy;
        this.texture = texture;
        this.armorNames = ImmutableList.copyOf(texture.getArmorNames());
        this.armors = armors;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        MultiModelGUIUtil.getModel(LMModelManager.INSTANCE, this.texture).ifPresent(model -> this.renderAllArmorModel(context, this.scale, mouseX, mouseY, (IMultiModel)model, this.texture, this.dummy));
    }

    public void renderAllArmorModel(GuiGraphics context, int scale, float mouseX, float mouseY, IMultiModel model, TextureHolder texture, MultiModelGUIUtil.DummyModelEntity dummy) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(fontRenderer);
        ModelSelectScreen.renderColor(context, this.x, this.y, this.x + this.width, this.y + 9, -12566464);
        int index = 0;
        LMModelManager modelManager = LMModelManager.INSTANCE;
        for (String armorName : this.armorNames) {
            ArmorPart armorData = MultiModelGUIUtil.getArmorDate(modelManager, texture, armorName);
            MultiModelGUIUtil.renderArmor(context, this.x + ++index * scale - scale / 2, this.y + this.height, mouseX, mouseY, scale, model, armorData, dummy);
        }
        context.m_280056_(fontRenderer, texture.getTextureName(), this.x, this.y, -1, false);
        ARMOR_ICONS.foreach((part, stack) -> {
            int n = this.x + this.width - 16 * (part.getIndex() + 1);
            Objects.requireNonNull(fontRenderer);
            context.m_280480_(stack, n, this.y + 9);
        });
        this.armors.foreach((p, g) -> {
            if (g == this) {
                int n = this.x + this.width - 16 * (p.getIndex() + 1);
                Objects.requireNonNull(fontRenderer);
                int n2 = this.x + this.width - 16 * (p.getIndex() + 1) + 16;
                Objects.requireNonNull(fontRenderer);
                ModelSelectScreen.renderColor(context, n, this.y + 9, n2, this.y + 9 + 16, -2130706433);
            }
        });
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.selectBox.click(mouseX, mouseY);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button != 0) return false;
        if (!this.selectBox.release(mouseX, mouseY)) return false;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        if ((double)(this.width - 64) <= mouseX && mouseX < (double)this.width) {
            Objects.requireNonNull(fontRenderer);
            if (9.0 <= mouseY) {
                Objects.requireNonNull(fontRenderer);
                if (mouseY < (double)(9 + 16)) {
                    int index = 3 - Mth.m_14107_((double)((mouseX - (double)(this.width - 64)) / 16.0));
                    IHasMultiModel.Part part = IHasMultiModel.Part.getPart(index);
                    if (this.armors.getArmor(part).filter(g -> g == this).isPresent()) {
                        this.armors.setArmor(null, part);
                        return true;
                    }
                    this.armors.setArmor(this, part);
                    return true;
                }
            }
        }
        boolean selectAll = false;
        for (IHasMultiModel.Part part : IHasMultiModel.Part.values()) {
            if (!this.armors.getArmor(part).filter(g -> g == this).isEmpty()) continue;
            selectAll = true;
            break;
        }
        IHasMultiModel.Part[] partArray = IHasMultiModel.Part.values();
        int n = partArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHasMultiModel.Part part;
            part = partArray[n2];
            this.armors.setArmor(selectAll ? this : null, part);
            ++n2;
        }
        return true;
    }

    public TextureHolder getTexture() {
        return this.texture;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    static {
        ARMOR_ICONS.setArmor(Items.f_42472_.m_7968_(), IHasMultiModel.Part.HEAD);
        ARMOR_ICONS.setArmor(Items.f_42473_.m_7968_(), IHasMultiModel.Part.BODY);
        ARMOR_ICONS.setArmor(Items.f_42474_.m_7968_(), IHasMultiModel.Part.LEGS);
        ARMOR_ICONS.setArmor(Items.f_42475_.m_7968_(), IHasMultiModel.Part.FEET);
    }
}

