/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.resource;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ResourceWrapper
implements PackResources {
    public static final ResourceWrapper INSTANCE = new ResourceWrapper();
    public static final PackMetadataSection PACK_INFO = new PackMetadataSection((Component)Component.m_237113_((String)"LittleMaid ModelLoader!!!"), 15);
    protected static final HashMap<ResourceLocation, Resource> PATHS = Maps.newHashMap();

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... segments) {
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        Resource resource = PATHS.get(id);
        if (resource == null) {
            return null;
        }
        return resource::getInputStream;
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        PATHS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals(namespace)).filter(entry -> ((ResourceLocation)entry.getKey()).m_135815_().startsWith(prefix)).forEach(e -> consumer.accept((Object)((ResourceLocation)e.getKey()), () -> ((Resource)e.getValue()).getInputStream()));
    }

    public boolean m_246538_() {
        return true;
    }

    public Set<String> m_5698_(PackType type) {
        return Sets.newHashSet((Object[])new String[]{"littlemaidmodelloader"});
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        if (metaReader.m_7991_().equals("pack")) {
            return (T)PACK_INFO;
        }
        return null;
    }

    public String m_5542_() {
        return "LMModelLoader";
    }

    public void close() {
    }

    public static void addResourcePath(ResourceLocation resourcePath, String path, Path homePath, boolean isArchive) {
        PATHS.put(resourcePath, new Resource(path, homePath, isArchive));
    }

    private record Resource(String path, Path homePath, boolean isArchive) {
        public InputStream getInputStream() throws IOException {
            if (this.isArchive) {
                String resourcePath = this.homePath.toString();
                ZipFile zipfile = new ZipFile(resourcePath);
                ZipEntry zipentry = zipfile.getEntry(this.path);
                if (zipentry == null) {
                    zipfile.close();
                    throw new NoSuchFileException(this.path);
                }
                return zipfile.getInputStream(zipentry);
            }
            return Files.newInputStream(Paths.get(this.homePath.toString(), this.path), new OpenOption[0]);
        }
    }
}

