/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModel;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMMatrixStack;

@OnlyIn(value=Dist.CLIENT)
public class MultiModelHeldItemLayer<T extends LivingEntity, M extends MultiModel<T>>
extends RenderLayer<T, M> {
    public MultiModelHeldItemLayer(RenderLayerParent<T, M> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ItemStack leftStack;
        boolean isMainRight = entity.m_5737_() == HumanoidArm.RIGHT;
        ItemStack rightStack = isMainRight ? entity.m_21205_() : entity.m_21206_();
        ItemStack itemStack = leftStack = isMainRight ? entity.m_21206_() : entity.m_21205_();
        if (!leftStack.m_41619_() || !rightStack.m_41619_()) {
            matrices.m_85836_();
            if (((MultiModel)this.m_117386_()).f_102610_) {
                matrices.m_85837_(0.0, 0.75, 0.0);
                matrices.m_85841_(0.5f, 0.5f, 0.5f);
            }
            this.handRender(entity, rightStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, matrices, vertexConsumers, light);
            this.handRender(entity, leftStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, matrices, vertexConsumers, light);
            matrices.m_85849_();
        }
    }

    private void handRender(T entity, ItemStack stack, ItemDisplayContext mode, HumanoidArm hand, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        if (!stack.m_41619_()) {
            matrixStack.m_85836_();
            boolean isLeft = hand == HumanoidArm.LEFT;
            ((IHasMultiModel)entity).getModel(IHasMultiModel.Layer.SKIN, IHasMultiModel.Part.BODY).ifPresent(model -> model.adjustHandItem(new MMMatrixStack(matrixStack), isLeft));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrixStack.m_252880_(isLeft ? -0.0125f : 0.0125f, 0.05f, -0.15f);
            Minecraft.m_91087_().m_91291_().m_269491_(entity, stack, mode, isLeft, matrixStack, buffer, entity.m_9236_(), light, OverlayTexture.f_118083_, entity.m_19879_() + mode.ordinal());
            matrixStack.m_85849_();
        }
    }
}

