/*
 * Decompiled with CFR 0.152.
 */
package net.sistr.littlemaidmodelloader.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModel;
import net.sistr.littlemaidmodelloader.client.renderer.MultiModelRenderLayer;
import net.sistr.littlemaidmodelloader.entity.compound.IHasMultiModel;
import net.sistr.littlemaidmodelloader.maidmodel.IModelCaps;
import net.sistr.littlemaidmodelloader.multimodel.layer.MMRenderContext;

@OnlyIn(value=Dist.CLIENT)
public class MultiModelArmorLayer<T extends LivingEntity, M extends MultiModel<T>>
extends RenderLayer<T, M> {
    public MultiModelArmorLayer(RenderLayerParent<T, M> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("littlemaidmodelloader:mm_armor_layer");
        this.renderArmorPart(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, IHasMultiModel.Part.HEAD);
        this.renderArmorPart(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, IHasMultiModel.Part.BODY);
        this.renderArmorPart(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, IHasMultiModel.Part.LEGS);
        this.renderArmorPart(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, IHasMultiModel.Part.FEET);
        profiler.m_7238_();
    }

    private void renderArmorPart(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, IHasMultiModel.Part part) {
        if (!((IHasMultiModel)entity).isArmorVisible(part)) {
            return;
        }
        boolean glint = ((IHasMultiModel)entity).isArmorGlint(part);
        IModelCaps caps = ((IHasMultiModel)entity).getCaps();
        this.renderArmorLayer(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, part, IHasMultiModel.Layer.INNER, false, caps, glint);
        this.renderArmorLayer(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, part, IHasMultiModel.Layer.INNER, true, caps, glint);
        this.renderArmorLayer(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, part, IHasMultiModel.Layer.OUTER, false, caps, glint);
        this.renderArmorLayer(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch, part, IHasMultiModel.Layer.OUTER, true, caps, glint);
    }

    private void renderArmorLayer(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, IHasMultiModel.Part part, IHasMultiModel.Layer layer, boolean isLight, IModelCaps caps, boolean glint) {
        ((IHasMultiModel)entity).getTexture(layer, part, isLight).ifPresent(resourceLocation -> ((IHasMultiModel)entity).getModel(layer, part).ifPresent(model -> {
            model.showArmorParts(part.getIndex(), layer.getPartIndex());
            RenderType type = MultiModelRenderLayer.getDefault(resourceLocation);
            VertexConsumer builder = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumers, (RenderType)type, (boolean)false, (boolean)glint);
            int light0 = isLight ? 0xF00000 : light;
            model.animateModel(caps, limbAngle, limbDistance, tickDelta);
            model.setAngles(caps, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            model.render(new MMRenderContext(matrices, builder, light0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f));
        }));
    }
}

